/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv;

import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.BNiagaraVirtualPolicies;
import com.tridium.nv.BSlotInfo;
import com.tridium.nv.INiagaraVirtualCommsAdapter;
import com.tridium.nv.INiagaraVirtualStationAdapter;
import com.tridium.nv.NiagaraVirtualAddOp;
import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.nv.cache.BNiagaraVirtualCache;
import com.tridium.sys.schema.ComponentSlotMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

public abstract class BNiagaraVirtualGateway
extends BVirtualGateway {
    public static final Action refresh = BNiagaraVirtualGateway.newAction((int)256, null);
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualGateway.class);
    private boolean licensed = false;
    private INiagaraVirtualStationAdapter adapter;
    private IVirtualRootFactory rootFactory = new DefaultVirtualRootFactory();
    private BIcon icon = null;
    private INiagaraVirtualCommsAdapter commsAdapter;
    private static Type NIAGARA_NETWORK_TYPE;
    private static final String PERSIST_FETCHED_TAGS_PROP_NAME = "persistVirtualFetchedTags";
    private static final Version PRELOAD_CONTROL_POINT_OUT_VERSION;

    public void refresh() {
        this.invoke(refresh, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11) {
            this.fwNvStarted();
        }
        return super.fw(x, a, b, c, d);
    }

    private final void fwNvStarted() {
        this.licensed = this.getNiagaraVirtualPolicies().isLicensed();
    }

    public final BIcon getIcon() {
        if (this.icon == null) {
            return super.getIcon();
        }
        return this.icon;
    }

    public final void setIcon(BIcon icon) {
        this.icon = icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doClientClosed() {
        BNiagaraVirtualComponent c = this.getRootComponent();
        if (c != null) {
            Array pointArray = new Array(BNiagaraVirtualComponent.class);
            NiagaraVirtualUtil.findVirtualComponents((Array<BNiagaraVirtualComponent>)pointArray, c);
            BNiagaraVirtualComponent[] comps = (BNiagaraVirtualComponent[])pointArray.trim();
            Object object = this.adapter.getStateLock();
            synchronized (object) {
                for (int i = 0; i < comps.length; ++i) {
                    comps[i].close();
                }
            }
        }
    }

    protected final Property addVirtualSlot(BVirtualComponent parent, String virtualPathName) {
        BNiagaraVirtualComponent vParent = (BNiagaraVirtualComponent)parent;
        BOrd vOrd = vParent.formVirtualOrd(virtualPathName);
        if (this.commsAdapter.isTraceOn()) {
            this.commsAdapter.trace("Add Virtual Slot: invoking ensureVirtualsLoaded");
        }
        this.ensureVirtualsLoaded(new BOrd[]{vOrd});
        return vParent.getProperty(VirtualPath.toSlotPathName((String)virtualPathName));
    }

    public final void loadVirtualSlots(BVirtualComponent parent) {
        this.loadVirtualSlots(((BNiagaraVirtualComponent)parent).getNiagaraVirtualCompInfo().getSlotOrd(), parent);
    }

    private void loadVirtualSlots(BOrd startOrd, BVirtualComponent parent) {
        FullSlotInfo[] infos;
        if (this.commsAdapter.isTraceOn()) {
            this.commsAdapter.trace("Load Virtual Slots: " + startOrd + " -> " + parent.getName());
        }
        BNiagaraVirtualComponent vParent = (BNiagaraVirtualComponent)parent;
        if (this.adapter.getStationStatus().isDisabled()) {
            vParent.discoveryFail("Niagara Station is disabled (" + Sys.getStation().getStationName() + ") -> " + this.adapter.getStationName(), false);
            return;
        }
        if (!this.adapter.isVirtualsEnabled()) {
            vParent.discoveryFail("Niagara Virtual Components are disabled (" + Sys.getStation().getStationName() + ") -> " + this.adapter.getStationName(), false);
            return;
        }
        if (!this.isLicensed()) {
            vParent.discoveryFail("Niagara Virtual Components are not licensed! (" + Sys.getStation().getStationName() + ")", true);
            return;
        }
        try {
            infos = this.getComms().loadSlots(startOrd, "loadVirtualSlots: " + vParent.getVirtualOrd().toString());
            vParent.niagaraVirtualCompCheckActions();
            vParent.discoveryOk();
        }
        catch (Exception e) {
            String msg = Objects.toString(e.getMessage(), "");
            vParent.discoveryFail(msg, true);
            this.commsAdapter.error("Load Virtual Slots: Opening Connection for loadSlots: " + msg, e);
            return;
        }
        ArrayList<String> propNameArray = new ArrayList<String>(infos.length);
        HashSet<BNiagaraVirtualComponent> addedComps = new HashSet<BNiagaraVirtualComponent>(infos.length);
        BNiagaraVirtualCache cache = this.getNiagaraVirtualPolicies().getCache();
        boolean reorder = false;
        for (FullSlotInfo fullSlotInfo : infos) {
            Optional<BNiagaraVirtualComponent> optComp;
            BSlotInfo slotInfo = fullSlotInfo.getSlotInfo();
            String newName = slotInfo.getSlotName();
            NiagaraVirtualAddOp op = this.updateCacheAndMakeAddOp(newName, slotInfo, cache, vParent);
            if (op.run(vParent) == null) {
                reorder = true;
            }
            if ((optComp = op.getAddedComponent()).isPresent()) {
                BNiagaraVirtualComponent comp = optComp.get();
                addedComps.add(comp);
                for (BSlotInfo childSlotInfo : fullSlotInfo.getChildren()) {
                    this.updateCacheAndMakeAddOp(childSlotInfo.getSlotName(), childSlotInfo, cache, comp).run(comp);
                }
            }
            propNameArray.add(newName);
        }
        for (BNiagaraVirtualComponent comp : addedComps) {
            this.invokeFwInitialized(comp);
        }
        if (reorder) {
            Property[] orgProps;
            for (Property prop : orgProps = vParent.getDynamicPropertiesArray()) {
                if (!prop.isAction()) continue;
                propNameArray.add(prop.getName());
            }
            Property[] dynPropsArray = vParent.getDynamicPropertiesArray();
            ArrayList dynProps = new ArrayList(dynPropsArray.length);
            Collections.addAll(dynProps, dynPropsArray);
            dynProps.sort((p1, p2) -> {
                int index1 = -1;
                int index2 = -1;
                for (int i = 0; i < propNameArray.size(); ++i) {
                    String propName = (String)propNameArray.get(i);
                    if (propName.equals(p1.getName())) {
                        index1 = i;
                    } else if (propName.equals(p2.getName())) {
                        index2 = i;
                    }
                    if (index1 > -1 && index2 > -1) break;
                }
                return index1 > index2 ? 1 : -1;
            });
            vParent.reorder(dynProps.toArray(new Property[dynProps.size()]));
        }
    }

    private NiagaraVirtualAddOp updateCacheAndMakeAddOp(String newName, BSlotInfo slotInfo, BNiagaraVirtualCache cache, BNiagaraVirtualComponent vParent) {
        try {
            cache.update(this.adapter.getStationName(), vParent.formVirtualOrd(VirtualPath.toVirtualPathName((String)newName)), slotInfo);
        }
        catch (Exception e) {
            this.adapter.getLog().log(Level.SEVERE, "Load Virtual Slots: Updating Cache with Slot Information " + slotInfo.getName(), e);
        }
        return NiagaraVirtualAddOp.make(slotInfo, newName);
    }

    protected final BVirtualComponent makeVirtualRoot() {
        return this.rootFactory.makeVirtualRoot();
    }

    public final void ensureVirtualsLoaded(BOrd[] virtualOrds) {
        BOrd vOrd2;
        if (!this.isLicensed()) {
            return;
        }
        if (!this.adapter.isVirtualsEnabled()) {
            return;
        }
        if (this.adapter.getStationStatus().isDisabled()) {
            return;
        }
        boolean preLoadControlPointOut = this.adapter.getStationVersion(PRELOAD_CONTROL_POINT_OUT_VERSION).compareTo(PRELOAD_CONTROL_POINT_OUT_VERSION) >= 0;
        LinkedHashMap<BOrd, NiagaraVirtualAddOp> opMap = new LinkedHashMap<BOrd, NiagaraVirtualAddOp>();
        for (BOrd ord : virtualOrds) {
            BNiagaraVirtualComponent clx;
            VirtualPath vPath;
            if (this.adapter.getLog().isLoggable(Level.FINE)) {
                this.adapter.getLog().fine("Ensure Virtuals Loaded: Loading ORD: " + ord);
            }
            if ((vPath = NiagaraVirtualUtil.toVirtualPath(ord)) == null || "/".equals(vPath.getBody())) continue;
            BNiagaraVirtualComponent value = clx = this.getRootComponent();
            String[] names = vPath.getNames();
            for (int i = 0; i < names.length; ++i) {
                Property prop = clx.getProperty(VirtualPath.toSlotPathName((String)names[i]));
                Object object = value = prop != null ? clx.get(prop) : null;
                if (value == null) {
                    for (int x = i; x < names.length; ++x) {
                        StringBuilder newPathBuff = new StringBuilder();
                        for (int j = 0; j <= x; ++j) {
                            newPathBuff.append("/").append(names[j]);
                        }
                        vOrd2 = BOrd.make((OrdQuery)new VirtualPath(newPathBuff.toString()));
                        opMap.put(vOrd2, null);
                    }
                    break;
                }
                if (!value.isComplex()) break;
                clx = (BComplex)value;
            }
            if (preLoadControlPointOut || value != null && (!value.isComponent() || value.asComponent().get("out") != null)) continue;
            opMap.put(BOrd.make((String)(vPath.toString() + "/out")), null);
        }
        if (opMap.isEmpty()) {
            return;
        }
        HashSet<BNiagaraVirtualComponent> addedComps = new HashSet<BNiagaraVirtualComponent>();
        String stationName = this.adapter.getStationName();
        BNiagaraVirtualCache cache = this.getNiagaraVirtualPolicies().getCache();
        ArrayList<BOrd> vFoxOrdArray = new ArrayList<BOrd>();
        boolean addedFromCache = false;
        Iterator it = opMap.keySet().iterator();
        while (it.hasNext()) {
            BOrd vOrd3 = (BOrd)it.next();
            BSlotInfo info = null;
            try {
                info = cache.lookup(stationName, vOrd3);
            }
            catch (Exception e) {
                this.adapter.getLog().log(Level.SEVERE, "Ensure Virtuals Loaded: Error looking up from Cache: " + vOrd3, e);
            }
            if (info == null) {
                vFoxOrdArray.add(vOrd3);
                if (!this.adapter.getLog().isLoggable(Level.FINE)) continue;
                this.adapter.getLog().fine("Ensure Virtuals Loaded: Could not find in Niagara Virtual Cache: " + vOrd3);
                continue;
            }
            VirtualPath vPath = NiagaraVirtualUtil.toVirtualPath(vOrd3);
            BValue val = NiagaraVirtualUtil.resolvePath((BComplex)this.getRootComponent(), vPath.getParent());
            NiagaraVirtualAddOp addOp = NiagaraVirtualAddOp.make(info, NiagaraVirtualUtil.getSlotNameFromVirtualPath(vPath));
            if (val != null && val instanceof BNiagaraVirtualComponent && !info.getIsNiagaraVirtual()) {
                addOp.run((BNiagaraVirtualComponent)val);
                Optional<BNiagaraVirtualComponent> optComp = addOp.getAddedComponent();
                if (optComp.isPresent()) {
                    addedComps.add(optComp.get());
                }
                it.remove();
                addedFromCache = true;
                if (!this.adapter.getLog().isLoggable(Level.FINE)) continue;
                if (NiagaraVirtualUtil.resolvePath((BComplex)this.getRootComponent(), (SlotPath)NiagaraVirtualUtil.toVirtualPath(vOrd3)) == null) {
                    this.adapter.getLog().fine("Ensure Virtuals Loaded: Unable to Add from Cache: " + vOrd3);
                    continue;
                }
                this.adapter.getLog().fine("Ensure Virtuals Loaded: Added from Cache: " + vOrd3);
                continue;
            }
            if (info.getIsNiagaraVirtual()) {
                vFoxOrdArray.add(vOrd3);
            }
            opMap.put(vOrd3, addOp);
            if (!this.adapter.getLog().isLoggable(Level.FINE)) continue;
            if (info.getIsNiagaraVirtual()) {
                this.adapter.getLog().fine("Ensure Virtuals Loaded: Loading Niagara Virtual to Niagara Virtual through Batch network call: " + vOrd3);
                continue;
            }
            this.adapter.getLog().fine("Ensure Virtuals Loaded: Found in Cache but could not find parent: " + vOrd3);
        }
        if (!vFoxOrdArray.isEmpty()) {
            if (addedFromCache) {
                LinkedHashMap<BOrd, NiagaraVirtualAddOp> map = opMap;
                vFoxOrdArray.removeIf(o -> {
                    boolean resolved;
                    boolean bl = resolved = NiagaraVirtualUtil.resolvePath((BComplex)this.getRootComponent(), (SlotPath)NiagaraVirtualUtil.toVirtualPath(o)) != null;
                    if (resolved) {
                        map.remove(o);
                        if (this.adapter.getLog().isLoggable(Level.FINE)) {
                            this.adapter.getLog().fine("Ensure Virtuals Loaded: Now resolves (from prior Add): " + o);
                        }
                    }
                    return resolved;
                });
            }
            if (!(vFoxOrdArray.isEmpty() || this.adapter.getStationStatus().isDown() || this.adapter.getStationStatus().isFault())) {
                PartialSlotInfo[] partialInfos = null;
                try {
                    partialInfos = this.getComms().loadPartial(this.getRootComponent().getNiagaraVirtualCompInfo().getSlotOrd(), vFoxOrdArray.toArray(new BOrd[vFoxOrdArray.size()]), "ensureVirtualsLoaded");
                }
                catch (Exception e) {
                    this.commsAdapter.error("Opening Connection for partially loading virtual information", e);
                }
                if (partialInfos != null) {
                    for (PartialSlotInfo info : partialInfos) {
                        VirtualPath vPath = NiagaraVirtualUtil.fromServerOrdToClientVirtual(this.getRootComponent().getNiagaraVirtualCompInfo().getSlotOrd(), info.getOrd());
                        vOrd2 = BOrd.make((OrdQuery)vPath);
                        NiagaraVirtualAddOp op2 = NiagaraVirtualAddOp.make(info.getSlotInfo(), NiagaraVirtualUtil.getSlotNameFromVirtualPath(vPath));
                        opMap.put(vOrd2, op2);
                        cache.update(this.adapter.getStationName(), vOrd2, info.getSlotInfo());
                    }
                }
            }
        }
        opMap.forEach((vOrd, op) -> {
            BValue val;
            if (op != null && (val = NiagaraVirtualUtil.resolvePath((BComplex)this.getRootComponent(), NiagaraVirtualUtil.toVirtualPath(vOrd).getParent())) != null && val instanceof BNiagaraVirtualComponent) {
                op.run((BNiagaraVirtualComponent)val);
                Optional<BNiagaraVirtualComponent> optComp = op.getAddedComponent();
                if (optComp.isPresent()) {
                    addedComps.add(optComp.get());
                }
            }
            if (this.adapter.getLog().isLoggable(Level.FINE)) {
                if (NiagaraVirtualUtil.resolvePath((BComplex)this.getRootComponent(), (SlotPath)NiagaraVirtualUtil.toVirtualPath(vOrd)) == null) {
                    this.adapter.getLog().fine("Ensure Virtuals Loaded: Unable to Add: " + vOrd);
                } else {
                    this.adapter.getLog().fine("Ensure Virtuals Loaded: Added: " + vOrd);
                }
            }
        });
        for (BNiagaraVirtualComponent comp : addedComps) {
            this.invokeFwInitialized(comp);
        }
    }

    public final BNiagaraVirtualPolicies getNiagaraVirtualPolicies() {
        return this.adapter.getNiagaraVirtualPolicies();
    }

    private void invokeFwInitialized(BNiagaraVirtualComponent comp) {
        try {
            comp.fwVirtualInitialized();
        }
        catch (Exception err) {
            this.adapter.getLog().log(Level.SEVERE, "Invoking virtual initialization callback", err);
        }
    }

    public final void doRefresh() {
        if (!this.adapter.getStationStatus().isDisabled() && this.adapter.isVirtualsEnabled() && this.isLicensed()) {
            HashSet<BNiagaraVirtualComponent> set = new HashSet<BNiagaraVirtualComponent>();
            this.findFirstNiagaraVirtualGateways(set, this.getRootComponent());
            BNiagaraVirtualComponent[] gateways = set.toArray(new BNiagaraVirtualComponent[set.size()]);
            for (int i = 0; i < gateways.length; ++i) {
                gateways[i].niagaraVirtualCompCheckActions();
                Action action = gateways[i].getAction("refresh");
                if (action == null) continue;
                try {
                    gateways[i].invoke(action, null);
                    continue;
                }
                catch (ActionInvokeException actionInvokeException) {
                    // empty catch block
                }
            }
            this.reloadAllLoadedComponents(this.getRootComponent());
        } else {
            BNiagaraVirtualComponent root = this.getRootComponent();
            root.removeAll();
            this.loadVirtualSlots(root.getNiagaraVirtualCompInfo().getSlotOrd(), root);
        }
    }

    private final void reloadAllLoadedComponents(BNiagaraVirtualComponent comp) {
        if (((ComponentSlotMap)comp.fw(1)).isBrokerPropsLoaded()) {
            this.loadVirtualSlots(comp.getNiagaraVirtualCompInfo().getSlotOrd(), comp);
            comp.unsubscribeHandlers();
            comp.reloadActionsIfLoaded();
            BNiagaraVirtualComponent[] kids = (BNiagaraVirtualComponent[])comp.getChildren(BNiagaraVirtualComponent.class);
            for (int i = 0; i < kids.length; ++i) {
                this.reloadAllLoadedComponents(kids[i]);
            }
        }
    }

    private final void findFirstNiagaraVirtualGateways(Set<BNiagaraVirtualComponent> set, BNiagaraVirtualComponent comp) {
        Type type = null;
        try {
            type = Sys.getType((String)comp.getTypeSpec());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null && type.is(TYPE)) {
            set.add(comp);
        } else {
            BNiagaraVirtualComponent[] kids = (BNiagaraVirtualComponent[])comp.getChildren(BNiagaraVirtualComponent.class);
            for (int i = 0; i < kids.length; ++i) {
                this.findFirstNiagaraVirtualGateways(set, kids[i]);
            }
        }
    }

    public final void doDeviceStatusChanged() {
        BNiagaraVirtualComponent c = this.getRootComponent();
        Array pointArray = new Array(BNiagaraVirtualComponent.class);
        NiagaraVirtualUtil.findVirtualComponents((Array<BNiagaraVirtualComponent>)pointArray, c);
        BNiagaraVirtualComponent[] comps = (BNiagaraVirtualComponent[])pointArray.trim();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].niagaraVirtualCompDeviceStatusChanged();
        }
    }

    public final boolean isLicensed() {
        if (!this.licensed) {
            this.adapter.getLog().log(Level.SEVERE, "*** Niagara Virtual Components not licensed! ***");
        }
        return this.licensed;
    }

    public final BNiagaraVirtualComponent[] getNiagaraVirtualComponents() {
        Array a = new Array(BNiagaraVirtualComponent.class);
        NiagaraVirtualUtil.findVirtualComponents((Array<BNiagaraVirtualComponent>)a, this.getRootComponent());
        return (BNiagaraVirtualComponent[])a.trim();
    }

    public final BNiagaraVirtualComponent getRootComponent() {
        BComponentSpace space = this.getVirtualSpace();
        return space == null ? null : (BNiagaraVirtualComponent)space.getRootComponent();
    }

    public final INiagaraVirtualStationAdapter getStationAdapter() {
        return this.adapter;
    }

    public final void setStationAdapter(INiagaraVirtualStationAdapter adapter) {
        this.adapter = adapter;
    }

    public final INiagaraVirtualCommsAdapter getComms() {
        return this.commsAdapter;
    }

    public final void setCommsAdapter(INiagaraVirtualCommsAdapter commsAdapter) {
        this.commsAdapter = commsAdapter;
    }

    public final void setVirtualRootFactory(IVirtualRootFactory rootFactory) {
        this.rootFactory = rootFactory;
    }

    public final String tagsToFetch() {
        String additionalTags;
        BString tagList = (BString)NiagaraVirtualUtil.lookupPropertyFromAncestry((BComplex)this, "tagsToFetch", BString.TYPE, BNiagaraVirtualGateway.getNiagaraNetworkType());
        if (tagList != null && !(additionalTags = tagList.toString().trim()).isEmpty()) {
            return additionalTags + ';' + "n:history";
        }
        return "n:history";
    }

    public final boolean persistFetchedTags() {
        BBoolean persistTags = (BBoolean)NiagaraVirtualUtil.lookupPropertyFromAncestry((BComplex)this, PERSIST_FETCHED_TAGS_PROP_NAME, BBoolean.TYPE, BNiagaraVirtualGateway.getNiagaraNetworkType());
        return persistTags != null && persistTags.getBoolean();
    }

    private static Type getNiagaraNetworkType() {
        if (NIAGARA_NETWORK_TYPE == null) {
            NIAGARA_NETWORK_TYPE = BTypeSpec.make((String)"niagaraDriver", (String)"NiagaraNetwork").getResolvedType();
        }
        return NIAGARA_NETWORK_TYPE;
    }

    static {
        PRELOAD_CONTROL_POINT_OUT_VERSION = new Version("4.4");
    }

    private static final class DefaultVirtualRootFactory
    implements IVirtualRootFactory {
        private DefaultVirtualRootFactory() {
        }

        @Override
        public BNiagaraVirtualComponent makeVirtualRoot() {
            BNiagaraVirtualComponent root = new BNiagaraVirtualComponent();
            root.getNiagaraVirtualCompInfo().setSlotOrd(BOrd.make((String)"station:|slot:/"));
            root.setIcon(BIcon.std((String)"database.png"));
            return root;
        }
    }

    public static interface IVirtualRootFactory {
        public BNiagaraVirtualComponent makeVirtualRoot();
    }

    public static final class FullSlotInfo {
        private BSlotInfo info;
        private List<BSlotInfo> kids;

        public FullSlotInfo(BSlotInfo info, List<BSlotInfo> kids) {
            this.info = info;
            this.kids = kids;
        }

        public BSlotInfo getSlotInfo() {
            return this.info;
        }

        public List<BSlotInfo> getChildren() {
            return this.kids;
        }
    }

    public static final class PartialSlotInfo {
        private final BOrd ord;
        private final BSlotInfo info;

        public PartialSlotInfo(BOrd ord, BSlotInfo info) {
            this.ord = ord;
            this.info = info;
        }

        public BOrd getOrd() {
            return this.ord;
        }

        public BSlotInfo getSlotInfo() {
            return this.info;
        }
    }
}

