/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.util;

import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWorker;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

public class BBasicWorker
extends BWorker {
    public static final Property maxQueueSize = BBasicWorker.newProperty((int)0, (int)256, null);
    public static final Type TYPE = Sys.loadType(BBasicWorker.class);
    private Queue queue = null;
    private Worker worker = null;

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final IFuture post(Runnable r) {
        if (!this.isRunning() || this.queue == null) {
            throw new NotRunningException();
        }
        this.queue.enqueue((Object)r);
        return null;
    }

    protected Queue makeQueue(int size) {
        return new Queue(size);
    }

    public final Worker getWorker() {
        if (this.worker == null) {
            this.queue = this.makeQueue(this.getMaxQueueSize());
            this.worker = new Worker((Worker.ITodo)this.queue);
        }
        return this.worker;
    }

    public int getSize() {
        return this.queue.size();
    }

    public int getMaxSize() {
        return this.queue.maxSize();
    }

    protected String getWorkerThreadName() {
        return "BscWkr:" + this.getParent().getName() + ":" + this.getName();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(maxQueueSize) && this.queue != null) {
            this.stopWorker();
            this.queue = null;
            this.worker = null;
            this.getWorker();
            this.startWorker();
        }
    }

    protected final void basicWorkerChanged(Property property, Context context) {
    }
}

