/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.util;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.sys.BStruct;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BBasicPollGroup
extends BStruct
implements BIBasicPollable {
    public static final Type TYPE = Sys.loadType(BBasicPollGroup.class);
    static HashMap<Integer, Hashtable<Object, BBasicPollGroup>> typesToCodes = new HashMap();
    Object code = null;
    Vector<BBasicProxyExt> mySubscribedProxies = new Vector(8);
    Vector<BBasicProxyExt> myProxies = new Vector(8);
    boolean subscribed = false;

    public Type getType() {
        return TYPE;
    }

    public Object getCode() {
        return this.code;
    }

    protected final BBasicProxyExt[] getProxyExts() {
        BBasicProxyExt[] pexts = new BBasicProxyExt[this.myProxies.size()];
        this.myProxies.copyInto((Object[])pexts);
        return pexts;
    }

    protected final BBasicProxyExt[] getSubscribedProxyExts() {
        BBasicProxyExt[] pexts = new BBasicProxyExt[this.mySubscribedProxies.size()];
        this.mySubscribedProxies.copyInto((Object[])pexts);
        return pexts;
    }

    public void registerProxy(BBasicProxyExt proxy) {
        if (!this.myProxies.contains((Object)proxy)) {
            this.myProxies.add(proxy);
        }
    }

    public void unregisterProxy(BBasicProxyExt proxy) {
        try {
            this.readUnsubscribed(proxy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myProxies.remove((Object)proxy);
        Type pgType = proxy.getPollGroupType();
        Object pgCode = proxy.getPollGroupCode();
        Hashtable<Object, BBasicPollGroup> codesToGroups = typesToCodes.get(pgType.getId());
        if (codesToGroups != null) {
            BBasicPollGroup pg = codesToGroups.get(pgCode);
            if (pg != null) {
                codesToGroups.remove(pgCode);
            }
            if (codesToGroups.size() < 1) {
                typesToCodes.remove(pgType.getId());
            }
        }
    }

    public void readSubscribed(BBasicProxyExt proxy) throws Exception {
        if (!this.mySubscribedProxies.contains((Object)proxy)) {
            this.mySubscribedProxies.add(proxy);
        }
        if (!this.subscribed) {
            ((BBasicNetwork)proxy.getNetwork()).getPollScheduler().subscribe((BIPollable)this);
            this.subscribed = true;
        }
    }

    public void readUnsubscribed(BBasicProxyExt proxy) throws Exception {
        this.mySubscribedProxies.remove((Object)proxy);
        if (this.mySubscribedProxies.size() == 0) {
            ((BBasicNetwork)proxy.getNetwork()).getPollScheduler().unsubscribe((BIPollable)this);
            this.subscribed = false;
        }
    }

    @Override
    public abstract void poll();

    public BPollFrequency getPollFrequency() {
        BPollFrequency fastestYet = BPollFrequency.slow;
        for (BBasicProxyExt proxy : this.mySubscribedProxies) {
            BPollFrequency fr;
            if (!(proxy instanceof BIPollable) || (fr = ((BIPollable)proxy).getPollFrequency()).compareTo((Object)fastestYet) >= 0) continue;
            fastestYet = fr;
        }
        return fastestYet;
    }

    public static BBasicPollGroup getPollGroup(BBasicProxyExt proxy) {
        BBasicPollGroup pg;
        Type pgType = proxy.getPollGroupType();
        Object pgCode = proxy.getPollGroupCode();
        Hashtable<Object, BBasicPollGroup> codesToGroups = typesToCodes.get(pgType.getId());
        if (codesToGroups == null) {
            codesToGroups = new Hashtable();
            typesToCodes.put(pgType.getId(), codesToGroups);
        }
        if ((pg = codesToGroups.get(pgCode)) == null) {
            pg = (BBasicPollGroup)pgType.getInstance();
            pg.code = pgCode;
            codesToGroups.put(pgCode, pg);
        }
        return pg;
    }
}

