/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.discover.dns;

import com.tridium.naxisVideo.discover.dns.DnsHeader;
import com.tridium.naxisVideo.discover.dns.DnsQuestion;
import com.tridium.naxisVideo.discover.dns.DnsResourceRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.Array;
import javax.baja.sys.Clock;

public class DnsMessage {
    private String address;
    private int port;
    private DnsHeader header;
    private Array<DnsQuestion> questions = new Array(DnsQuestion.class);
    private Array<DnsResourceRecord> answers = new Array(DnsResourceRecord.class);
    private Array<DnsResourceRecord> authorities = new Array(DnsResourceRecord.class);
    private Array<DnsResourceRecord> additionals = new Array(DnsResourceRecord.class);
    private static final int PTR_TYPE = 12;
    private static final int SRV_TYPE = 33;
    private static final int IN_CLASS = 1;
    private static final String MULTICAST_ADDRESS = "224.0.0.251";
    private static final int MULTICAST_PORT = 5353;
    private static final Logger logger = Logger.getLogger("NAxisVideo");

    public DnsMessage[] send(InetAddress group, int port, long timeout) throws IOException {
        Array responses = new Array(DnsMessage.class);
        try (MulticastSocket socket = new MulticastSocket(port);){
            socket.setSoTimeout((int)timeout);
            socket.joinGroup(group);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            this.write(dos);
            byte[] buf_send = bos.toByteArray();
            DatagramPacket request = new DatagramPacket(buf_send, buf_send.length, group, port);
            socket.send(request);
            long start = Clock.millis();
            byte[] buf_recv = new byte[512];
            DatagramPacket response = new DatagramPacket(buf_recv, buf_recv.length);
            DnsMessage responseMessage = null;
            while (Clock.millis() - start < timeout) {
                try {
                    socket.receive(response);
                    while (response.getLength() == request.getLength()) {
                        socket.receive(response);
                    }
                    responseMessage = DnsMessage.readMessage(response);
                    responses.add((Object)responseMessage);
                }
                catch (Exception e) {}
            }
            socket.leaveGroup(group);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception raised while establish the connection with the MulticastSocket.", e);
        }
        return (DnsMessage[])responses.trim();
    }

    public DnsMessage[] send(long timeout) throws IOException {
        DnsMessage[] responses = this.send(InetAddress.getByAddress(new byte[]{-32, 0, 0, -5}), 5353, timeout);
        return responses;
    }

    public static DnsMessage readMessage(DataInput in) throws IOException {
        DnsMessage message = new DnsMessage();
        message.read(in);
        return message;
    }

    public static DnsMessage readMessage(DatagramPacket packet) throws IOException {
        DnsMessage message = new DnsMessage();
        ByteArrayInputStream bis = new ByteArrayInputStream(packet.getData());
        DataInputStream dis = new DataInputStream(bis);
        message.read(dis);
        return message;
    }

    public static DnsMessage makeRequestMessage(String qName, int qType, int qClass) throws IOException {
        DnsMessage message = new DnsMessage();
        message.header = DnsHeader.makeMulticastDnsQueryHeader();
        DnsQuestion question = DnsQuestion.makeQuestion(qName, qType, qClass);
        message.questions.add((Object)question);
        return message;
    }

    public static DnsMessage make_PTR_RequestMessage(String qName) throws IOException {
        return DnsMessage.makeRequestMessage(qName, 12, 1);
    }

    public static DnsMessage make_SRV_RequestMessage(String qName) throws IOException {
        return DnsMessage.makeRequestMessage(qName, 33, 1);
    }

    public void read(DataInput in) throws IOException {
        this.header = DnsHeader.readHeader(in);
        int questionCount = this.header.getQuestionCount();
        for (int i = 0; i < questionCount; ++i) {
            DnsQuestion question = DnsQuestion.readQuestion(in);
            this.addQuestion(question);
        }
        int answerCount = this.header.getAnswerCount();
        for (int i = 0; i < answerCount; ++i) {
            DnsResourceRecord answer = DnsResourceRecord.readResourceRecord(in);
            this.addAnswer(answer);
        }
        int authorityCount = this.header.getAuthorityCount();
        for (int i = 0; i < authorityCount; ++i) {
            DnsResourceRecord authority = DnsResourceRecord.readResourceRecord(in);
            this.addAuthority(authority);
        }
        int additionalCount = this.header.getAdditionalRecordCount();
        for (int i = 0; i < additionalCount; ++i) {
            DnsResourceRecord additional = DnsResourceRecord.readResourceRecord(in);
            this.addAdditional(additional);
        }
    }

    public void write(DataOutput out) throws IOException {
        this.header.write(out);
        DnsQuestion[] questions = this.getQuestions();
        for (int i = 0; i < questions.length; ++i) {
            questions[i].write(out);
        }
        DnsResourceRecord[] answers = this.getAnswers();
        for (int i = 0; i < answers.length; ++i) {
            answers[i].write(out);
        }
        DnsResourceRecord[] authorities = this.getAuthorities();
        for (int i = 0; i < authorities.length; ++i) {
            authorities[i].write(out);
        }
        DnsResourceRecord[] additionals = this.getAdditionals();
        for (int i = 0; i < additionals.length; ++i) {
            additionals[i].write(out);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public DnsHeader getHeader() {
        return this.header;
    }

    public DnsQuestion[] getQuestions() {
        return (DnsQuestion[])this.questions.trim();
    }

    public void addQuestion(DnsQuestion question) {
        this.questions.add((Object)question);
    }

    public DnsResourceRecord[] getAnswers() {
        return (DnsResourceRecord[])this.answers.trim();
    }

    public void addAnswer(DnsResourceRecord answer) {
        this.answers.add((Object)answer);
    }

    public DnsResourceRecord[] getAuthorities() {
        return (DnsResourceRecord[])this.authorities.trim();
    }

    public void addAuthority(DnsResourceRecord authority) {
        this.authorities.add((Object)authority);
    }

    public DnsResourceRecord[] getAdditionals() {
        return (DnsResourceRecord[])this.additionals.trim();
    }

    public void addAdditional(DnsResourceRecord additional) {
        this.additionals.add((Object)additional);
    }
}

