/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.print;

import java.io.ByteArrayInputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.standard.PrinterName;

public class BLinePrinterRecipient
extends BAlarmRecipient
implements BIAlarmSource {
    public static final Property printer = BLinePrinterRecipient.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:LinePrinterFE")));
    public static final Property language = BLinePrinterRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)6)));
    public static final Property printFormat = BLinePrinterRecipient.newProperty((int)0, (BValue)BLinePrinterRecipient.makeDefaultPrintFormat(), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property alertOnFailure = BLinePrinterRecipient.newProperty((int)0, (boolean)false, null);
    public static final Property alarmSourceInfo = BLinePrinterRecipient.newProperty((int)0, (BValue)new BAlarmSourceInfo(), null);
    public static final Action ackAlarm = BLinePrinterRecipient.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action loadPrinters = BLinePrinterRecipient.newAction((int)0, null);
    public static final Topic printersLoaded = BLinePrinterRecipient.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BLinePrinterRecipient.class);
    private AlarmSupport support;
    private final Queue printQueue = new Queue();
    private final Worker printThread = new Worker((Worker.ITodo)this.printQueue);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"print.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    private static final Logger log = Logger.getLogger("alarm.printer");

    public BDynamicEnum getPrinter() {
        return (BDynamicEnum)this.get(printer);
    }

    public void setPrinter(BDynamicEnum v) {
        this.set(printer, (BValue)v, null);
    }

    public String getLanguage() {
        return this.getString(language);
    }

    public void setLanguage(String v) {
        this.setString(language, v, null);
    }

    public BFormat getPrintFormat() {
        return (BFormat)this.get(printFormat);
    }

    public void setPrintFormat(BFormat v) {
        this.set(printFormat, (BValue)v, null);
    }

    public boolean getAlertOnFailure() {
        return this.getBoolean(alertOnFailure);
    }

    public void setAlertOnFailure(boolean v) {
        this.setBoolean(alertOnFailure, v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public BBoolean ackAlarm(BAlarmRecord alert) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)alert, null);
    }

    public void loadPrinters() {
        this.invoke(loadPrinters, null, null);
    }

    public void firePrintersLoaded(BValue event) {
        this.fire(printersLoaded, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.printThread.start("alarm:printing");
    }

    public void stopped() throws Exception {
        this.printThread.stop();
    }

    public static BFormat makeDefaultPrintFormat() {
        StringBuffer buf = new StringBuffer();
        buf.append("Source:      %alarmData.sourceName%\n");
        buf.append("Timestamp:   %timestamp%\n");
        buf.append("State:       %sourceState% / %ackState%\n");
        buf.append("Priority:    %priority%\n");
        buf.append("Alarm Class: %alarmClass%\n");
        buf.append("Text:        %alarmData.msgText%\n");
        buf.append("\n");
        return BFormat.make((String)buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadPrinters() {
        ArrayList services = AccessController.doPrivileged(() -> {
            PrintService[] printers1 = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, null);
            ArrayList printerList = new ArrayList();
            Collections.addAll(printerList, printers1);
            return printerList;
        });
        String[] printerNames = new String[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            printerNames[i] = SlotPath.escape((String)((PrintService)services.get(i)).getName());
        }
        BEnumRange printers = BEnumRange.make((String[])printerNames);
        try {
            BDynamicEnum printerSelection;
            BDynamicEnum currentPrinter = this.getPrinter();
            if (currentPrinter.equals((Object)BDynamicEnum.DEFAULT)) {
                printerSelection = BDynamicEnum.make((int)0, (BEnumRange)printers);
            } else {
                BEnum printerEnum = printers.get(currentPrinter.getTag());
                printerSelection = BDynamicEnum.make((int)printerEnum.getOrdinal(), (BEnumRange)printers);
            }
            this.setPrinter(printerSelection);
        }
        catch (InvalidEnumException invalidEnumException) {
        }
        finally {
            this.firePrintersLoaded(null);
        }
    }

    public void handleAlarm(BAlarmRecord alarm) {
        if (alarm.getSource().equals((Object)BOrdList.make((BOrd)this.getNavOrd()))) {
            return;
        }
        log.fine("Enqueue");
        String printText = BFormat.make((String)this.getPrintFormat().format((Object)alarm)).format((Object)alarm);
        this.printQueue.enqueue((Object)new PrintJob(printText));
    }

    public BBoolean doAckAlarm(BAlarmRecord alert) {
        try {
            return BBoolean.make((boolean)this.support.ackAlarm(alert));
        }
        catch (Exception e) {
            return BBoolean.FALSE;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    private class PrintJob
    implements Runnable {
        String text;

        public PrintJob(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Dequeueing print job for " + SlotPath.unescape((String)BLinePrinterRecipient.this.getPrinter().getTag()));
            }
            try {
                HashAttributeSet aset = new HashAttributeSet();
                aset.add(new PrinterName(SlotPath.unescape((String)BLinePrinterRecipient.this.getPrinter().getTag()), null));
                ArrayList printers = AccessController.doPrivileged(() -> {
                    PrintService[] printers1 = PrintServiceLookup.lookupPrintServices(null, aset);
                    ArrayList printerList = new ArrayList();
                    Collections.addAll(printerList, printers1);
                    return printerList;
                });
                if (printers.size() < 1) {
                    throw new BajaRuntimeException("Printer '" + SlotPath.unescape((String)BLinePrinterRecipient.this.getPrinter().getTag()) + "' not found.");
                }
                DocPrintJob job = AccessController.doPrivileged(() -> ((PrintService)printers.get(0)).createPrintJob());
                String[] lines = TextUtil.replace((String)this.text, (String)"\n", (String)"\n\r").split("\n\r");
                StringBuilder textBuffer = new StringBuilder();
                for (int i = 0; i < lines.length; ++i) {
                    int length;
                    if (lines[i].length() < 80) {
                        textBuffer.append(lines[i]);
                        textBuffer.append("\n\r");
                        continue;
                    }
                    for (int start = 0; start < lines[i].length(); start += length) {
                        length = Math.min(80, lines[i].length() - start);
                        int cleanBreakLength = length;
                        if (start + cleanBreakLength < lines[i].length()) {
                            while (lines[i].charAt(start + cleanBreakLength - 1) != ' ' && cleanBreakLength > 1) {
                                --cleanBreakLength;
                            }
                            if (cleanBreakLength > 1) {
                                length = cleanBreakLength;
                            }
                        }
                        textBuffer.append(lines[i].substring(start, start + length));
                        textBuffer.append("\n\r");
                    }
                }
                job.print(new SimpleDoc(new ByteArrayInputStream(textBuffer.toString().getBytes()), DocFlavor.INPUT_STREAM.AUTOSENSE, null), null);
            }
            catch (Exception e) {
                BFacets facets = BLinePrinterRecipient.this.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
                facets = BFacets.make((BFacets)facets, (String)"msgText", (BIDataValue)BString.make((String)(SlotPath.unescape((String)BLinePrinterRecipient.this.getPrinter().getTag()) + " print error.")));
                try {
                    if (BLinePrinterRecipient.this.getAlertOnFailure()) {
                        BLinePrinterRecipient.this.support.newAlert(facets);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.log(Level.SEVERE, "Print error", e);
            }
        }
    }
}

