/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.velocity;

import com.tridium.velocity.HtmlEscaper;
import com.tridium.web.RequireJsUtil;
import com.tridium.web.WebUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.web.WebDev;

public final class VelocityContextUtil {
    private HtmlEscaper escaper = new HtmlEscaper();
    private Context cx;
    private boolean hasRequireJs = false;

    public VelocityContextUtil(Context cx) {
        this.cx = cx;
    }

    public ArrayList<BINavNode> getPath(Object navObj) {
        return this.getPath(navObj, null);
    }

    public ArrayList<BINavNode> getPath(Object navObj, Object base) {
        ArrayList<BINavNode> path = new ArrayList<BINavNode>();
        BUser user = this.cx.getUser();
        for (BINavNode parent = this.toNavNode(navObj, base); parent != null && !(parent instanceof BSpace); parent = parent.getNavParent()) {
            BPermissions permissions = user.getPermissionsFor((BIProtected)parent);
            path.add(0, parent);
        }
        return path;
    }

    public ArrayList<BValue> getChildren(Object compObj) {
        return this.getChildren(compObj, "baja:Value");
    }

    public ArrayList<BValue> getChildren(Object compObj, Object type) {
        Type t = Sys.getType((String)type.toString());
        BComplex comp = this.toComplex(compObj, null);
        Property[] props = comp.getPropertiesArray();
        BUser user = this.cx.getUser();
        ArrayList<BValue> list = new ArrayList<BValue>();
        for (int i = 0; i < props.length; ++i) {
            BValue value = comp.get(props[i]);
            if (!value.getType().is(t)) continue;
            if (value instanceof BIProtected) {
                BPermissions requiredPermissions;
                BPermissions permissions = user.getPermissionsFor((BIProtected)value);
                if (value.isComponent()) {
                    requiredPermissions = BPermissions.operatorRead;
                } else {
                    BPermissions bPermissions = requiredPermissions = Flags.isOperator((BComplex)comp, (Slot)props[i]) ? BPermissions.operatorRead : BPermissions.adminRead;
                }
                if (!permissions.has(requiredPermissions)) continue;
                list.add(value);
                continue;
            }
            list.add(value);
        }
        return list;
    }

    public boolean is(BObject value, Object type) {
        return value.getType().is(BTypeSpec.make((String)type.toString()).getTypeInfo());
    }

    public boolean isHidden(Object compObj, Object slotObj) {
        BPermissions permissions;
        Slot slot;
        BComplex complex = this.toComplex(compObj, null);
        if (Flags.isHidden((BComplex)complex, (Slot)(slot = this.toSlot(complex, slotObj)))) {
            return true;
        }
        if (complex instanceof BIProtected && !(permissions = this.cx.getUser().getPermissionsFor((BIProtected)complex)).hasOperatorRead()) {
            return true;
        }
        if (slot instanceof Property) {
            Property prop = (Property)slot;
            BValue value = complex.get(prop);
            if (value instanceof BWsAnnotation) {
                return true;
            }
            if (value instanceof BNameMap && prop.getName().equals("displayNames")) {
                return true;
            }
            if (value instanceof BLink) {
                return true;
            }
        }
        return false;
    }

    public boolean canRead(Object compObj) {
        BComponent comp = this.toComponent(compObj, null);
        BPermissions permissions = this.cx.getUser().getPermissionsFor((BIProtected)comp);
        return permissions.has(BPermissions.operatorRead);
    }

    public boolean canRead(Object compObj, Object slotObj) {
        BValue value;
        BComponent comp = this.toComponent(compObj, null);
        Slot slot = this.toSlot((BComplex)comp, slotObj);
        BUser user = this.cx.getUser();
        if (slot.isProperty() && (value = comp.get(slot.asProperty())) instanceof BComponent) {
            BPermissions permissions = user.getPermissionsFor((BIProtected)((BComponent)comp.get(slot.asProperty())));
            return permissions.has(BPermissions.operatorRead);
        }
        BPermissions permissions = user.getPermissionsFor((BIProtected)comp);
        BPermissions requiredPermissions = Flags.isOperator((BComplex)comp, (Slot)slot) ? BPermissions.operatorRead : BPermissions.adminRead;
        return permissions.has(requiredPermissions);
    }

    public boolean canWrite(Object compObj, Object slotObj) {
        BValue value;
        BComponent comp = this.toComponent(compObj, null);
        Slot slot = this.toSlot((BComplex)comp, slotObj);
        BUser user = this.cx.getUser();
        if (slot.isProperty() && (value = comp.get(slot.asProperty())) instanceof BComponent) {
            BPermissions permissions = user.getPermissionsFor((BIProtected)((BComponent)comp.get(slot.asProperty())));
            return permissions.has(BPermissions.operatorWrite);
        }
        BPermissions permissions = user.getPermissionsFor((BIProtected)comp);
        BPermissions requiredPermissions = Flags.isOperator((BComplex)comp, (Slot)slot) ? BPermissions.operatorWrite : BPermissions.adminWrite;
        return permissions.has(requiredPermissions);
    }

    public boolean canInvoke(Object compObj, Object slotObj) {
        BValue value;
        BComponent comp = this.toComponent(compObj, null);
        Slot slot = this.toSlot((BComplex)comp, slotObj);
        BUser user = this.cx.getUser();
        if (slot.isProperty() && (value = comp.get(slot.asProperty())) instanceof BComponent) {
            BPermissions permissions = user.getPermissionsFor((BIProtected)((BComponent)comp.get(slot.asProperty())));
            return permissions.has(BPermissions.operatorInvoke);
        }
        BPermissions permissions = user.getPermissionsFor((BIProtected)comp);
        BPermissions requiredPermissions = Flags.isOperator((BComplex)comp, (Slot)slot) ? BPermissions.operatorInvoke : BPermissions.adminInvoke;
        return permissions.has(requiredPermissions);
    }

    public String toUri(Object obj) throws UnsupportedEncodingException {
        BOrd ord = BOrd.NULL;
        if (obj instanceof BOrd) {
            ord = (BOrd)obj;
        } else if (obj instanceof BComponent) {
            ord = ((BComponent)obj).getNavOrd();
        } else if (obj instanceof BIcon) {
            BOrdList ordList = ((BIcon)obj).getOrdList();
            if (ordList.isNull()) {
                return "";
            }
            ord = ordList.get(0);
        } else {
            ord = BOrd.make((String)obj.toString());
        }
        if (ord.isNull()) {
            throw new BajaRuntimeException("Cannot create URI from: " + obj);
        }
        return WebUtil.toUri(null, (String)"/ord?", (BOrd)ord);
    }

    public Object get(Object ordObj) {
        return this.get(ordObj, null);
    }

    public Object get(Object ordObj, Object baseObj) {
        Object result = this.resolve(ordObj, baseObj).get();
        if (result instanceof BITable) {
            BITable table = (BITable)result;
            Column[] columns = table.getColumns().list();
            ArrayList<TableRow> list = new ArrayList<TableRow>();
            try (TableCursor cursor = table.cursor();){
                while (cursor.next()) {
                    list.add(new TableRow(cursor, columns));
                }
            }
            result = list;
        }
        return result;
    }

    public OrdTarget resolve(Object ordObj) {
        return this.resolve(ordObj, null);
    }

    public OrdTarget resolve(Object ordObj, Object baseObj) {
        BComponent comp;
        BOrd ord = BOrd.make((String)ordObj.toString());
        OrdTarget target = ord.resolve(this.fromBase(baseObj), this.cx);
        if (target.getComponent() != null && (comp = target.getComponent()).isMounted()) {
            comp.lease();
        }
        return target;
    }

    public BOrd ord(Object base, Object child) {
        return BOrd.make((BOrd)BOrd.make((String)base.toString()), (BOrd)BOrd.make((String)child.toString())).normalize();
    }

    public Lexicon lex(String moduleName) {
        return Lexicon.make((String)moduleName, (Context)this.cx);
    }

    public String escapeHtml(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.escaper.escapeHtml(obj.toString());
    }

    public String getDisplay(Object compObj) {
        return this.getDisplay(compObj, null);
    }

    public String getDisplay(Object compObj, Object base) {
        if (compObj instanceof BComplex) {
            BComplex parent;
            BComplex complex = this.toComplex(compObj, null);
            BComponent comp = complex.getParentComponent();
            if (comp != null && comp.isMounted()) {
                comp.lease();
            }
            if ((parent = complex.getParent()) != null) {
                return this.getDisplayFromProperty(parent, complex.getPropertyInParent(), base);
            }
            return complex.toString(this.cx);
        }
        OrdTarget target = this.resolve(compObj.toString(), base);
        if (target.getParent() != null) {
            return this.getDisplayFromProperty(target.getParent(), target.getPropertyInParent());
        }
        return target.get().toString(this.cx);
    }

    public String getDisplayFromProperty(Object compObj, Object propObj) {
        return this.getDisplayFromProperty(compObj, propObj, null);
    }

    public String getDisplayFromProperty(Object compObj, Object propObj, Object base) {
        Context context = this.cx;
        BComplex complex = this.toComplex(compObj, base);
        if (complex.isComponent() && complex.asComponent().isMounted()) {
            complex.asComponent().lease();
        }
        Property prop = propObj instanceof Property ? (Property)propObj : complex.getProperty(propObj.toString());
        context = this.mergeContextToComponent(complex, (Context)new BasicContext(context, complex.getSlotFacets((Slot)prop)));
        return complex.get(prop).toString(context);
    }

    private Context mergeContextToComponent(BComplex complex, Context cx) {
        if (complex == null) {
            return cx;
        }
        if (complex instanceof BComponent || complex.getParent() == null) {
            return cx;
        }
        cx = new BasicContext(cx, complex.getParent().getSlotFacets((Slot)complex.getPropertyInParent()));
        return this.mergeContextToComponent(complex.getParent(), cx);
    }

    public String getLastRegBuild() {
        return String.valueOf(Sys.getRegistry().getLastBuildTime().getMillis());
    }

    public String requirejs() throws IOException {
        this.hasRequireJs = true;
        StringWriter out = new StringWriter();
        RequireJsUtil.make((boolean)false, (Context)this.cx).requirejs((Writer)out);
        return out.toString();
    }

    public String requirejs(String mainOrd) throws IOException {
        this.hasRequireJs = true;
        StringWriter out = new StringWriter();
        RequireJsUtil.make((boolean)false, (Context)this.cx).requirejs(BOrd.make((String)mainOrd), (Writer)out);
        return out.toString();
    }

    public String requirejs(String mainOrd, String configFileOrd) throws IOException {
        this.hasRequireJs = true;
        StringWriter out = new StringWriter();
        RequireJsUtil.make((boolean)false, (Context)this.cx).requirejs(BOrd.make((String)mainOrd), BOrd.make((String)configFileOrd), (Writer)out);
        return out.toString();
    }

    public String startActivityMonitor() {
        return this.getActivityMonitorScript("start");
    }

    public String keepSessionAlive() {
        return this.getKeepAliveScript();
    }

    private String getKeepAliveScript() {
        if (this.hasRequireJs) {
            return "<script type='text/javascript'>require(['/module/web/rc/util/activityMonitor.js'], function(am){var token;am.keepAlive().then(function(t){token = t;});window.releaseKeepAliveToken = function(){am.release(token);}})</script>";
        }
        return "<script type='text/javascript' src='/module/web/rc/util/activityMonitor.js'></script><script>var token;activityMonitor.keepAlive().then(function(t){token = t;});function releaseKeepAliveToken(){activityMonitor.release(token);}</script>";
    }

    private String getActivityMonitorScript(String action) {
        String callStr = "." + action + "()";
        if (this.hasRequireJs) {
            return "<script type='text/javascript'>require(['/module/web/rc/util/activityMonitor.js'], function(am){am" + callStr + ";})</script>";
        }
        return "<script type='text/javascript' src='/module/web/rc/util/activityMonitor.js'></script><script>activityMonitor" + callStr + ";</script>";
    }

    public boolean isWebDev(String name) {
        return WebDev.get((String)name).isEnabled();
    }

    public String jQuery() {
        return "<script type='text/javascript' src='/module/js/rc/jquery/jquery-3.4.1.min.js'></script>\n";
    }

    private BComplex toComplex(Object obj, Object base) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BComplex) {
            return (BComplex)obj;
        }
        return (BComplex)BOrd.make((String)obj.toString()).get(this.fromBase(base), this.cx);
    }

    private BComponent toComponent(Object obj, Object base) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BComplex) {
            return ((BComplex)obj).getParentComponent();
        }
        return (BComponent)BOrd.make((String)obj.toString()).get(this.fromBase(base), this.cx);
    }

    private Slot toSlot(BComplex complex, Object slotObj) {
        if (slotObj instanceof Slot) {
            return (Slot)slotObj;
        }
        return complex.getSlot(slotObj.toString());
    }

    private BObject fromBase(Object base) {
        if (base == null) {
            return BLocalHost.INSTANCE;
        }
        if (base instanceof BOrd) {
            return ((BOrd)base).get();
        }
        if (!(base instanceof BObject)) {
            return BOrd.make((String)base.toString()).get();
        }
        return (BObject)base;
    }

    private BINavNode toNavNode(Object obj, Object base) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BINavNode) {
            return (BINavNode)obj;
        }
        return (BINavNode)BOrd.make((String)obj.toString()).get(this.fromBase(base), this.cx);
    }

    public static class TableData {
        private Object val;
        private String valStr;

        private TableData(Object val, String valStr) {
            this.val = val;
            this.valStr = valStr;
        }
    }

    public final class TableRow {
        private TableCursor<BIObject> cursor;
        private Map<String, TableData> map = new HashMap<String, TableData>();

        private TableRow(TableCursor<BIObject> cursor, Column[] columns) {
            this.cursor = cursor;
            for (int i = 0; i < columns.length; ++i) {
                this.map.put(columns[i].getName(), new TableData(cursor.cell(columns[i]), cursor.cell(columns[i]).toString()));
            }
        }

        public Object get(String colName) {
            TableData data = this.map.get(colName);
            if (data == null) {
                return "";
            }
            return data.val;
        }

        public Object getDisplay(String colName) {
            TableData data = this.map.get(colName);
            if (data == null) {
                return "";
            }
            return data.valStr;
        }
    }
}

