/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.test;

import com.tridium.ui.KeyboardLayout;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.BTest;

public class BKeyboardTest
extends BTest {
    public static final Type TYPE = Sys.loadType(BKeyboardTest.class);
    String badRoot1 = "<keybaord></keybaord>";
    String badRoot2 = "<keyboard lang='en'></keyboard>";
    String badRow1 = "<keyboard><rows></rows></keyboard>";
    String badRow2 = "<keyboard><row foo='bar'></row></keyboard>";
    String badKey1 = "<keyboard><row><kye/></row></keyboard>";
    String badKey2 = "<keyboard><row><key><foo/></key></row></keyboard>";
    String badKey3 = "<keyboard><row><key/></row></keyboard>";
    String badKey4 = "<keyboard><row><key code='A'/></row></keyboard>";
    String badKey5 = "<keyboard><row><key normal='A'/></row></keyboard>";
    String badKey6 = "<keyboard><row><key shift='A'/></row></keyboard>";
    String badKey7 = "<keyboard><row><key code='65' normal='a' v='X'/></row></keyboard>";
    String badKey8 = "<keyboard><row><key code='65' normal='abc'/></row></keyboard>";
    String badKey9 = "<keyboard><row><key code='a' normal='a'/></row></keyboard>";
    String badKey10 = "<keyboard><row><key code='a' normal='a' shift='abc'/></row></keyboard>";
    String badKey11 = "<keyboard><row><key code='a' normal='a' alt='abc'/></row></keyboard>";
    String good = "<keyboard>\n <row>\n  <key code='65' normal='a' alt='%'/>\n  <key code='66' normal='b' shift='B' />\n  <key code='67' normal='c' shift='C' label='Foo' />\n </row>\n <row>\n  <key code='1' normal='w' shift='@' />\n  <key code='2' normal='x' shift='#' />\n  <key code='3' normal='y' shift='&amp;' />\n  <key code='4' normal='z' shift='*' alt='[' label='Bar' />\n </row>\n</keyboard>";

    public Type getType() {
        return TYPE;
    }

    public void test() throws Exception {
        this.testFail(this.badRoot1);
        this.testFail(this.badRoot2);
        this.testFail(this.badRow1);
        this.testFail(this.badRow2);
        this.testFail(this.badKey1);
        this.testFail(this.badKey2);
        this.testFail(this.badKey3);
        this.testFail(this.badKey4);
        this.testFail(this.badKey5);
        this.testFail(this.badKey6);
        this.testFail(this.badKey7);
        this.testFail(this.badKey8);
        this.testFail(this.badKey9);
        this.testFail(this.badKey10);
        this.testFail(this.badKey11);
        KeyboardLayout kb = this.make(this.good);
        this.verify(kb.getRowCount() == 2);
        this.verify(kb.getKeyCount(0) == 3);
        this.verify(kb.getKeyCount(1) == 4);
        this.verify(kb.getKey(0, 0), 65, 'a', 'a', '%', null);
        this.verify(kb.getKey(0, 1), 66, 'b', 'B', 'b', null);
        this.verify(kb.getKey(0, 2), 67, 'c', 'C', 'c', "Foo");
        this.verify(kb.getKey(1, 0), 1, 'w', '@', 'w', null);
        this.verify(kb.getKey(1, 1), 2, 'x', '#', 'x', null);
        this.verify(kb.getKey(1, 2), 3, 'y', '&', 'y', null);
        this.verify(kb.getKey(1, 3), 4, 'z', '*', '[', "Bar");
    }

    public void testEN() throws Exception {
        KeyboardLayout kb = KeyboardLayout.make();
        this.verify(kb.getRowCount() == 5);
        this.verify(kb.getKeyCount(0) == 14);
        this.verify(kb.getKey(0, 0), 192, '`', '~', '`', null);
        this.verify(kb.getKey(0, 1), 49, '1', '!', '1', null);
        this.verify(kb.getKey(0, 2), 50, '2', '@', '2', null);
        this.verify(kb.getKey(0, 3), 51, '3', '#', '3', null);
        this.verify(kb.getKey(0, 4), 52, '4', '$', '4', null);
        this.verify(kb.getKey(0, 5), 53, '5', '%', '5', null);
        this.verify(kb.getKey(0, 6), 54, '6', '^', '6', null);
        this.verify(kb.getKey(0, 7), 55, '7', '&', '7', null);
        this.verify(kb.getKey(0, 8), 56, '8', '*', '8', null);
        this.verify(kb.getKey(0, 9), 57, '9', '(', '9', null);
        this.verify(kb.getKey(0, 10), 58, '0', ')', '0', null);
        this.verify(kb.getKey(0, 11), 45, '-', '_', '-', null);
        this.verify(kb.getKey(0, 12), 61, '=', '+', '=', null);
        this.verify(kb.getKey(0, 13), 8, '\b', '\b', '\b', "Backspace");
        this.verify(kb.getKeyCount(1) == 14);
        this.verify(kb.getKey(1, 0), 9, '\t', '\t', '\t', "Tab");
        this.verify(kb.getKey(1, 1), 81, 'q', 'Q', 'q', null);
        this.verify(kb.getKey(1, 2), 87, 'w', 'W', 'w', null);
        this.verify(kb.getKey(1, 3), 69, 'e', 'E', 'e', null);
        this.verify(kb.getKey(1, 4), 82, 'r', 'R', 'r', null);
        this.verify(kb.getKey(1, 5), 84, 't', 'T', 't', null);
        this.verify(kb.getKey(1, 6), 89, 'y', 'Y', 'y', null);
        this.verify(kb.getKey(1, 7), 85, 'u', 'U', 'u', null);
        this.verify(kb.getKey(1, 8), 73, 'i', 'I', 'i', null);
        this.verify(kb.getKey(1, 9), 79, 'o', 'O', 'o', null);
        this.verify(kb.getKey(1, 10), 80, 'p', 'P', 'p', null);
        this.verify(kb.getKey(1, 11), 91, '[', '{', '[', null);
        this.verify(kb.getKey(1, 12), 92, ']', '}', ']', null);
        this.verify(kb.getKey(1, 13), 93, '\\', '|', '\\', null);
        this.verify(kb.getKeyCount(2) == 12);
        this.verify(kb.getKey(2, 0), 65, 'a', 'A', 'a', null);
        this.verify(kb.getKey(2, 1), 83, 's', 'S', 's', null);
        this.verify(kb.getKey(2, 2), 68, 'd', 'D', 'd', null);
        this.verify(kb.getKey(2, 3), 70, 'f', 'F', 'f', null);
        this.verify(kb.getKey(2, 4), 71, 'g', 'G', 'g', null);
        this.verify(kb.getKey(2, 5), 72, 'h', 'H', 'h', null);
        this.verify(kb.getKey(2, 6), 74, 'j', 'J', 'j', null);
        this.verify(kb.getKey(2, 7), 75, 'k', 'K', 'k', null);
        this.verify(kb.getKey(2, 8), 76, 'l', 'L', 'l', null);
        this.verify(kb.getKey(2, 9), 59, ';', ':', ';', null);
        this.verify(kb.getKey(2, 10), 222, '\'', '\"', '\'', null);
        this.verify(kb.getKey(2, 11), 10, '\n', '\n', '\n', "Enter");
        this.verify(kb.getKeyCount(3) == 11);
        this.verify(kb.getKey(3, 0), 90, 'z', 'Z', 'z', null);
        this.verify(kb.getKey(3, 1), 88, 'x', 'X', 'x', null);
        this.verify(kb.getKey(3, 2), 67, 'c', 'C', 'c', null);
        this.verify(kb.getKey(3, 3), 86, 'v', 'V', 'v', null);
        this.verify(kb.getKey(3, 4), 66, 'b', 'B', 'b', null);
        this.verify(kb.getKey(3, 5), 78, 'n', 'N', 'n', null);
        this.verify(kb.getKey(3, 6), 77, 'm', 'M', 'm', null);
        this.verify(kb.getKey(3, 7), 44, ',', '<', ',', null);
        this.verify(kb.getKey(3, 8), 46, '.', '>', '.', null);
        this.verify(kb.getKey(3, 9), 47, '/', '?', '/', null);
        this.verify(kb.getKey(3, 10), 16, '\u0010', '\u0010', '\u0010', "Shift");
        this.verify(kb.getKeyCount(4) == 6);
        this.verify(kb.getKey(4, 0), 32, ' ', ' ', ' ', "Space");
        this.verify(kb.getKey(4, 1), 38, '&', '&', '&', "Up");
        this.verify(kb.getKey(4, 2), 40, '(', '(', '(', "Down");
        this.verify(kb.getKey(4, 3), 37, '%', '%', '%', "Left");
        this.verify(kb.getKey(4, 4), 39, '\'', '\'', '\'', "Right");
        this.verify(kb.getKey(4, 5), 127, '\u007f', '\u007f', '\u007f', "Del");
    }

    private void testFail(String xml) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            new KeyboardLayout().parse((InputStream)in);
            this.fail();
        }
        catch (Exception e) {
            this.verify(true);
        }
    }

    private KeyboardLayout make(String xml) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        KeyboardLayout kb = new KeyboardLayout();
        kb.parse((InputStream)in);
        return kb;
    }

    private void verify(KeyboardLayout.Key key, int code, char n, char s, char a, String label) {
        this.verify(key.code == code);
        this.verify(key.normal == n);
        this.verify(key.shift == s);
        this.verify(key.alt == a);
        if (key.label == null) {
            this.verify(label == null);
        } else {
            this.verify(key.label.equals(label));
        }
    }
}

