/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.gx.util.GeomUtil;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.PathArtisan;
import com.tridium.px.editor.studio.artisans.PolygonArtisan;
import com.tridium.px.editor.studio.commands.MorphWidget;
import com.tridium.px.editor.studio.painters.PointPainter;
import com.tridium.px.editor.studio.trackers.GeometryTracker;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.util.Handle;
import com.tridium.px.editor.util.Reflector;
import com.tridium.px.editor.util.SelectedWidgets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.BPolygonGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.shape.BPath;
import javax.baja.ui.shape.BPolygon;

public class AddPointTracker
extends GeometryTracker {
    private SelectedWidgets selected;
    private TrackerStudio studio;

    public AddPointTracker(BPxEditorPane editorPane, TrackerStudio studio) {
        super(editorPane);
        this.studio = studio;
        this.selected = editorPane.getSelectedWidgets();
        this.selected.deselectAll();
        studio.setPainter(new PointPainter(editorPane.getPainterStudio(), this.selected));
        this.selectShapes(this.selected, (BWidget)editorPane.getRootContainer());
        editorPane.repaint();
    }

    @Override
    public Tracker mousePressed(BMouseEvent event) {
        double y;
        if (event.getClickCount() != 1 || !event.isButton1Down()) {
            return this;
        }
        double x = event.getX();
        Handle handle = this.selected.getHandle(x, y = event.getY());
        if (handle == null) {
            BWidget widget = this.studio.rootDescendant(new Point(x, y));
            if (widget instanceof BPath || widget instanceof BPolygon) {
                this.addPoint(x, y, widget);
            }
        } else {
            if (!(handle.widget instanceof BPath) && !(handle.widget instanceof BPolygon)) {
                throw new IllegalStateException();
            }
            this.addPoint(x, y, handle.widget);
        }
        this.editorPane.repaint();
        return this;
    }

    private void addPoint(double x, double y, BWidget widget) {
        Point pnt = this.studio.toViewbox(x, y, Reflector.canvas(widget));
        if (widget instanceof BPath) {
            BPath path = (BPath)widget;
            BPathGeom geom = path.getGeom();
            IPathGeom.Segment[] segs = geom.segments();
            Point[] points = this.toPoints(segs);
            int idx = GeomUtil.nearest((Point)pnt, (Point[])points, (boolean)false);
            ArrayList<IPathGeom.Segment> a = new ArrayList<IPathGeom.Segment>(Arrays.asList(segs));
            a.add(idx + 1, (IPathGeom.Segment)new IPathGeom.LineTo(true, pnt.x, pnt.y));
            segs = a.toArray(new IPathGeom.Segment[0]);
            geom = BPathGeom.make((IPathGeom.Segment[])segs);
            new MorphWidget(this.editorPane, (BWidget)path, (IGeom)path.getGeom(), (IGeom)geom, new PathArtisan()).invoke();
        } else if (widget instanceof BPolygon) {
            BPolygon poly = (BPolygon)widget;
            BPolygonGeom geom = poly.getGeom();
            Point[] points = this.toPoints(geom);
            int idx = GeomUtil.nearest((Point)pnt, (Point[])points, (boolean)true);
            ArrayList<Point> a = new ArrayList<Point>(Arrays.asList(points));
            if (idx == points.length - 1) {
                a.add(pnt);
            } else {
                a.add(idx + 1, pnt);
            }
            points = a.toArray(new Point[0]);
            geom = this.fromPoints(points);
            new MorphWidget(this.editorPane, (BWidget)poly, (IGeom)poly.getGeom(), (IGeom)geom, new PolygonArtisan()).invoke();
        } else {
            throw new IllegalStateException();
        }
    }

    private BPolygonGeom fromPoints(Point[] points) {
        double[] x = new double[points.length];
        double[] y = new double[points.length];
        for (int i = 0; i < points.length; ++i) {
            x[i] = points[i].x;
            y[i] = points[i].y;
        }
        return BPolygonGeom.make((double[])x, (double[])y);
    }

    private Point[] toPoints(BPolygonGeom geom) {
        Point[] points = new Point[geom.size()];
        for (int i = 0; i < geom.size(); ++i) {
            points[i] = new Point(geom.x(i), geom.y(i));
        }
        return points;
    }

    private Point[] toPoints(IPathGeom.Segment[] segs) {
        Point[] points = new Point[segs.length];
        for (int i = 0; i < segs.length; ++i) {
            try {
                Class<?> cls = segs[i].getClass();
                Method mx = cls.getMethod("getX", new Class[0]);
                Method my = cls.getMethod("getY", new Class[0]);
                double x = (Double)mx.invoke((Object)segs[i], new Object[0]);
                double y = (Double)my.invoke((Object)segs[i], new Object[0]);
                points[i] = new Point(x, y);
                continue;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        return points;
    }
}

