/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.propsheet;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.property.PxPropertyUtil;
import com.tridium.px.editor.sidebars.propsheet.AddPxProperty;
import com.tridium.px.editor.sidebars.propsheet.ChangePxPropertyValue;
import com.tridium.px.editor.sidebars.propsheet.RemovePxProperty;
import com.tridium.px.editor.sidebars.propsheet.RenamePxProperty;
import com.tridium.ui.px.PxPropertyComponentArray;
import com.tridium.workbench.celltable.BAbstractCellTable;
import com.tridium.workbench.celltable.BLabeledCellTable;
import com.tridium.workbench.celltable.CellController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.gx.BImage;
import javax.baja.gx.Point;
import javax.baja.px.editor.BDrawingTool;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.BPxSideBar;
import javax.baja.px.editor.event.PxEditorEvent;
import javax.baja.px.editor.event.PxEvent;
import javax.baja.px.editor.event.PxListener;
import javax.baja.px.editor.event.PxPropertyEvent;
import javax.baja.px.editor.event.PxSelectionEvent;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.px.PxProperty;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableSubject;
import javax.baja.util.Lexicon;
import javax.baja.workbench.celleditor.BWbCellEditor;

public class BPxPropSheet
extends BPxSideBar
implements PxListener {
    public static final Action tableSelectionModified = BPxPropSheet.newAction((int)0, null);
    public static final Action cellModified = BPxPropSheet.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BPxPropSheet.class);
    private static Lexicon LEX = Lexicon.make((String)"pxEditor");
    private static String DESC = LEX.getText("pxPropSheet.label");
    private static BImage ICON = BImage.make((String)LEX.getText("pxPropSheet.icon"));
    private static String VALUE = Lexicon.make((String)"bajaui").getText("value");
    BPxEditorPane editorPane;
    BPxEditor editor;
    BLabeledCellTable table;
    boolean readonly = false;
    private PxPropertyComponentArray gcomps;
    private BAbstractButton btnAdd;
    private BAbstractButton btnRemove;
    private List<Row> rows = new ArrayList<Row>();
    private Map<BWbCellEditor, Row> ceToRow = new HashMap<BWbCellEditor, Row>();

    public void tableSelectionModified() {
        this.invoke(tableSelectionModified, null, null);
    }

    public void cellModified(BWidgetEvent event) {
        this.invoke(cellModified, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BPxPropSheet(BPxEditor editor) {
        super(editor);
        this.editor = editor;
        this.editorPane = (BPxEditorPane)editor.getContent();
        editor.addPxListener(this);
        this.table = new BLabeledCellTable(new String[]{VALUE});
        this.table.setController((TableController)new BAbstractCellTable.Controller(){

            protected BMenu makePopup(TableSubject subject) {
                return subject.getActiveRow() == -1 ? null : BPxPropSheet.this.makeMenu();
            }
        });
        this.table.setCellController(new CellController(){

            public void showCellPopup(BWbCellEditor ce, BMouseEvent event) {
                Point pnt = ce.translateToAncestor((BWidget)BPxPropSheet.this, new Point(event.getX(), event.getY()));
                BPxPropSheet.this.makeMenu().open((BWidget)BPxPropSheet.this, pnt.x, pnt.y);
            }
        });
        BToolBar toolbar = new BToolBar();
        this.btnAdd = this.newButton(new AddPxProperty(this));
        toolbar.add(null, (BValue)this.btnAdd);
        this.btnRemove = this.newButton(new RemovePxProperty(this));
        toolbar.add(null, (BValue)this.btnRemove);
        this.btnRemove.setEnabled(false);
        BEdgePane edge = new BEdgePane();
        edge.setRight((BWidget)toolbar);
        BEdgePane contents = new BEdgePane();
        contents.setTop((BWidget)edge);
        contents.setCenter((BWidget)this.table);
        this.setContent((BWidget)contents);
        this.linkTo("linkTable", (BComponent)this.table, (Slot)BLabeledCellTable.selectionModified, (Slot)tableSelectionModified);
    }

    @Override
    public void pxEvent(PxEvent event) {
        block0 : switch (event.getEventType()) {
            case 0: {
                PxEditorEvent ee = (PxEditorEvent)event;
                switch (ee.getEventId()) {
                    case 0: {
                        this.setReadonly(this.editor.isReadonly());
                        this.loadProps();
                        break block0;
                    }
                    case 3: {
                        BDrawingTool tool = (BDrawingTool)((Object)ee.getEventValue());
                        this.setReadonly(!tool.isNormal());
                        this.loadProps();
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void loadProps() {
        this.gcomps = this.editorPane.getPxPropertyComponents();
        PxProperty[] props = this.editor.getPxProperties();
        this.table.clearRows();
        for (int i = 0; i < props.length; ++i) {
            PxProperty p = props[i];
            this.table.addRow(p.getName(), new Row(p).toArray());
        }
    }

    public void doTableSelectionModified() {
        this.editorPane.getSelectedWidgets().deselectAll();
        PxProperty[] props = this.editor.getPxProperties();
        int n = this.table.getSelection().getRow();
        this.btnRemove.setEnabled(n != -1 && !this.readonly);
        if (n != -1) {
            this.editorPane.getSelectedWidgets().setWidgets(this.gcomps.getWidgets(props[n]));
        }
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
    }

    public void doCellModified(BWidgetEvent event) {
        try {
            BWbCellEditor ce = (BWbCellEditor)event.getWidget();
            BValue value = (BValue)ce.saveValue();
            Row row = this.ceToRow.get(ce);
            new ChangePxPropertyValue(this.editorPane, this, ce, row.prop, value).invoke();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    void insertProperty(int n, PxProperty prop, CommandArtifact removal) {
        PxPropertyUtil.insert(this.editor, n, prop, removal);
        this.gcomps.setValue(prop);
        this.table.insertRow(n, prop.getName(), new Row(prop).toArray());
        this.table.getSelection().deselectAll();
        this.table.getSelection().select(n);
        this.table.relayout();
        this.updateUI(prop, new PxPropertyEvent(0, prop));
    }

    CommandArtifact removeProperty(int n) {
        PxProperty[] props = this.editor.getPxProperties();
        PxProperty prop = props[n];
        this.gcomps.setDefaultValue(prop);
        CommandArtifact removal = PxPropertyUtil.remove(this.editor, prop, this.gcomps);
        Row row = this.rows.get(n);
        this.remove((BComplex)row.link);
        this.ceToRow.remove(row.ce);
        this.rows.remove(n);
        this.table.removeRow(n);
        this.table.getSelection().deselectAll();
        this.table.relayout();
        this.updateUI(prop, new PxPropertyEvent(1, prop));
        return removal;
    }

    void updateUI(PxProperty prop, PxEvent event) {
        block0 : switch (event.getEventType()) {
            case 1: {
                switch (((PxPropertyEvent)event).getEventId()) {
                    case 1: {
                        this.editorPane.getSelectedWidgets().setWidgets(this.gcomps.getWidgets(prop));
                        break block0;
                    }
                }
                break;
            }
        }
        this.editor.firePxEvent(event);
    }

    private BMenu makeMenu() {
        BMenu menu = new BMenu();
        menu.add(null, (Command)new RenamePxProperty(this));
        menu.add(null, (Command)new RemovePxProperty(this));
        return menu;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.table.setCellsEnabled(!readonly);
        this.btnAdd.setEnabled(!readonly);
        int n = this.table.getSelection().getRow();
        this.btnRemove.setEnabled(n != -1 && !readonly);
    }

    @Override
    public BImage getSideBarIcon() {
        return ICON;
    }

    @Override
    public String getSideBarDescription() {
        return DESC;
    }

    class Row {
        PxProperty prop;
        BWbCellEditor ce;
        BLink link;

        Row(PxProperty prop) {
            this.prop = prop;
            this.ce = BWbCellEditor.makeFor((BObject)prop.getValue());
            this.ce.loadValue((BObject)prop.getValue());
            this.link = BPxPropSheet.this.linkTo((BComponent)this.ce, (Slot)BWbCellEditor.pluginModified, (Slot)cellModified);
            BPxPropSheet.this.rows.add(this);
            BPxPropSheet.this.ceToRow.put(this.ce, this);
        }

        BWbCellEditor[] toArray() {
            return new BWbCellEditor[]{this.ce};
        }
    }
}

