/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.cellsheet.celleditors;

import com.tridium.px.editor.sidebars.cellsheet.celleditors.BVariableTextCE;
import com.tridium.workbench.celltable.BAbstractCellTable;
import com.tridium.workbench.celltable.BLabeledCellTable;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.celleditor.BWbCellEditor;

public class BVariablesEditor
extends BEdgePane {
    public static final Action cellTableModified = BVariablesEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BVariablesEditor.class);
    private static Lexicon WB = Lexicon.make((String)"wbutil");
    private static String VALUE = WB.getText("facetsFE.value");
    private static Lexicon LEX = Lexicon.make((String)"pxEditor");
    private BLabeledCellTable cellTable = new BLabeledCellTable(new String[]{VALUE});
    private String[] keys;
    private BTable beforeAfter;
    BOrd[] before;
    BOrd[] after;

    public void cellTableModified() {
        this.invoke(cellTableModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BFacets open(BWidget owner, String title, BFacets facets, BOrd[] origOrds, boolean readonly) throws Exception {
        BVariablesEditor editorPane = new BVariablesEditor(facets, origOrds, readonly);
        int r = BDialog.open((BWidget)owner, (String)title, (Object)((Object)editorPane), (int)3);
        if (r != 1) {
            return null;
        }
        return editorPane.save();
    }

    public BVariablesEditor(BFacets facets, BOrd[] origOrds, boolean readonly) {
        this.cellTable.setCellsEnabled(!readonly);
        this.cellTable.setCellRenderer((TableCellRenderer)new BAbstractCellTable.CellRenderer(){

            public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
                return this.getForeground(cell);
            }

            public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
                return this.getBackground(cell);
            }
        });
        this.keys = facets.list();
        for (int i = 0; i < this.keys.length; ++i) {
            BVariableTextCE ce = new BVariableTextCE();
            ce.loadValue(facets.getFacet(this.keys[i]));
            this.cellTable.addRow(this.keys[i], new BWbCellEditor[]{ce});
        }
        IFilter filter = new IFilter(){

            public boolean accept(Object obj) {
                return !obj.equals(BOrd.NULL);
            }
        };
        this.before = (BOrd[])new Array((Object[])origOrds).filter(filter).trim();
        this.after = new BOrd[this.before.length];
        this.setAfterOrds();
        this.beforeAfter = new BTable();
        this.beforeAfter.setModel((TableModel)new BeforeAfterModel());
        this.beforeAfter.setController(new TableController(){

            protected BMenu makeOptionsMenu() {
                BMenu menu = super.makeOptionsMenu();
                menu.keep(new String[]{"resizeColumns"});
                return menu;
            }
        });
        this.beforeAfter.setCellRenderer(new TableCellRenderer(){

            public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
                return this.getForeground(cell);
            }

            public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
                return this.getBackground(cell);
            }
        });
        BConstrainedPane cons1 = new BConstrainedPane((BWidget)new BScrollPane((BWidget)this.cellTable));
        cons1.setMinHeight(150.0);
        cons1.setMaxHeight(300.0);
        cons1.setMinWidth(300.0);
        BConstrainedPane cons2 = new BConstrainedPane((BWidget)new BScrollPane((BWidget)this.beforeAfter));
        cons2.setMaxHeight(300.0);
        cons2.setMinWidth(300.0);
        this.setTop((BWidget)new BBorderPane((BWidget)cons1, 0.0, 0.0, 10.0, 0.0));
        this.setBottom((BWidget)cons2);
        this.linkTo((BComponent)this.cellTable, (Slot)BAbstractCellTable.modified, (Slot)cellTableModified);
    }

    public void doCellTableModified() {
        this.setAfterOrds();
        this.repaint();
    }

    private void setAfterOrds() {
        try {
            BFacets fac = this.save();
            for (int i = 0; i < this.before.length; ++i) {
                this.after[i] = this.before[i].substitute(fac);
            }
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BFacets save() throws Exception {
        BString[] values = new BString[this.keys.length];
        for (int i = 0; i < this.keys.length; ++i) {
            values[i] = (BString)this.cellTable.getRowCells(i)[0].saveValue();
        }
        return BFacets.make((String[])this.keys, (BIDataValue[])values);
    }

    private static String text(String s) {
        return LEX.getText(s);
    }

    class BeforeAfterModel
    extends TableModel {
        BeforeAfterModel() {
        }

        public int getRowCount() {
            return BVariablesEditor.this.before.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BVariablesEditor.text("boundOrds.relativize.before");
                }
                case 1: {
                    return BVariablesEditor.text("boundOrds.relativize.after");
                }
            }
            throw new IllegalStateException();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return BVariablesEditor.this.before[row];
                }
                case 1: {
                    return BVariablesEditor.this.after[row];
                }
            }
            throw new IllegalStateException();
        }
    }
}

