/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.RootStudio;
import com.tridium.ui.ShellManager;
import com.tridium.ui.ShellPeer;
import java.util.Collection;
import java.util.HashMap;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.TransferContext;

public class RootShellManager
implements ShellManager {
    private BPxEditorPane editorPane;
    private RootStudio studio;
    private HashMap<BWidget, BWidget> relayoutQueue = new HashMap();
    private Thread layoutThread;

    RootShellManager(BPxEditorPane editorPane, RootStudio studio) {
        this.editorPane = editorPane;
        this.studio = studio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutWidgets() {
        BWidget[] relayout = null;
        HashMap<BWidget, BWidget> hashMap = this.relayoutQueue;
        synchronized (hashMap) {
            if (this.relayoutQueue.size() > 0) {
                Collection<BWidget> values = this.relayoutQueue.values();
                relayout = values.toArray(new BWidget[0]);
                this.relayoutQueue.clear();
            }
        }
        if (relayout != null) {
            this.layoutThread = Thread.currentThread();
            for (int i = 0; i < relayout.length; ++i) {
                relayout[i].layout();
            }
            this.layoutThread = null;
            this.checkMouseOver();
        }
    }

    public void repaint() {
        this.studio.repaint();
    }

    public void repaint(BWidget widget, int x, int y, int w, int h) {
        Point a = this.studio.translateToRoot(widget, new Point((double)x, (double)y));
        Point b = this.studio.translateToRoot(widget, new Point((double)(x + w), (double)(y + h)));
        if (a.x < 0.0) {
            a.x = 0.0;
        }
        if (a.y < 0.0) {
            a.y = 0.0;
        }
        if (b.x < 0.0) {
            b.x = 0.0;
        }
        if (b.y < 0.0) {
            b.y = 0.0;
        }
        this.studio.repaint(a.x, a.y, b.x - a.x, b.y - a.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relayout(BWidget widget, boolean sync) {
        HashMap<BWidget, BWidget> hashMap = this.relayoutQueue;
        synchronized (hashMap) {
            if (this.layoutThread != Thread.currentThread() && this.relayoutQueue.get(widget) == null) {
                this.relayoutQueue.put(widget, widget);
            }
        }
        if (sync) {
            this.layoutWidgets();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueRelayout(BWidget widget) {
        HashMap<BWidget, BWidget> hashMap = this.relayoutQueue;
        synchronized (hashMap) {
            if (this.layoutThread != Thread.currentThread() && this.relayoutQueue.get(widget) == null) {
                this.relayoutQueue.put(widget, widget);
                return true;
            }
        }
        return false;
    }

    public void enableInput() {
        ShellManager shell = this.editorPane.getShellManager();
        if (shell != null) {
            shell.enableInput();
        }
    }

    public void disableInput() {
        ShellManager shell = this.editorPane.getShellManager();
        if (shell != null) {
            shell.disableInput();
        }
    }

    public void setHoldLayout(boolean hold) {
    }

    public BWidget getShell() {
        return null;
    }

    public ShellPeer getShellPeer() {
        throw new IllegalStateException();
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public Point translateToScreen(BWidget c, Point pt) {
        throw new IllegalStateException();
    }

    public boolean hasFocus(BWidget c) {
        return false;
    }

    public void requestFocus(BWidget c) {
    }

    public BWidget getCurrentFocus() {
        throw new IllegalStateException();
    }

    public void resetHover(BWidget w) {
    }

    public void startDragOperation(BTransferWidget source, BMouseEvent event, TransferContext context, DragRenderer dragRenderer) {
    }

    public void checkMouseOver() {
    }

    public void updateMouseCursor() {
    }

    public void enterBusy(BWidget w) {
    }

    public void exitBusy(BWidget w) {
    }

    public boolean isDesignTime() {
        return true;
    }
}

