/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.util.point;

import com.tridium.bacnet.util.point.BPeriodicNumericPoint;
import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraSlots
public abstract class BPooledWorkerPoint
extends BPeriodicNumericPoint {
    public static final Type TYPE = Sys.loadType(BPooledWorkerPoint.class);
    private static Object POOL_LOCK = new Object();
    private static ExecutorService pool;

    @Override
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void started() throws Exception {
        try {
            super.started();
        }
        catch (NotRunningException notRunningException) {
            // empty catch block
        }
        Object object = POOL_LOCK;
        synchronized (object) {
            if (pool == null) {
                AccessController.doPrivileged(() -> {
                    pool = Executors.newSingleThreadExecutor(new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread t = Executors.defaultThreadFactory().newThread(r);
                            t.setDaemon(true);
                            return t;
                        }
                    });
                    return null;
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopped() throws Exception {
        super.stopped();
        Object object = POOL_LOCK;
        synchronized (object) {
            if (pool != null) {
                pool.shutdownNow();
            }
            pool = null;
        }
    }

    public void run(Runnable runnable) {
        if (pool != null) {
            pool.execute(runnable);
        }
    }
}

