/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.mibble.CompoundContext;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibAnalyzerUtil;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibImport;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibMacroSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeContext;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.NamedNumber;
import net.percederberg.mibble.asn1.Asn1Analyzer;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpAgentCapabilities;
import net.percederberg.mibble.snmp.SnmpCompliance;
import net.percederberg.mibble.snmp.SnmpIndex;
import net.percederberg.mibble.snmp.SnmpModule;
import net.percederberg.mibble.snmp.SnmpModuleCompliance;
import net.percederberg.mibble.snmp.SnmpModuleIdentity;
import net.percederberg.mibble.snmp.SnmpModuleSupport;
import net.percederberg.mibble.snmp.SnmpNotificationGroup;
import net.percederberg.mibble.snmp.SnmpNotificationType;
import net.percederberg.mibble.snmp.SnmpObjectGroup;
import net.percederberg.mibble.snmp.SnmpObjectIdentity;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpRevision;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpTextualConvention;
import net.percederberg.mibble.snmp.SnmpTrapType;
import net.percederberg.mibble.snmp.SnmpVariation;
import net.percederberg.mibble.type.BitSetType;
import net.percederberg.mibble.type.BooleanType;
import net.percederberg.mibble.type.ChoiceType;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.ElementType;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.NullType;
import net.percederberg.mibble.type.ObjectIdentifierType;
import net.percederberg.mibble.type.RealType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.type.SizeConstraint;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.TypeReference;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;
import net.percederberg.mibble.value.BinaryNumberValue;
import net.percederberg.mibble.value.BitSetValue;
import net.percederberg.mibble.value.BooleanValue;
import net.percederberg.mibble.value.HexNumberValue;
import net.percederberg.mibble.value.NullValue;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;
import net.percederberg.mibble.value.StringValue;
import net.percederberg.mibble.value.ValueReference;

class MibAnalyzer
extends Asn1Analyzer {
    private ArrayList mibs = new ArrayList();
    private File file;
    private MibLoader loader;
    private MibLoaderLog log;
    private Mib currentMib = null;
    private MibContext baseContext = null;
    private ArrayList contextStack = new ArrayList();
    private boolean implicitTags = true;
    boolean impVerified = false;

    public MibAnalyzer(File file, MibLoader loader, MibLoaderLog log) {
        this.file = file;
        this.loader = loader;
        this.log = log;
    }

    @Override
    public void reset() {
        this.mibs = new ArrayList();
        this.currentMib = null;
        this.baseContext = null;
        this.contextStack.clear();
        this.implicitTags = true;
    }

    public ArrayList getMibs() {
        return this.mibs;
    }

    @Override
    protected Node exitBinaryString(Token node) {
        String str = node.getImage();
        Number value = (str = str.substring(1, str.length() - 2)).length() == 0 ? (Number)new Integer(0) : (Number)(str.length() < 32 ? (Number)new Integer(Integer.parseInt(str, 2)) : (Number)(str.length() < 64 ? new Long(Long.parseLong(str, 2)) : new BigInteger(str, 2)));
        node.addValue(value);
        node.addValue(str);
        return node;
    }

    @Override
    protected Node exitHexadecimalString(Token node) {
        String str = node.getImage();
        Number value = (str = str.substring(1, str.length() - 2)).length() == 0 ? (Number)new Integer(0) : (Number)(str.length() < 8 ? (Number)new Integer(Integer.parseInt(str, 16)) : (Number)(str.length() < 16 ? new Long(Long.parseLong(str, 16)) : new BigInteger(str, 16)));
        node.addValue(value);
        node.addValue(str);
        return node;
    }

    @Override
    protected Node exitQuotedString(Token node) {
        int pos;
        String str = node.getImage();
        str = str.substring(1, str.length() - 1);
        do {
            if ((pos = str.indexOf("\"\"")) < 0) continue;
            str = str.substring(0, pos) + '\"' + str.substring(pos + 2);
        } while (pos >= 0);
        node.addValue(str);
        return node;
    }

    @Override
    protected Node exitIdentifierString(Token node) {
        node.addValue(node.getImage());
        return node;
    }

    @Override
    protected Node exitNumberString(Token node) {
        String str = node.getImage();
        Number value = str.length() < 10 ? (Number)new Integer(str) : (Number)(str.length() < 19 ? new Long(str) : new BigInteger(str));
        node.addValue(value);
        return node;
    }

    @Override
    protected Node exitStart(Production node) {
        String comment = MibAnalyzerUtil.getCommentsFooter(node);
        if (this.currentMib != null) {
            this.currentMib.setFooterComment(comment);
        }
        return null;
    }

    @Override
    protected void enterModuleDefinition(Production node) {
        this.currentMib = new Mib(this.file, this.loader, this.log);
        this.baseContext = this.loader.getDefaultContext();
        this.baseContext = new CompoundContext(this.currentMib, this.baseContext);
        this.pushContext(this.baseContext);
    }

    @Override
    protected Node exitModuleDefinition(Production node) throws ParseException {
        this.currentMib.setName(this.getStringValue(this.getChildAt(node, 0), 0));
        this.currentMib.setHeaderComment(MibAnalyzerUtil.getComments(node));
        this.mibs.add(this.currentMib);
        return node;
    }

    @Override
    protected void enterAssignmentList(Production node) throws ParseException {
        this.verifyImports();
    }

    private void verifyImports() {
        MibImport imp;
        if (this.impVerified) {
            return;
        }
        this.impVerified = true;
        ArrayList imports = (ArrayList)this.currentMib.getAllImports();
        boolean addMissingV1Smi = true;
        boolean addMissingV2Smi = true;
        boolean addMissingV2Tc = true;
        for (int i = 0; i < imports.size(); ++i) {
            imp = (MibImport)imports.get(i);
            if (imp.getName().startsWith("RFC1065-SMI") || imp.getName().startsWith("RFC1155-SMI")) {
                addMissingV1Smi = false;
            }
            if (imp.getName().startsWith("SNMPv2-SMI")) {
                addMissingV2Smi = false;
            }
            if (!imp.getName().startsWith("SNMPv2-TC")) continue;
            addMissingV2Tc = false;
        }
        FileLocation emptyFileLoc = new FileLocation(null);
        if (addMissingV1Smi) {
            imp = new MibImport(this.loader, emptyFileLoc, "RFC1155-SMI", new ArrayList());
            this.loader.scheduleLoad(imp.getName());
            this.currentMib.addImport(imp);
            imports.add(imp);
        }
        if (addMissingV2Smi) {
            imp = new MibImport(this.loader, emptyFileLoc, "SNMPv2-SMI", new ArrayList());
            this.loader.scheduleLoad(imp.getName());
            this.currentMib.addImport(imp);
            imports.add(imp);
        }
        if (addMissingV2Tc) {
            imp = new MibImport(this.loader, emptyFileLoc, "SNMPv2-TC", new ArrayList());
            this.loader.scheduleLoad(imp.getName());
            this.currentMib.addImport(imp);
            imports.add(imp);
        }
        imp = new MibImport(this.loader, emptyFileLoc, "SNMPTridFix", new ArrayList());
        this.loader.scheduleLoad(imp.getName());
        this.currentMib.addImport(imp);
        imports.add(imp);
        MibContext current = this.loader.getDefaultContext();
        for (int i = imports.size() - 1; i >= 0; --i) {
            imp = (MibImport)imports.get(i);
            current = new CompoundContext(imp, current);
        }
        this.baseContext = new CompoundContext(this.currentMib, current);
        this.popContext();
        this.pushContext(this.baseContext);
    }

    @Override
    protected Node exitModuleIdentifier(Production node) throws ParseException {
        node.addValue(this.getStringValue(this.getChildAt(node, 0), 0));
        return node;
    }

    @Override
    protected Node exitModuleReference(Production node) throws ParseException {
        node.addValue(this.getStringValue(this.getChildAt(node, 0), 0));
        return node;
    }

    @Override
    protected Node exitTagDefault(Production node) throws ParseException {
        Node child = this.getChildAt(node, 0);
        this.implicitTags = child.getId() != 1017;
        return null;
    }

    @Override
    protected Node exitImportList(Production node) {
        this.verifyImports();
        return null;
    }

    @Override
    protected Node exitSymbolsFromModule(Production node) throws ParseException {
        Node child = this.getChildAt(node, 0);
        ArrayList symbols = child.getAllValues();
        if (symbols == null) {
            symbols = new ArrayList();
        }
        child = this.getChildAt(node, 2);
        String module = this.getStringValue(child, 0);
        MibImport imp = new MibImport(this.loader, this.getLocation(child), module, symbols);
        this.loader.scheduleLoad(module);
        this.currentMib.addImport(imp);
        node.addValue(imp);
        return node;
    }

    @Override
    protected Node exitSymbolList(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSymbol(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitMacroDefinition(Production node) throws ParseException {
        String name = this.getStringValue(this.getChildAt(node, 0), 0);
        if (this.currentMib.getSymbol(name) != null) {
            System.out.println("MacroDefinition error : a symbol '" + name + "' already present in the MIB " + node.getStartLine() + "/" + node.getStartColumn());
            this.log.addWarning(this.getLocation(node), "a symbol '" + name + "' already present in the MIB ");
            return null;
        }
        MibMacroSymbol symbol = new MibMacroSymbol(this.getLocation(node), this.currentMib, name);
        symbol.setComment(MibAnalyzerUtil.getComments(node));
        return null;
    }

    @Override
    protected Node exitMacroReference(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitTypeAssignment(Production node) throws ParseException {
        String name = this.getStringValue(this.getChildAt(node, 0), 0);
        if (this.currentMib.getSymbol(name) != null) {
            System.out.println("TypeAssignment error : a symbol '" + name + "' already present in the MIB " + node.getStartLine() + "/" + node.getStartColumn());
            this.log.addWarning(this.getLocation(node), "a symbol '" + name + "' already present in the MIB ");
            return null;
        }
        if (!Character.isUpperCase(name.charAt(0))) {
            this.log.addWarning(this.getLocation(node), "type identifier '" + name + "' doesn't start with an uppercase character");
        }
        MibType type = (MibType)this.getValue(this.getChildAt(node, 2), 0);
        MibTypeSymbol symbol = new MibTypeSymbol(this.getLocation(node), this.currentMib, name, type);
        symbol.setComment(MibAnalyzerUtil.getComments(node));
        return null;
    }

    @Override
    protected Node exitType(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitDefinedType(Production node) throws ParseException {
        MibContext local = this.getContext();
        String name = null;
        Object value = null;
        FileLocation loc = this.getLocation(node);
        block5: for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2004: {
                    name = this.getStringValue(child, 0);
                    local = this.currentMib.getImport(name);
                    if (local != null) continue block5;
                    throw new ParseException(6, "referenced module not imported '" + name + "'", child.getStartLine(), child.getStartColumn());
                }
                case 1104: {
                    name = this.getStringValue(child, 0);
                    continue block5;
                }
                case 2045: {
                    value = this.getValue(child, 0);
                }
            }
        }
        value = value instanceof Constraint ? new TypeReference(loc, local, name, (Constraint)value) : (value instanceof ArrayList ? new TypeReference(loc, local, name, (ArrayList)value) : new TypeReference(loc, local, name));
        node.addValue(value);
        return node;
    }

    @Override
    protected Node exitBuiltinType(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitNullType(Production node) {
        node.addValue(new NullType());
        return node;
    }

    @Override
    protected Node exitBooleanType(Production node) {
        node.addValue(new BooleanType());
        return node;
    }

    @Override
    protected Node exitRealType(Production node) {
        node.addValue(new RealType());
        return node;
    }

    @Override
    protected Node exitIntegerType(Production node) {
        Object obj;
        ArrayList values = this.getChildValues(node);
        IntegerType type = values.size() == 0 ? new IntegerType() : ((obj = values.get(0)) instanceof ArrayList ? new IntegerType((ArrayList)obj) : new IntegerType((Constraint)obj));
        node.addValue(type);
        return node;
    }

    @Override
    protected Node exitObjectIdentifierType(Production node) {
        node.addValue(new ObjectIdentifierType());
        return node;
    }

    @Override
    protected Node exitStringType(Production node) {
        ArrayList values = this.getChildValues(node);
        StringType type = values.size() == 0 ? new StringType() : new StringType((Constraint)values.get(0));
        node.addValue(type);
        return node;
    }

    @Override
    protected Node exitBitStringType(Production node) {
        Object obj;
        ArrayList values = this.getChildValues(node);
        BitSetType type = values.size() == 0 ? new BitSetType() : ((obj = values.get(0)) instanceof ArrayList ? new BitSetType((ArrayList)obj) : new BitSetType((Constraint)obj));
        node.addValue(type);
        return node;
    }

    @Override
    protected Node exitBitsType(Production node) {
        return this.exitBitStringType(node);
    }

    @Override
    protected Node exitSequenceType(Production node) {
        ArrayList elements = this.getChildValues(node);
        node.addValue(new SequenceType(elements));
        return node;
    }

    @Override
    protected Node exitSequenceOfType(Production node) throws ParseException {
        Constraint c = null;
        Node child = this.getChildAt(node, node.getChildCount() - 1);
        MibType type = (MibType)this.getValue(child, 0);
        if (node.getChildCount() == 4) {
            child = this.getChildAt(node, 1);
            c = (Constraint)this.getValue(child, 0);
        }
        node.addValue(new SequenceOfType(type, c));
        return node;
    }

    @Override
    protected Node exitSetType(Production node) {
        this.log.addError(this.getLocation(node), "SET type currently unsupported");
        node.addValue(new NullType());
        return node;
    }

    @Override
    protected Node exitSetOfType(Production node) {
        this.log.addError(this.getLocation(node), "SET OF type currently unsupported");
        node.addValue(new NullType());
        return node;
    }

    @Override
    protected Node exitChoiceType(Production node) {
        node.addValue(new ChoiceType(this.getChildValues(node)));
        return node;
    }

    @Override
    protected Node exitEnumeratedType(Production node) {
        this.log.addError(this.getLocation(node), "ENUMERATED type currently unsupported");
        node.addValue(new NullType());
        return node;
    }

    @Override
    protected Node exitSelectionType(Production node) {
        this.log.addError(this.getLocation(node), "selection type currently unsupported");
        node.addValue(new NullType());
        return node;
    }

    @Override
    protected Node exitTaggedType(Production node) throws ParseException {
        boolean implicit = this.implicitTags;
        Node child = this.getChildAt(node, 0);
        MibTypeTag tag = (MibTypeTag)this.getValue(child, 0);
        child = this.getChildAt(node, 1);
        if (child.getId() == 2040) {
            implicit = (Boolean)this.getValue(child, 0);
        }
        child = this.getChildAt(node, node.getChildCount() - 1);
        MibType type = (MibType)this.getValue(child, 0);
        type.setTag(implicit, tag);
        node.addValue(type);
        return node;
    }

    @Override
    protected Node exitTag(Production node) {
        int value;
        ArrayList values = this.getChildValues(node);
        int category = 2;
        if (values.size() == 1) {
            value = ((Number)values.get(0)).intValue();
        } else {
            category = (Integer)values.get(0);
            value = ((Number)values.get(1)).intValue();
        }
        node.addValue(new MibTypeTag(category, value));
        return node;
    }

    @Override
    protected Node exitClass(Production node) throws ParseException {
        Node child = this.getChildAt(node, 0);
        int category = child.getId() == 1038 ? 0 : (child.getId() == 1039 ? 1 : (child.getId() == 1040 ? 3 : 2));
        node.addValue(new Integer(category));
        return node;
    }

    @Override
    protected Node exitExplicitOrImplicitTag(Production node) throws ParseException {
        Node child = this.getChildAt(node, 0);
        if (child.getId() == 1017) {
            node.addValue(Boolean.FALSE);
        } else {
            node.addValue(Boolean.TRUE);
        }
        return node;
    }

    @Override
    protected Node exitAnyType(Production node) {
        this.log.addError(this.getLocation(node), "ANY type currently unsupported");
        node.addValue(new NullType());
        return node;
    }

    @Override
    protected Node exitElementTypeList(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitElementType(Production node) throws ParseException {
        String name = null;
        Node child = this.getChildAt(node, 0);
        if (child.getId() == 1104) {
            name = this.getStringValue(child, 0);
            child = this.getChildAt(node, 1);
        }
        if (child.getId() != 2019) {
            throw new ParseException(6, "referencing components is currently unsupported", child.getStartLine(), child.getStartColumn());
        }
        ElementType type = new ElementType(name, (MibType)this.getValue(child, 0));
        type.setComment(MibAnalyzerUtil.getComments(node));
        node.addValue(type);
        return node;
    }

    @Override
    protected Node exitOptionalOrDefaultElement(Production node) {
        this.log.addError(this.getLocation(node), "optional and default elements are currently unsupported");
        return null;
    }

    @Override
    protected Node exitValueOrConstraintList(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitNamedNumberList(Production node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            if (child.getId() != 2047) continue;
            MibValueSymbol symbol = (MibValueSymbol)child.getValue(0);
            symbol.setComment(MibAnalyzerUtil.getComments(child));
        }
        node.addValue(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitNamedNumber(Production node) throws ParseException {
        String name = this.getStringValue(this.getChildAt(node, 0), 0);
        MibValue value = (MibValue)this.getValue(this.getChildAt(node, 2), 0);
        MibValueSymbol symbol = new MibValueSymbol(this.getLocation(node), null, name, null, value);
        node.addValue(symbol);
        return node;
    }

    @Override
    protected Node exitNumber(Production node) throws ParseException {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitConstraintList(Production node) {
        Constraint result = null;
        ArrayList values = this.getChildValues(node);
        for (int i = values.size() - 1; i >= 0; --i) {
            Constraint c = (Constraint)values.get(i);
            result = result == null ? c : new CompoundConstraint(c, result);
        }
        node.addValue(result);
        return node;
    }

    @Override
    protected Node exitConstraint(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitValueConstraintList(Production node) {
        return this.exitConstraintList(node);
    }

    @Override
    protected Node exitValueConstraint(Production node) throws ParseException {
        Object obj;
        ArrayList list = this.getChildValues(node);
        MibValue lower = null;
        MibValue upper = null;
        Boolean strictLower = null;
        Boolean strictUpper = null;
        if (list.size() == 0) {
            throw new ParseException(6, "no value specified in constraint", node.getStartLine(), node.getStartColumn());
        }
        if (list.size() == 1) {
            lower = (MibValue)list.get(0);
            obj = new ValueConstraint(this.getLocation(node), lower);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                obj = list.get(i);
                if (obj instanceof Boolean && strictLower == null) {
                    strictLower = (Boolean)obj;
                    continue;
                }
                if (obj instanceof Boolean) {
                    strictUpper = (Boolean)obj;
                    continue;
                }
                if (strictLower == null) {
                    lower = (MibValue)obj;
                    continue;
                }
                upper = (MibValue)obj;
            }
            if (strictLower == null) {
                strictLower = Boolean.FALSE;
            }
            if (strictUpper == null) {
                strictUpper = Boolean.FALSE;
            }
            obj = new ValueRangeConstraint(this.getLocation(node), lower, strictLower, upper, strictUpper);
        }
        node.addValue(obj);
        return node;
    }

    @Override
    protected Node exitValueRange(Production node) throws ParseException {
        Node child = this.getChildAt(node, 0);
        if (child.getId() == 1013) {
            node.addValue(Boolean.TRUE);
        } else {
            node.addValue(Boolean.FALSE);
        }
        child = this.getChildAt(node, node.getChildCount() - 1);
        node.addValue(child.getValue(0));
        child = this.getChildAt(node, node.getChildCount() - 2);
        if (child.getId() == 1013) {
            node.addValue(Boolean.TRUE);
        } else {
            node.addValue(Boolean.FALSE);
        }
        return node;
    }

    @Override
    protected Node exitLowerEndPoint(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitUpperEndPoint(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSizeConstraint(Production node) throws ParseException {
        Constraint c = (Constraint)this.getValue(this.getChildAt(node, 1), 0);
        node.addValue(new SizeConstraint(this.getLocation(node), c));
        return node;
    }

    @Override
    protected Node exitAlphabetConstraint(Production node) {
        this.log.addError(this.getLocation(node), "FROM constraints are currently unsupported");
        return null;
    }

    @Override
    protected Node exitContainedTypeConstraint(Production node) {
        this.log.addError(this.getLocation(node), "INCLUDES constraints are currently unsupported");
        return null;
    }

    @Override
    protected Node exitInnerTypeConstraint(Production node) {
        this.log.addError(this.getLocation(node), "WITH COMPONENT(S) constraints are currently unsupported");
        return null;
    }

    @Override
    protected Node exitValueAssignment(Production node) throws ParseException {
        String name = this.getStringValue(this.getChildAt(node, 0), 0);
        if (this.currentMib.getSymbol(name) != null) {
            this.log.addWarning(this.getLocation(node), "a symbol '" + name + "' already present in the MIB at ln:" + node.getStartLine() + " col:" + node.getStartColumn());
            return null;
        }
        if (!Character.isLowerCase(name.charAt(0))) {
            this.log.addWarning(this.getLocation(node), "value identifier '" + name + "' doesn't start with a lowercase character");
        }
        MibType type = (MibType)this.getValue(this.getChildAt(node, 1), 0);
        MibValue value = (MibValue)this.getValue(this.getChildAt(node, 3), 0);
        MibValueSymbol symbol = new MibValueSymbol(this.getLocation(node), this.currentMib, name, type, value);
        symbol.setComment(MibAnalyzerUtil.getComments(node));
        return null;
    }

    @Override
    protected Node exitValue(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitDefinedValue(Production node) throws ParseException {
        String name;
        MibContext local = this.getContext();
        Node child = this.getChildAt(node, 0);
        if (child.getId() == 2004) {
            name = this.getStringValue(child, 0);
            local = this.currentMib.getImport(name);
            if (local == null) {
                throw new ParseException(6, "referenced module not imported '" + name + "'", child.getStartLine(), child.getStartColumn());
            }
            child = this.getChildAt(node, 1);
        }
        name = this.getStringValue(child, 0);
        ValueReference ref = new ValueReference(this.getLocation(node), local, name);
        node.addValue(ref);
        return node;
    }

    @Override
    protected Node exitBuiltinValue(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitNullValue(Production node) {
        node.addValue(NullValue.NULL);
        return node;
    }

    @Override
    protected Node exitBooleanValue(Production node) throws ParseException {
        Node child = this.getChildAt(node, 0);
        if (child.getId() == 1057) {
            node.addValue(BooleanValue.TRUE);
        } else {
            node.addValue(BooleanValue.FALSE);
        }
        return node;
    }

    @Override
    protected Node exitSpecialRealValue(Production node) throws ParseException {
        Float number = this.getChildAt(node, 0).getId() == 1059 ? new Float(Float.POSITIVE_INFINITY) : new Float(Float.NEGATIVE_INFINITY);
        node.addValue(new NumberValue(number));
        return node;
    }

    @Override
    protected Node exitNumberValue(Production node) throws ParseException {
        Number number;
        number = this.getChildAt(node, 0).getId() == 1012 ? (Number)((number = (Number)this.getValue(this.getChildAt(node, 1), 0)) instanceof Integer ? (Number)new Integer(-number.intValue()) : (Number)(number instanceof Long ? new Long(-number.longValue()) : ((BigInteger)number).negate())) : (Number)((Number)this.getValue(this.getChildAt(node, 0), 0));
        node.addValue(new NumberValue(number));
        return node;
    }

    @Override
    protected Node exitBinaryValue(Production node) throws ParseException {
        Node child = this.getChildAt(node, 0);
        Number number = (Number)child.getValue(0);
        String text = (String)child.getValue(1);
        node.addValue(new BinaryNumberValue(number, text.length()));
        return node;
    }

    @Override
    protected Node exitHexadecimalValue(Production node) throws ParseException {
        Node child = this.getChildAt(node, 0);
        Number number = (Number)child.getValue(0);
        String text = (String)child.getValue(1);
        node.addValue(new HexNumberValue(number, text.length()));
        return node;
    }

    @Override
    protected Node exitStringValue(Production node) throws ParseException {
        String str = this.getStringValue(this.getChildAt(node, 0), 0);
        node.addValue(new StringValue(str));
        return node;
    }

    @Override
    protected Node exitBitOrObjectIdentifierValue(Production node) throws ParseException {
        if (MibAnalyzerUtil.isBitValue(node)) {
            return this.exitBitValue(node);
        }
        return this.exitObjectIdentifierValue(node);
    }

    @Override
    protected Node exitBitValue(Production node) throws ParseException {
        ArrayList components = this.getChildValues(node);
        BitSet bits = new BitSet();
        ArrayList<ValueReference> values = new ArrayList<ValueReference>();
        for (int i = 0; i < components.size(); ++i) {
            NamedNumber number = (NamedNumber)components.get(i);
            if (number.hasNumber()) {
                bits.set(number.getNumber().intValue());
                continue;
            }
            values.add(number.getReference());
        }
        node.addValue(new BitSetValue(bits, values));
        return node;
    }

    @Override
    protected Node exitObjectIdentifierValue(Production node) throws ParseException {
        ArrayList components = this.getChildValues(node);
        MibValue parent = null;
        if (components.size() < 1) {
            throw new ParseException(6, "object identifier must contain at least one component", node.getStartLine(), node.getStartColumn());
        }
        for (int i = 0; i < components.size(); ++i) {
            NamedNumber number = (NamedNumber)components.get(i);
            if (number.hasNumber()) {
                int value = number.getNumber().intValue();
                if (parent == null && value == 0) {
                    parent = new ValueReference(this.getLocation(node), this.getContext(), "ccitt");
                    continue;
                }
                if (parent == null && value == 1) {
                    parent = new ValueReference(this.getLocation(node), this.getContext(), "iso");
                    continue;
                }
                if (parent == null && value == 2) {
                    parent = new ValueReference(this.getLocation(node), this.getContext(), "joint-iso-ccitt");
                    continue;
                }
                if (parent instanceof ObjectIdentifierValue) {
                    try {
                        parent = new ObjectIdentifierValue(this.getLocation(node), (ObjectIdentifierValue)parent, number.getName(), value);
                    }
                    catch (MibException e) {
                        this.log.addError(e.getLocation(), e.getMessage());
                        parent = null;
                    }
                    continue;
                }
                parent = new ObjectIdentifierValue(this.getLocation(node), (ValueReference)parent, number.getName(), value);
                continue;
            }
            if (parent != null) {
                throw new ParseException(6, "object identifier component '" + number.getName() + "' has been previously defined, remove any components to the left", node.getStartLine(), node.getStartColumn());
            }
            parent = number.getReference();
        }
        node.addValue(parent);
        return node;
    }

    @Override
    protected Node exitNameValueList(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitNameValueComponent(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitNameOrNumber(Production node) throws ParseException {
        NamedNumber value;
        Object obj = this.getValue(this.getChildAt(node, 0), 0);
        if (obj instanceof Number) {
            value = new NamedNumber((Number)obj);
        } else if (obj instanceof String) {
            ValueReference ref = new ValueReference(this.getLocation(node), this.getContext(), (String)obj);
            value = new NamedNumber((String)obj, ref);
        } else {
            value = (NamedNumber)obj;
        }
        node.addValue(value);
        return node;
    }

    @Override
    protected Node exitNameAndNumber(Production node) throws ParseException {
        String name = this.getStringValue(this.getChildAt(node, 0), 0);
        Object obj = this.getValue(this.getChildAt(node, 2), 0);
        NamedNumber value = obj instanceof Number ? new NamedNumber(name, (Number)obj) : new NamedNumber(name, (ValueReference)obj);
        node.addValue(value);
        return node;
    }

    @Override
    protected Node exitDefinedMacroType(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitDefinedMacroName(Production node) {
        node.addValue(((Token)node.getChildAt(0)).getImage());
        return node;
    }

    @Override
    protected Node exitSnmpModuleIdentityMacroType(Production node) throws ParseException {
        ArrayList<Object> revisions = new ArrayList<Object>();
        this.currentMib.setSmiVersion(2);
        String update = this.getStringValue(this.getChildAt(node, 1), 0);
        String org = this.getStringValue(this.getChildAt(node, 2), 0);
        String contact = this.getStringValue(this.getChildAt(node, 3), 0);
        String desc = this.getStringValue(this.getChildAt(node, 4), 0);
        for (int i = 5; i < node.getChildCount(); ++i) {
            revisions.add(this.getValue(this.getChildAt(node, i), 0));
        }
        node.addValue(new SnmpModuleIdentity(update, org, contact, desc, revisions));
        return node;
    }

    @Override
    protected Node exitSnmpObjectIdentityMacroType(Production node) throws ParseException {
        this.currentMib.setSmiVersion(2);
        SnmpStatus status = (SnmpStatus)this.getValue(this.getChildAt(node, 1), 0);
        String desc = this.getStringValue(this.getChildAt(node, 2), 0);
        String ref = node.getChildCount() <= 3 ? null : this.getStringValue(this.getChildAt(node, 3), 0);
        node.addValue(new SnmpObjectIdentity(status, desc, ref));
        return node;
    }

    @Override
    protected void childSnmpObjectTypeMacroType(Production node, Node child) throws ParseException {
        MibType type;
        if (child.getId() == 2102 && (type = (MibType)this.getValue(child, 0)) instanceof MibContext) {
            this.pushContextExtension((MibContext)((Object)type));
        }
        node.addChild(child);
    }

    @Override
    protected Node exitSnmpObjectTypeMacroType(Production node) throws ParseException {
        MibType syntax = null;
        String units = null;
        SnmpAccess access = null;
        SnmpStatus status = null;
        String desc = null;
        String ref = null;
        Object index = null;
        MibValue defVal = null;
        block10: for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2102: {
                    syntax = (MibType)this.getValue(child, 0);
                    if (syntax instanceof MibContext) {
                        this.popContext();
                    }
                    syntax.setComment(MibAnalyzerUtil.getComments(child));
                    continue block10;
                }
                case 2103: {
                    units = this.getStringValue(child, 0);
                    continue block10;
                }
                case 2104: {
                    access = (SnmpAccess)this.getValue(child, 0);
                    continue block10;
                }
                case 2100: {
                    status = (SnmpStatus)this.getValue(child, 0);
                    continue block10;
                }
                case 2098: {
                    desc = this.getStringValue(child, 0);
                    continue block10;
                }
                case 2101: {
                    ref = this.getStringValue(child, 0);
                    continue block10;
                }
                case 2105: {
                    index = this.getValue(child, 0);
                    continue block10;
                }
                case 2109: {
                    defVal = (MibValue)this.getValue(child, 0);
                }
            }
        }
        SnmpObjectType type = index instanceof ArrayList ? new SnmpObjectType(syntax, units, access, status, desc, ref, (ArrayList)index, defVal) : new SnmpObjectType(syntax, units, access, status, desc, ref, (MibValue)index, defVal);
        node.addValue(type);
        return node;
    }

    @Override
    protected Node exitSnmpNotificationTypeMacroType(Production node) throws ParseException {
        ArrayList objects = new ArrayList();
        SnmpStatus status = null;
        String desc = null;
        String ref = null;
        this.currentMib.setSmiVersion(2);
        block6: for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2110: {
                    objects = (ArrayList)this.getValue(child, 0);
                    continue block6;
                }
                case 2100: {
                    status = (SnmpStatus)this.getValue(child, 0);
                    continue block6;
                }
                case 2098: {
                    desc = this.getStringValue(child, 0);
                    continue block6;
                }
                case 2101: {
                    ref = this.getStringValue(child, 0);
                }
            }
        }
        node.addValue(new SnmpNotificationType(objects, status, desc, ref));
        return node;
    }

    @Override
    protected Node exitSnmpTrapTypeMacroType(Production node) throws ParseException {
        MibValue enterprise = null;
        ArrayList vars = new ArrayList();
        String desc = null;
        String ref = null;
        block6: for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2112: {
                    enterprise = (MibValue)this.getValue(child, 0);
                    continue block6;
                }
                case 2113: {
                    vars = child.getAllValues();
                    continue block6;
                }
                case 2098: {
                    desc = this.getStringValue(child, 0);
                    continue block6;
                }
                case 2101: {
                    ref = this.getStringValue(child, 0);
                }
            }
        }
        node.addValue(new SnmpTrapType(enterprise, vars, desc, ref));
        return node;
    }

    @Override
    protected Node exitSnmpTextualConventionMacroType(Production node) throws ParseException {
        String display = null;
        SnmpStatus status = null;
        String desc = null;
        String ref = null;
        MibType syntax = null;
        this.currentMib.setSmiVersion(2);
        block7: for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2114: {
                    display = this.getStringValue(child, 0);
                    continue block7;
                }
                case 2100: {
                    status = (SnmpStatus)this.getValue(child, 0);
                    continue block7;
                }
                case 2098: {
                    desc = this.getStringValue(child, 0);
                    continue block7;
                }
                case 2101: {
                    ref = this.getStringValue(child, 0);
                    continue block7;
                }
                case 2102: {
                    syntax = (MibType)this.getValue(child, 0);
                    syntax.setComment(MibAnalyzerUtil.getComments(child));
                }
            }
        }
        node.addValue(new SnmpTextualConvention(display, status, desc, ref, syntax));
        return node;
    }

    @Override
    protected Node exitSnmpObjectGroupMacroType(Production node) throws ParseException {
        this.currentMib.setSmiVersion(2);
        ArrayList objects = (ArrayList)this.getValue(this.getChildAt(node, 1), 0);
        SnmpStatus status = (SnmpStatus)this.getValue(this.getChildAt(node, 2), 0);
        String desc = this.getStringValue(this.getChildAt(node, 3), 0);
        String ref = node.getChildCount() <= 4 ? null : this.getStringValue(this.getChildAt(node, 4), 0);
        node.addValue(new SnmpObjectGroup(objects, status, desc, ref));
        return node;
    }

    @Override
    protected Node exitSnmpNotificationGroupMacroType(Production node) throws ParseException {
        this.currentMib.setSmiVersion(2);
        ArrayList notifications = this.getChildAt(node, 1).getAllValues();
        SnmpStatus status = (SnmpStatus)this.getValue(this.getChildAt(node, 2), 0);
        String desc = this.getStringValue(this.getChildAt(node, 3), 0);
        String ref = node.getChildCount() <= 4 ? null : this.getStringValue(this.getChildAt(node, 4), 0);
        node.addValue(new SnmpNotificationGroup(notifications, status, desc, ref));
        return node;
    }

    @Override
    protected Node exitSnmpModuleComplianceMacroType(Production node) throws ParseException {
        SnmpStatus status = null;
        String desc = null;
        String ref = null;
        ArrayList modules = new ArrayList();
        this.currentMib.setSmiVersion(2);
        block5: for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2100: {
                    status = (SnmpStatus)this.getValue(child, 0);
                    continue block5;
                }
                case 2098: {
                    desc = this.getStringValue(child, 0);
                    continue block5;
                }
                case 2101: {
                    ref = this.getStringValue(child, 0);
                    continue block5;
                }
            }
        }
        node.addValue(new SnmpModuleCompliance(status, desc, ref, modules));
        return node;
    }

    @Override
    protected Node exitSnmpAgentCapabilitiesMacroType(Production node) throws ParseException {
        String prod = null;
        SnmpStatus status = null;
        String desc = null;
        String ref = null;
        ArrayList<Object> modules = new ArrayList<Object>();
        this.currentMib.setSmiVersion(2);
        block7: for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2123: {
                    prod = this.getStringValue(child, 0);
                    continue block7;
                }
                case 2100: {
                    status = (SnmpStatus)this.getValue(child, 0);
                    continue block7;
                }
                case 2098: {
                    desc = this.getStringValue(child, 0);
                    continue block7;
                }
                case 2101: {
                    ref = this.getStringValue(child, 0);
                    continue block7;
                }
                case 2124: {
                    modules.add(this.getValue(child, 0));
                }
            }
        }
        node.addValue(new SnmpAgentCapabilities(prod, status, desc, ref, modules));
        return node;
    }

    @Override
    protected Node exitSnmpUpdatePart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpOrganizationPart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpContactPart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpDescrPart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpRevisionPart(Production node) throws ParseException {
        MibValue value = (MibValue)this.getValue(this.getChildAt(node, 1), 0);
        String desc = this.getStringValue(this.getChildAt(node, 3), 0);
        SnmpRevision rev = new SnmpRevision(value, desc);
        rev.setComment(MibAnalyzerUtil.getComments(node));
        node.addValue(rev);
        return node;
    }

    @Override
    protected Node exitSnmpStatusPart(Production node) throws ParseException {
        Node child = this.getChildAt(node, 1);
        String name = this.getStringValue(child, 0);
        if (name.equals("mandatory")) {
            node.addValue(SnmpStatus.MANDATORY);
        } else if (name.equals("optional")) {
            node.addValue(SnmpStatus.OPTIONAL);
        } else if (name.equals("current")) {
            node.addValue(SnmpStatus.CURRENT);
        } else if (name.equals("deprecated")) {
            node.addValue(SnmpStatus.DEPRECATED);
        } else if (name.equals("obsolete")) {
            node.addValue(SnmpStatus.OBSOLETE);
        } else {
            node.addValue(SnmpStatus.CURRENT);
            throw new ParseException(6, "unrecognized status value: '" + name + "'", child.getStartLine(), child.getStartColumn());
        }
        return node;
    }

    @Override
    protected Node exitSnmpReferPart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpSyntaxPart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpUnitsPart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpAccessPart(Production node) throws ParseException {
        String name;
        Node child = this.getChildAt(node, 0);
        if (child.getId() != 1081) {
            this.currentMib.setSmiVersion(2);
        }
        if ((name = this.getStringValue(child = this.getChildAt(node, 1), 0)).equals("read-only")) {
            node.addValue(SnmpAccess.READ_ONLY);
        } else if (name.equals("read-write")) {
            node.addValue(SnmpAccess.READ_WRITE);
        } else if (name.equals("read-create")) {
            node.addValue(SnmpAccess.READ_CREATE);
        } else if (name.equals("write-only")) {
            node.addValue(SnmpAccess.WRITE_ONLY);
        } else if (name.equals("not-implemented")) {
            node.addValue(SnmpAccess.NOT_IMPLEMENTED);
        } else if (name.equals("not-accessible")) {
            node.addValue(SnmpAccess.NOT_ACCESSIBLE);
        } else if (name.equals("accessible-for-notify")) {
            node.addValue(SnmpAccess.ACCESSIBLE_FOR_NOTIFY);
        } else {
            node.addValue(SnmpAccess.READ_WRITE);
            throw new ParseException(6, "unrecognized access value: '" + name + "'", child.getStartLine(), child.getStartColumn());
        }
        return node;
    }

    @Override
    protected Node exitSnmpIndexPart(Production node) throws ParseException {
        if (this.getChildAt(node, 0).getId() == 1084) {
            node.addValue(this.getChildValues(node));
        } else {
            node.addValues(this.getChildValues(node));
        }
        return node;
    }

    @Override
    protected Node exitIndexValueList(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitIndexValue(Production node) {
        SnmpIndex index;
        Object obj = this.getChildValues(node).get(0);
        switch (node.getChildAt(0).getId()) {
            case 2066: {
                index = new SnmpIndex(false, (MibValue)obj, null);
                break;
            }
            case 1086: {
                index = new SnmpIndex(true, (MibValue)obj, null);
                break;
            }
            default: {
                index = new SnmpIndex(false, null, (MibType)obj);
            }
        }
        node.addValue(index);
        return node;
    }

    @Override
    protected Node exitIndexType(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpDefValPart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpObjectsPart(Production node) {
        node.addValue(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitValueList(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpEnterprisePart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpVarPart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpDisplayPart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpNotificationsPart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpModulePart(Production node) throws ParseException {
        String name = null;
        ArrayList groups = new ArrayList();
        ArrayList<Object> modules = new ArrayList<Object>();
        String comment = null;
        block6: for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 1093: {
                    comment = MibAnalyzerUtil.getComments(child);
                    continue block6;
                }
                case 2117: {
                    name = this.getStringValue(child, 0);
                    this.popContext();
                    continue block6;
                }
                case 2118: {
                    groups = (ArrayList)this.getValue(child, 0);
                    continue block6;
                }
                case 2119: {
                    modules.add(this.getValue(child, 0));
                }
            }
        }
        SnmpModule module = new SnmpModule(name, groups, modules);
        module.setComment(comment);
        node.addValue(module);
        return node;
    }

    @Override
    protected Node exitSnmpModuleImport(Production node) throws ParseException {
        String module = this.getStringValue(this.getChildAt(node, 0), 0);
        this.loader.scheduleLoad(module);
        MibImport imp = new MibImport(this.loader, this.getLocation(node), module, null);
        this.currentMib.addImport(imp);
        this.pushContextExtension(imp);
        node.addValue(module);
        return node;
    }

    @Override
    protected Node exitSnmpMandatoryPart(Production node) {
        node.addValue(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpCompliancePart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitComplianceGroup(Production node) throws ParseException {
        MibValue value = (MibValue)this.getValue(this.getChildAt(node, 1), 0);
        String desc = this.getStringValue(this.getChildAt(node, 2), 0);
        SnmpCompliance comp = new SnmpCompliance(true, value, null, null, null, desc);
        comp.setComment(MibAnalyzerUtil.getComments(node));
        node.addValue(comp);
        return node;
    }

    @Override
    protected Node exitComplianceObject(Production node) throws ParseException {
        MibValue value = null;
        MibType syntax = null;
        MibType write = null;
        SnmpAccess access = null;
        String desc = null;
        block7: for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2066: {
                    value = (MibValue)this.getValue(child, 0);
                    continue block7;
                }
                case 2102: {
                    syntax = (MibType)this.getValue(child, 0);
                    syntax.setComment(MibAnalyzerUtil.getComments(child));
                    continue block7;
                }
                case 2122: {
                    write = (MibType)this.getValue(child, 0);
                    write.setComment(MibAnalyzerUtil.getComments(child));
                    continue block7;
                }
                case 2104: {
                    access = (SnmpAccess)this.getValue(child, 0);
                    continue block7;
                }
                case 2098: {
                    desc = this.getStringValue(child, 0);
                }
            }
        }
        SnmpCompliance comp = new SnmpCompliance(false, value, syntax, write, access, desc);
        comp.setComment(MibAnalyzerUtil.getComments(node));
        node.addValue(comp);
        return node;
    }

    @Override
    protected Node exitSnmpWriteSyntaxPart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpProductReleasePart(Production node) {
        node.addValues(this.getChildValues(node));
        return node;
    }

    @Override
    protected Node exitSnmpModuleSupportPart(Production node) throws ParseException {
        String module = null;
        ArrayList groups = null;
        ArrayList<Object> vars = new ArrayList<Object>();
        block5: for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2117: {
                    module = this.getStringValue(child, 0);
                    this.popContext();
                    continue block5;
                }
                case 2111: {
                    groups = child.getAllValues();
                    continue block5;
                }
                case 2125: {
                    vars.add(this.getValue(child, 0));
                }
            }
        }
        node.addValue(new SnmpModuleSupport(module, groups, vars));
        return node;
    }

    @Override
    protected void childSnmpVariationPart(Production node, Node child) throws ParseException {
        MibType type;
        if (child.getId() == 2066) {
            MibTypeContext context = new MibTypeContext(this.getValue(child, 0));
            this.pushContextExtension(context);
        } else if (child.getId() == 2102 && (type = (MibType)this.getValue(child, 0)) instanceof MibContext) {
            this.pushContextExtension((MibContext)((Object)type));
        }
        node.addChild(child);
    }

    @Override
    protected Node exitSnmpVariationPart(Production node) throws ParseException {
        MibValue value = null;
        MibType syntax = null;
        MibType write = null;
        SnmpAccess access = null;
        ArrayList reqs = new ArrayList();
        MibValue defVal = null;
        String desc = null;
        block9: for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChildAt(i);
            switch (child.getId()) {
                case 2066: {
                    value = (MibValue)this.getValue(child, 0);
                    this.popContext();
                    continue block9;
                }
                case 2102: {
                    syntax = (MibType)this.getValue(child, 0);
                    if (syntax instanceof MibContext) {
                        this.popContext();
                    }
                    syntax.setComment(MibAnalyzerUtil.getComments(child));
                    continue block9;
                }
                case 2122: {
                    write = (MibType)this.getValue(child, 0);
                    write.setComment(MibAnalyzerUtil.getComments(child));
                    continue block9;
                }
                case 2104: {
                    access = (SnmpAccess)this.getValue(child, 0);
                    continue block9;
                }
                case 2126: {
                    reqs = (ArrayList)this.getValue(child, 0);
                    continue block9;
                }
                case 2109: {
                    defVal = (MibValue)this.getValue(child, 0);
                    continue block9;
                }
                case 2098: {
                    desc = this.getStringValue(child, 0);
                }
            }
        }
        node.addValue(new SnmpVariation(value, syntax, write, access, reqs, defVal, desc));
        return node;
    }

    @Override
    protected Node exitSnmpCreationPart(Production node) {
        node.addValue(this.getChildValues(node));
        return node;
    }

    private FileLocation getLocation(Node node) {
        return new FileLocation(this.file, node.getStartLine(), node.getStartColumn());
    }

    private MibContext getContext() {
        return (MibContext)this.contextStack.get(this.contextStack.size() - 1);
    }

    private void pushContext(MibContext context) {
        this.contextStack.add(context);
    }

    private void pushContextExtension(MibContext context) {
        this.pushContext(new CompoundContext(context, this.getContext()));
    }

    private void popContext() {
        this.contextStack.remove(this.contextStack.size() - 1);
    }
}

