/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.IOException;
import java.io.StringReader;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.re.Element;

public class Matcher {
    private Element element;
    private ReaderBuffer buffer;
    private boolean ignoreCase;
    private int start;
    private int length;
    private boolean endOfString;

    Matcher(Element e, ReaderBuffer buffer, boolean ignoreCase) {
        this.element = e;
        this.buffer = buffer;
        this.ignoreCase = ignoreCase;
        this.start = 0;
        this.reset();
    }

    public boolean isCaseInsensitive() {
        return this.ignoreCase;
    }

    public void reset() {
        this.length = -1;
        this.endOfString = false;
    }

    public void reset(String str) {
        this.reset(new ReaderBuffer(new StringReader(str)));
    }

    public void reset(ReaderBuffer buffer) {
        this.buffer = buffer;
        this.reset();
    }

    public int start() {
        return this.start;
    }

    public int end() {
        if (this.length > 0) {
            return this.start + this.length;
        }
        return this.start;
    }

    public int length() {
        return this.length;
    }

    public boolean hasReadEndOfString() {
        return this.endOfString;
    }

    void setReadEndOfString() {
        this.endOfString = true;
    }

    public boolean matchFromBeginning() throws IOException {
        return this.matchFrom(0);
    }

    public boolean matchFrom(int pos) throws IOException {
        this.reset();
        this.start = pos;
        this.length = this.element.match(this, this.buffer, this.start, 0);
        return this.length >= 0;
    }

    public String toString() {
        if (this.length <= 0) {
            return "";
        }
        int pos = this.buffer.position();
        return this.buffer.subSequence(pos, pos + this.length).toString();
    }
}

