/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.enums.BSnmpAccessEnum;
import com.tridium.snmp.enums.BSnmpMipEntryTypeEnum;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.mib.MibConst;
import com.tridium.snmp.mib.MibIISystem;
import com.tridium.snmp.mib.MibObject;
import com.tridium.snmp.mib.OidElement;
import com.tridium.snmp.mib.OidEntry;
import com.tridium.snmp.util.SnmpUtil;
import java.util.HashMap;
import java.util.Map;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BajaRuntimeException;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibImport;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpNotificationType;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpTextualConvention;
import net.percederberg.mibble.snmp.SnmpTrapType;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.type.SizeConstraint;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class OidUtil
implements MibConst {
    public static Map<String, String> mibTypeValueMap = new HashMap<String, String>();

    public static OidElement createOidEntries(Mib mib, BSnmpNetwork snmp) {
        OidElement oidBase = new OidElement(1L);
        Object[] oa = mib.getAllSymbols().toArray();
        OidUtil.getMibImportedTypeSymbol(mib, mibTypeValueMap);
        Array a = new Array(MibValueSymbol.class);
        for (int i = 0; i < oa.length; ++i) {
            MibTypeSymbol ts;
            String displayHint = "";
            if (oa[i] instanceof MibTypeSymbol && (ts = (MibTypeSymbol)oa[i]).getType() instanceof SnmpTextualConvention) {
                SnmpTextualConvention stc = (SnmpTextualConvention)ts.getType();
                displayHint = stc.getDisplayHint();
                mibTypeValueMap.put(ts.getName(), displayHint);
            }
            if (!(oa[i] instanceof MibValueSymbol)) continue;
            MibValueSymbol vs = (MibValueSymbol)oa[i];
            a.add((Object)vs);
        }
        MibValueSymbol[] vsa = (MibValueSymbol[])a.trim();
        OidUtil.createOidEntries(vsa, oidBase, snmp, false, mibTypeValueMap);
        OidUtil.createTrapTypes(mib, oidBase, snmp, mibTypeValueMap);
        return oidBase;
    }

    private static void getMibImportedTypeSymbol(Mib mib, Map<String, String> mibTypeValueMap) {
        Object[] allImportedMibRefArray = mib.getAllImports().toArray();
        for (int i = 0; i < allImportedMibRefArray.length; ++i) {
            MibImport mi = (MibImport)allImportedMibRefArray[i];
            Mib importedMib = mi.getMib();
            Object[] importedMibSymbolArray = importedMib.getAllSymbols().toArray();
            for (int j = 0; j < importedMibSymbolArray.length; ++j) {
                MibTypeSymbol ImportedMibTypeSymbol;
                if (!(importedMibSymbolArray[j] instanceof MibTypeSymbol) || !((ImportedMibTypeSymbol = (MibTypeSymbol)importedMibSymbolArray[j]).getType() instanceof SnmpTextualConvention)) continue;
                SnmpTextualConvention stc = (SnmpTextualConvention)ImportedMibTypeSymbol.getType();
                String displayHint = stc.getDisplayHint();
                mibTypeValueMap.put(ImportedMibTypeSymbol.getName(), displayHint);
            }
        }
    }

    public static void createOidEntries(MibValueSymbol[] vsa, OidElement oidBase, BSnmpNetwork snmp, boolean tableEntries, Map<String, String> mibTypeValueMap) {
        if (vsa == null) {
            return;
        }
        for (int i = 0; i < vsa.length; ++i) {
            MibValueSymbol vs = vsa[i];
            if (vs == null) continue;
            MibType mt = vs.getType();
            boolean enterTable = false;
            if (mt instanceof SnmpObjectType) {
                SnmpObjectType sot = (SnmpObjectType)mt;
                MibType syt = sot.getSyntax();
                BSnmpMipEntryTypeEnum elementType = BSnmpMipEntryTypeEnum.nonsequence;
                if (tableEntries) {
                    elementType = BSnmpMipEntryTypeEnum.sequenceElement;
                } else if (syt instanceof SequenceOfType) {
                    elementType = BSnmpMipEntryTypeEnum.sequence;
                } else if (syt instanceof SequenceType) {
                    elementType = BSnmpMipEntryTypeEnum.sequenceEntry;
                    enterTable = true;
                }
                OidUtil.createOidEntry(vs, sot, elementType, oidBase, snmp, mibTypeValueMap);
            } else if (mt instanceof SnmpNotificationType) {
                OidUtil.createOidEntry(vs, (SnmpType)mt, BSnmpMipEntryTypeEnum.notification, oidBase, snmp, mibTypeValueMap);
            }
            OidUtil.createOidEntries(vs.getChildren(), oidBase, snmp, enterTable, mibTypeValueMap);
        }
    }

    private static void createTrapTypes(Mib m, OidElement oidBase, BSnmpNetwork snmp, Map<String, String> mibTypeValueMap) {
        Object[] a = m.getAllSymbols().toArray();
        for (int i = 0; i < a.length; ++i) {
            MibValueSymbol vs;
            if (!(a[i] instanceof MibValueSymbol) || !((vs = (MibValueSymbol)a[i]).getType() instanceof SnmpTrapType)) continue;
            OidUtil.createOidEntry(vs, (SnmpType)vs.getType(), BSnmpMipEntryTypeEnum.trap, oidBase, snmp, mibTypeValueMap);
        }
    }

    private static void createOidEntry(MibValueSymbol vs, SnmpType typ, BSnmpMipEntryTypeEnum elementType, OidElement oidBase, BSnmpNetwork snmp, Map<String, String> mibTypeValueMap) {
        SnmpStatus st;
        String oid = vs.getValue().toString();
        String displayHint = "";
        String name = vs.getName();
        String status = " ";
        String desc = " ";
        String objSyntax = " ";
        BSnmpAccessEnum access = BSnmpAccessEnum.notAccessible;
        BSnmpVariableTypeEnum varType = null;
        if (typ instanceof SnmpObjectType) {
            String display;
            SnmpObjectType sot = (SnmpObjectType)typ;
            st = sot.getStatus();
            if (st != null) {
                status = st.toString();
            }
            displayHint = (display = mibTypeValueMap.get(objSyntax = OidUtil.getSyntax(sot.getSyntax()))) == null ? "" : display;
            desc = typ.getDescription();
            access = OidUtil.getAccess(sot.getAccess());
            MibTypeTag tag = sot.getSyntax().getTag();
            if (tag != null) {
                try {
                    varType = OidUtil.getVariableTypeFromTag(tag);
                }
                catch (Throwable throwable) {}
            }
        } else if (typ instanceof SnmpNotificationType) {
            SnmpNotificationType not = (SnmpNotificationType)typ;
            st = not.getStatus();
            if (st != null) {
                status = st.toString();
            }
            objSyntax = "notification-type";
            desc = OidUtil.getNotificationDesc(vs, not);
        } else if (typ instanceof SnmpTrapType) {
            SnmpTrapType trap = (SnmpTrapType)typ;
            desc = OidUtil.getTrapDesc(vs, trap);
            oid = trap.getEnterprise().toString() + "." + oid;
            objSyntax = "trap-type";
        } else {
            return;
        }
        MibIISystem mib = new MibIISystem(snmp);
        if (vs.isScalar()) {
            oid = oid + ".0";
        }
        long[] a = SnmpUtil.getLongArray((String)oid);
        long ndx = a[a.length - 1];
        OidEntry oidEntry = new OidEntry(oid, 1, name, status, desc, (MibObject)mib, ndx, access, objSyntax, elementType, varType, displayHint);
        if (typ instanceof SnmpObjectType) {
            OidUtil.getConstraints(((SnmpObjectType)typ).getSyntax(), oidEntry);
        }
        OidElement element = oidBase;
        for (int i = 0; i < a.length - 1; ++i) {
            OidElement child = element.getChild(a[i]);
            if (child == null) {
                child = new OidElement(a[i]);
                element.addChild(child);
            }
            element = child;
        }
        element.addChild((OidElement)oidEntry);
    }

    public static BSnmpAccessEnum getAccess(SnmpAccess sa) {
        if (sa == SnmpAccess.READ_ONLY) {
            return BSnmpAccessEnum.readOnly;
        }
        if (sa == SnmpAccess.READ_WRITE) {
            return BSnmpAccessEnum.readWrite;
        }
        if (sa == SnmpAccess.NOT_ACCESSIBLE) {
            return BSnmpAccessEnum.notAccessible;
        }
        if (sa == SnmpAccess.WRITE_ONLY) {
            return BSnmpAccessEnum.writeOnly;
        }
        if (sa == SnmpAccess.READ_CREATE) {
            return BSnmpAccessEnum.readCreate;
        }
        return BSnmpAccessEnum.notAccessible;
    }

    private static String getSyntax(MibType syn) {
        if (syn.isPrimitive()) {
            return syn.getName();
        }
        return syn.getReferenceSymbol().getName();
    }

    private static String getNotificationDesc(MibValueSymbol vs, SnmpNotificationType snt) {
        StringBuffer sb = new StringBuffer();
        sb.append("GENERIC=6");
        sb.append("; SPECIFIC=").append(((ObjectIdentifierValue)vs.getValue()).getValue());
        Object[] ovals = snt.getObjects().toArray();
        sb.append("; OBJECTS=");
        for (int x = 0; x < ovals.length; ++x) {
            if (x > 0) {
                sb.append(",");
            }
            sb.append(((MibValue)ovals[x]).getName());
        }
        sb.append("; DESCRIPTION=").append(snt.getDescription());
        sb.append("; REFERENCE=").append(snt.getReference());
        return sb.toString();
    }

    private static String getTrapDesc(MibValueSymbol vs, SnmpTrapType tt) {
        StringBuffer sb = new StringBuffer();
        sb.append("GENERIC=6");
        sb.append("; SPECIFIC=").append(((Number)((NumberValue)vs.getValue()).toObject()).intValue());
        sb.append("; VARIABLES=");
        Object[] oa = tt.getVariables().toArray();
        for (int i = 0; i < oa.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(((ObjectIdentifierValue)oa[i]).getName());
        }
        sb.append("; DESCRIPTION=").append(tt.getDescription());
        sb.append("; REFERENCE=").append(tt.getReference());
        return sb.toString();
    }

    private static void getConstraints(MibType typ, OidEntry oidEntry) {
        if (typ instanceof IntegerType) {
            IntegerType ityp = (IntegerType)typ;
            if (ityp.hasSymbols()) {
                oidEntry.enumRange = OidUtil.getEnumRange(ityp);
            }
            if (!ityp.hasConstraint()) {
                return;
            }
            Constraint c = ityp.getConstraint();
            if (c instanceof ValueRangeConstraint) {
                oidEntry.range = OidUtil.getRange((ValueRangeConstraint)c);
            }
        } else if (typ instanceof StringType) {
            StringType styp = (StringType)typ;
            if (!styp.hasConstraint()) {
                return;
            }
            SizeConstraint sc = (SizeConstraint)styp.getConstraint();
            Constraint c = (Constraint)sc.getValues().toArray()[0];
            if (c instanceof ValueRangeConstraint) {
                oidEntry.size = OidUtil.getRange((ValueRangeConstraint)c);
            }
            if (c instanceof ValueConstraint) {
                oidEntry.size = OidUtil.getRange((ValueConstraint)c);
            }
        }
    }

    public static BEnumRange getEnumRange(IntegerType ityp) {
        if (!ityp.hasSymbols()) {
            return null;
        }
        MibValueSymbol[] vsa = ityp.getAllSymbols();
        int[] ordinals = new int[vsa.length];
        String[] tags = new String[vsa.length];
        for (int i = 0; i < vsa.length; ++i) {
            NumberValue nv = (NumberValue)vsa[i].getValue();
            ordinals[i] = ((Number)nv.toObject()).intValue();
            tags[i] = SlotPath.escape((String)vsa[i].getName());
        }
        return BEnumRange.make((int[])ordinals, (String[])tags);
    }

    private static OidEntry.Range getRange(ValueRangeConstraint rngC) {
        OidEntry.Range orng = new OidEntry.Range();
        orng.min = ((Number)rngC.getLowerBound().toObject()).doubleValue();
        orng.max = ((Number)rngC.getUpperBound().toObject()).doubleValue();
        return orng;
    }

    private static OidEntry.Range getRange(ValueConstraint vc) {
        OidEntry.Range orng = new OidEntry.Range();
        orng.min = 0.0;
        orng.max = ((Number)vc.getValue().toObject()).intValue();
        return orng;
    }

    public static BSnmpVariableTypeEnum getVariableTypeFromTag(MibTypeTag tag) {
        if (tag.getCategory() == 0) {
            switch (tag.getValue()) {
                case 2: {
                    return BSnmpVariableTypeEnum.integerType;
                }
                case 4: {
                    return BSnmpVariableTypeEnum.stringType;
                }
                case 6: {
                    return BSnmpVariableTypeEnum.oid;
                }
            }
        }
        if (tag.getCategory() == 1) {
            switch (tag.getValue()) {
                case 0: {
                    return BSnmpVariableTypeEnum.ipAddress;
                }
                case 1: {
                    return BSnmpVariableTypeEnum.counter;
                }
                case 2: {
                    return BSnmpVariableTypeEnum.gauge;
                }
                case 3: {
                    return BSnmpVariableTypeEnum.timeticks;
                }
                case 4: {
                    return BSnmpVariableTypeEnum.counter64;
                }
            }
        }
        throw new BajaRuntimeException("Invalid MibTypeTag " + tag);
    }
}

