/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.snmp.export.BISnmpExportFolder;
import com.tridium.snmp.export.BSnmpBooleanExport;
import com.tridium.snmp.export.BSnmpEnumExport;
import com.tridium.snmp.export.BSnmpExportFolder;
import com.tridium.snmp.export.BSnmpExportObject;
import com.tridium.snmp.export.BSnmpNumericExport;
import com.tridium.snmp.export.BSnmpStringExport;
import com.tridium.snmp.util.SnmpUtil;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrEditDialog;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import javax.baja.workbench.mgr.folder.FolderState;

public class BSnmpExportManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType(BSnmpExportManager.class);
    BISnmpExportFolder exports;
    static Lexicon lex = UiLexicon.makeUiLexicon(BSnmpExportManager.class);
    static String lexLocalObjects = lex.getText("exportManager.local");
    static String lexExportedObjects = lex.getText("exportManager.exportedObjects");
    static String lexValue = lex.getText("exportManager.value");
    static String lexTargetName = lex.getText("exportManager.targetName");
    static String lexObjectType = lex.getText("exportManager.objectType");
    static String lexObjectIdentifier = lex.getText("exportManager.objectIdentifier");
    static String lexExportOrd = lex.getText("exportManager.exportOrd");
    static String lexExportStatus = lex.getText("exportManager.exportStatus");
    static String lexFaultCause = lex.getText("exportManager.faultCause");
    static String lexDescription = lex.getText("exportManager.description");
    static String lexSlotPath = UiLexicon.bajaui().getText("slotPath");
    static String lexHandle = UiLexicon.bajaui().getText("handle");
    static String lexType = UiLexicon.bajaui().getText("type");
    static String lexInvalidOrd = lex.getText("exportManager.invalidOrd");
    static final MgrTypeInfo SNMP_BOOLEAN_POINT = MgrTypeInfo.make((BComponent)new BSnmpBooleanExport());
    static final MgrTypeInfo SNMP_BOOLEAN_WRITABLE = MgrTypeInfo.make((BComponent)new BSnmpBooleanExport());
    static final MgrTypeInfo SNMP_NUMERIC_POINT = MgrTypeInfo.make((BComponent)new BSnmpNumericExport());
    static final MgrTypeInfo SNMP_NUMERIC_WRITABLE = MgrTypeInfo.make((BComponent)new BSnmpNumericExport());
    static final MgrTypeInfo SNMP_ENUM_POINT = MgrTypeInfo.make((BComponent)new BSnmpEnumExport());
    static final MgrTypeInfo SNMP_ENUM_WRITABLE = MgrTypeInfo.make((BComponent)new BSnmpEnumExport());
    static final MgrTypeInfo SNMP_STRING_POINT = MgrTypeInfo.make((BComponent)new BSnmpStringExport());
    static final MgrTypeInfo SNMP_STRING_WRITABLE = MgrTypeInfo.make((BComponent)new BSnmpStringExport());
    static MgrTypeInfo[] NEW_TYPES = new MgrTypeInfo[]{SNMP_NUMERIC_POINT, SNMP_BOOLEAN_POINT, SNMP_ENUM_POINT, SNMP_STRING_POINT};
    MgrColumn mcolType = new MgrColumn.Type(3);
    MgrColumn mcolName = new MgrColumn.Name(1);
    MgrColumn mcolTgtOut = new TargetOutCol();
    MgrColumn mcolTgtObj = new TargetObjCol();
    MgrColumn mcolObjId = new ObjectIdCol();
    MgrColumn mcolExportOrd = new ExportOrdCol();
    MgrColumn mcolExportStatus = new StatusCol();
    MgrColumn mcolFaultCause = new FaultCauseCol();
    MgrColumn mcolDeviceFacets = new MgrColumn.PropPath(new Property[]{BSnmpExportObject.deviceFacets}, 3);
    MgrColumn[] mcols = new MgrColumn[]{this.mcolType, this.mcolName, this.mcolTgtOut, this.mcolTgtObj, this.mcolObjId, this.mcolExportOrd, this.mcolExportStatus, this.mcolFaultCause, this.mcolDeviceFacets};
    MgrColumn dcolPath = new LearnColumn(lexSlotPath, "toPathString");
    MgrColumn dcolHandle = new LearnColumn(lexHandle, "handle", 2);
    MgrColumn dcolType = new LearnColumn(lexType, "type");
    MgrColumn[] dcols = new MgrColumn[]{this.dcolPath, this.dcolHandle, this.dcolType};

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
        this.exports = (BISnmpExportFolder)value;
        this.registerFolder((BComponent)value);
        if (((FolderModel)this.getModel()).isAllDescendants()) {
            this.loadDescendants();
        }
    }

    void loadDescendants() {
        BComponent target = this.getCurrentValue().asComponent();
        BSnmpExportFolder[] fa = this.getFolders(target);
        for (int i = 0; i < fa.length; ++i) {
            this.registerFolder((BComponent)fa[i]);
        }
    }

    private void registerFolder(BComponent c) {
        Array a = new Array(BComponent.class);
        SlotCursor sc = c.getProperties();
        while (sc.next()) {
            BControlPoint o;
            Property p = sc.property();
            if (!p.getType().is(BSnmpExportObject.TYPE) || (o = ((BSnmpExportObject)sc.get()).getObject()) == null) continue;
            a.add((Object)o);
        }
        BComponent[] sub = (BComponent[])a.trim();
        this.registerForComponentEvents(sub, Integer.MAX_VALUE);
    }

    private BSnmpExportFolder[] getFolders(BComponent c) {
        Array a = new Array(BSnmpExportFolder.class);
        this.scanForFolders(c, (Array<BSnmpExportFolder>)a);
        return (BSnmpExportFolder[])a.trim();
    }

    private void scanForFolders(BComponent con, Array<BSnmpExportFolder> a) {
        SlotCursor c = con.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!p.getType().is(BSnmpExportFolder.TYPE)) continue;
            BComponent df = (BComponent)c.get();
            this.registerForComponentEvents(df, 0);
            a.add((Object)((BSnmpExportFolder)df));
            this.scanForFolders(df, a);
        }
    }

    protected MgrModel makeModel() {
        return new ExportModel(this);
    }

    protected MgrLearn makeLearn() {
        return new ExportLearn(this);
    }

    protected MgrController makeController() {
        return new ExportController(this);
    }

    protected MgrState makeState() {
        return new ExportState();
    }

    void loadNodes(ExportNode[] nodes) {
        Array acc = new Array(BComponent.class);
        for (int i = 0; i < nodes.length; ++i) {
            ExportNode node = nodes[i];
            if (node.value != null) continue;
            String handle = node.get(this.dcolHandle).toString();
            BComponent c = (BComponent)BOrd.make((String)("station:|h:" + handle)).get((BObject)node.session);
            node.value = c;
            node.name = c.getName();
            node.path = c.getSlotPath().getBody();
            acc.add((Object)c);
        }
        BComponent[] toLease = (BComponent[])acc.trim();
        BComponent.lease((BComponent[])toLease, (int)0);
    }

    BISnmpExportFolder getIExportFolder() {
        return this.exports;
    }

    static void d(String s) {
        System.out.println(s);
    }

    class ExportNode {
        public BFoxSession session;
        public BImage icon;
        public BIObject[] cells;
        ExportNode parent;
        String name;
        String path;
        BValue value;

        public ExportNode(BFoxSession session) {
            this.session = session;
        }

        public String toString() {
            return "ExportNode:n=" + this.name + ", p=" + this.path + ", v=" + this.value;
        }

        public BImage getIcon() {
            return this.icon;
        }

        public Object get(MgrColumn col) {
            return col.get((Object)this);
        }

        public boolean hasChildren() {
            return false;
        }

        public ExportNode[] getChildren() {
            return new ExportNode[0];
        }

        public BIObject[] getCells() {
            return this.cells;
        }

        public void update(BIRandomAccessTable table, int rowIndex) {
            ColumnList cols = table.getColumns();
            this.cells = new BObject[cols.size() - 1];
            for (int c = 0; c < this.cells.length; ++c) {
                this.cells[c] = table.get(rowIndex).cell(cols.get(c));
            }
            this.icon = BImage.make((String)table.get(rowIndex).cell(cols.get(cols.size() - 1)).toString());
        }

        BValue loadNode() {
            BSnmpExportManager.this.loadNodes(new ExportNode[]{this});
            return this.value;
        }

        boolean isWritable() {
            return ((BControlPoint)this.value).isWritablePoint();
        }

        BFacets getFacets() {
            return ((BControlPoint)this.value).getFacets();
        }

        public String getPath() {
            return this.path;
        }
    }

    public static class LearnColumn
    extends MgrColumn {
        public final String projection;
        int colIndex = -1;

        public LearnColumn(String displayName, String projection) {
            this(displayName, projection, 0);
        }

        public LearnColumn(String displayName, String projection, int flags) {
            super(displayName, flags);
            this.projection = projection;
        }

        public int getColumnIndex() {
            if (this.colIndex == -1) {
                MgrColumn[] cols = this.getManager().getLearn().getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i] != this) continue;
                    this.colIndex = i;
                    break;
                }
                if (this.colIndex == -1) {
                    throw new IllegalStateException("Column not found");
                }
            }
            return this.colIndex;
        }

        public Object get(Object discovery) {
            return ((ExportNode)discovery).getCells()[this.getColumnIndex()];
        }
    }

    public static class ExportOrdCol
    extends MgrColumn {
        public ExportOrdCol() {
            super(lexExportOrd, 3);
        }

        public Object get(Object row) {
            if (row instanceof BSnmpExportObject) {
                return ((BSnmpExportObject)row).getObjectOrd();
            }
            return "";
        }

        public BValue load(MgrEditRow row) throws Exception {
            BComponent c = row.getTarget();
            if (c instanceof BSnmpExportObject) {
                return ((BSnmpExportObject)c).getObjectOrd();
            }
            return BOrd.NULL;
        }

        public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
            BComponent c = row.getTarget();
            if (c instanceof BSnmpExportObject) {
                ((BSnmpExportObject)c).setObjectOrd((BOrd)value);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            if (rows == null || rows.length != 1) {
                return null;
            }
            BOrd ord = (BOrd)rows[0].getCell(colIndex);
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)ord);
            }
            BFacets facets = BFacets.make((String)"targetType", (String)"baja:Component");
            editor.loadValue((BObject)ord, (Context)facets);
            if (rows[0].getTarget() instanceof BSnmpExportFolder) {
                editor.setReadonly(true);
            }
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BOrd ord = (BOrd)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)ord);
            }
        }
    }

    public static class TargetOutCol
    extends MgrColumn {
        public TargetOutCol() {
            super(lexValue);
        }

        public TargetOutCol(String title) {
            super(title);
        }

        public Object get(Object row) {
            try {
                if (row instanceof BSnmpExportObject) {
                    return ((BSnmpExportObject)row).getObjectOrd().get((BObject)row).toString(null);
                }
                return "";
            }
            catch (Exception e) {
                return lexInvalidOrd;
            }
        }
    }

    static class FaultCauseCol
    extends MgrColumn {
        public FaultCauseCol() {
            super(lexFaultCause, 4);
        }

        public Object get(Object tgt) {
            if (tgt instanceof BSnmpExportObject) {
                return ((BSnmpExportObject)tgt).getFaultCause();
            }
            return "";
        }
    }

    static class ObjectIdCol
    extends MgrColumn {
        public ObjectIdCol() {
            super(lexObjectIdentifier, 5);
        }

        public Object get(Object tgt) {
            if (tgt instanceof BSnmpExportObject) {
                return ((BSnmpExportObject)tgt).getObjectIdentifier();
            }
            if (tgt instanceof BISnmpExportFolder) {
                return ((BISnmpExportFolder)tgt).getObjectIdentifier();
            }
            return "";
        }

        public BValue load(MgrEditRow row) throws Exception {
            return BString.make((String)((String)this.get(row.getTarget())));
        }

        public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
            BComponent tgt = row.getTarget();
            if (tgt instanceof BSnmpExportObject) {
                ((BSnmpExportObject)tgt).setObjectIdentifier(((BString)value).toString());
            } else if (tgt instanceof BISnmpExportFolder) {
                ((BISnmpExportFolder)tgt).setObjectIdentifier(((BString)value).toString());
            }
        }
    }

    static class StatusCol
    extends MgrColumn {
        public StatusCol() {
            super(lexExportStatus, 2);
        }

        public Object get(Object tgt) {
            if (tgt instanceof BSnmpExportObject) {
                return ((BSnmpExportObject)tgt).getStatus().flagsToString(null);
            }
            return "";
        }
    }

    public static class TargetObjCol
    extends MgrColumn {
        public TargetObjCol() {
            super(lexTargetName, 5);
        }

        public Object get(Object tgt) {
            if (tgt instanceof BSnmpExportObject) {
                return this.getSlotPath((BSnmpExportObject)tgt);
            }
            return "";
        }

        private String getSlotPath(BSnmpExportObject eo) {
            BOrd ord = eo.getObjectOrd();
            if (ord == null || ord.isNull()) {
                return "";
            }
            BComponentSpace cs = ((BSnmpExportManager)this.getManager()).getIExportFolder().getComponentSpace();
            try {
                return ord.resolve((BObject)cs).get().asComponent().getSlotPath().getBody();
            }
            catch (Exception e) {
                return "";
            }
        }

        public BValue load(MgrEditRow row) throws Exception {
            BComponent c = row.getTarget();
            if (c instanceof BSnmpExportObject) {
                return BString.make((String)this.getSlotPath((BSnmpExportObject)c));
            }
            return BString.DEFAULT;
        }

        public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
        }
    }

    class ExportController
    extends FolderController {
        boolean added;

        public ExportController(BSnmpExportManager manager) {
            super((BFolderManager)manager);
            this.cancel.setFlags(0);
        }

        public void updateCommands() {
            super.updateCommands();
            int[] sel = this.getSelectedRows();
            this.edit.setEnabled(sel.length > 0);
            ExportLearn lrn = (ExportLearn)this.getManager().getLearn();
            boolean addEnabled = false;
            BLearnTable lrnTbl = this.getLearnTable();
            if (lrnTbl != null) {
                Object[] dis = lrnTbl.getSelectedObjects();
                for (int i = 0; i < dis.length; ++i) {
                    if (!lrn.canExport(dis[i])) continue;
                    addEnabled = true;
                    break;
                }
            }
            this.add.setEnabled(addEnabled);
        }

        public void doAllDescendants(boolean selected) {
            super.doAllDescendants(selected);
            if (selected) {
                BSnmpExportManager.this.loadDescendants();
            }
        }

        public CommandArtifact doEdit(Context cx) throws Exception {
            BComponent[] sel = this.getSelectedComponents();
            if (sel.length == 0) {
                return null;
            }
            MgrEdit edit = this.makeEdit(this.edit.getLabel());
            for (int i = 0; i < sel.length; ++i) {
                edit.addRow(sel[i]);
            }
            edit.setSelectAll(true);
            return edit.invoke(cx);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            ExportLearn learn = (ExportLearn)this.getManager().getLearn();
            BFoxSession session = learn.getTargetSession();
            if (session == null) {
                return null;
            }
            learn.bqlDiscover(session, BTypeSpec.make((String)"control:ControlPoint"));
            return null;
        }

        protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            try {
                ExportNode[] nodes = new ExportNode[discovery.length];
                System.arraycopy(discovery, 0, nodes, 0, discovery.length);
                BSnmpExportManager.this.loadNodes(nodes);
                this.added = false;
                MgrEdit edit = new MgrEdit(this.getManager(), this.add.getLabel()){

                    public boolean prompt() throws Exception {
                        BMgrEditDialog dialog = new BMgrEditDialog((MgrEdit)this, this.getSelectAll());
                        dialog.setScreenSizeToPreferredSize();
                        dialog.setBoundsCenteredOnOwner();
                        dialog.open();
                        ExportController.this.added = dialog.getResult() == 1;
                        return ExportController.this.added;
                    }
                };
                for (int i = 0; i < discovery.length; ++i) {
                    ExportNode dis = (ExportNode)discovery[i];
                    MgrTypeInfo[] types = this.getManager().getLearn().toTypes((Object)dis);
                    if (types == null || types.length == 0) continue;
                    MgrEditRow row = edit.addRow((Object)dis, types);
                    ((ExportLearn)this.getManager().getLearn()).toRow(dis, row, edit);
                }
                CommandArtifact ret = edit.invoke(cx);
                return ret;
            }
            catch (ActionInvokeException e) {
                e.printStackTrace();
                Throwable t = e.getCause();
                if (t != null) {
                    System.out.println(" AIE caused by " + t);
                    t.printStackTrace();
                }
                throw e;
            }
        }
    }

    class ExportState
    extends FolderState {
        ExportNode[] lastLearn;

        ExportState() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BSnmpExportManager mgr = (BSnmpExportManager)m;
            ExportLearn lrn = (ExportLearn)mgr.getLearn();
            this.lastLearn = lrn.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BSnmpExportManager mgr = (BSnmpExportManager)m;
            ExportLearn lrn = (ExportLearn)mgr.getLearn();
            if (this.lastLearn != null) {
                lrn.updateTable(this.lastLearn);
            }
        }
    }

    class ExportLearn
    extends MgrLearn {
        BOrd bqlQuery;
        BComponent target;
        BFoxSession targetSession;
        ExportNode[] lastLearn;

        public ExportLearn(BSnmpExportManager manager) {
            super((BAbstractManager)manager);
        }

        public BComponent getTarget() {
            return this.target;
        }

        public BFoxSession getTargetSession() {
            return this.targetSession;
        }

        public String makeTableTitle() {
            return lexLocalObjects;
        }

        public void load(BComponent target) {
            super.load(target);
            this.target = target;
            BISession session = target.getSession();
            if (session instanceof BFoxSession) {
                this.targetSession = (BFoxSession)session;
            }
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpExportManager.this.dcols;
        }

        public BImage getIcon(Object node) {
            return ((ExportNode)node).getIcon();
        }

        public boolean isGroup(Object node) {
            return this.hasChildren(node);
        }

        public boolean hasChildren(Object node) {
            return ((ExportNode)node).hasChildren();
        }

        public Object[] getChildren(Object node) {
            return ((ExportNode)node).getChildren();
        }

        public MgrTypeInfo[] toTypes(Object dis) throws Exception {
            Array a = new Array(MgrTypeInfo.class);
            String typeSpec = BSnmpExportManager.this.dcolType.get(dis).toString();
            Type type = Sys.getRegistry().getType(typeSpec).getTypeSpec().getResolvedType();
            if (type == BNumericPoint.TYPE) {
                a.add((Object)SNMP_NUMERIC_POINT);
            } else if (type == BNumericWritable.TYPE) {
                a.add((Object)SNMP_NUMERIC_WRITABLE);
            } else if (type == BBooleanPoint.TYPE) {
                a.add((Object)SNMP_BOOLEAN_POINT);
            } else if (type == BBooleanWritable.TYPE) {
                a.add((Object)SNMP_BOOLEAN_WRITABLE);
            } else if (type == BEnumPoint.TYPE) {
                a.add((Object)SNMP_ENUM_POINT);
            } else if (type == BEnumWritable.TYPE) {
                a.add((Object)SNMP_ENUM_WRITABLE);
            } else if (type == BStringPoint.TYPE) {
                a.add((Object)SNMP_STRING_POINT);
            } else if (type == BStringWritable.TYPE) {
                a.add((Object)SNMP_STRING_WRITABLE);
            }
            return (MgrTypeInfo[])a.trim();
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            this.toRow(dis, row, row.getEdit());
        }

        public void toRow(Object dis, MgrEditRow row, MgrEdit edit) throws Exception {
            ExportNode node = (ExportNode)dis;
            node.loadNode();
            row.setCell(BSnmpExportManager.this.mcolName, (BValue)BString.make((String)node.name));
            row.setCell(BSnmpExportManager.this.mcolExportOrd, (BValue)BOrd.make((String)("h:" + node.get(BSnmpExportManager.this.dcolHandle).toString())));
            row.setCell(BSnmpExportManager.this.mcolTgtObj, (BValue)BString.make((String)SlotPath.unescape((String)node.getPath().substring(1))));
            BISnmpExportFolder fldr = ((BSnmpExportManager)this.getManager()).getIExportFolder();
            boolean isWritable = node.isWritable();
            String oid = fldr.getObjectIdentifier() + (isWritable ? ".1.1.3." : ".2.1.3.") + this.getFreeNdx(fldr, edit, isWritable);
            row.setCell(BSnmpExportManager.this.mcolObjId, (BValue)BString.make((String)oid));
            BFacets newFacets = node.getFacets();
            row.setCell(BSnmpExportManager.this.mcolDeviceFacets, (BValue)newFacets);
        }

        private int getFreeNdx(BISnmpExportFolder fldr, MgrEdit edit, boolean isWritable) {
            BSnmpExportObject[] eos = (BSnmpExportObject[])fldr.asComponent().getChildren(BSnmpExportObject.class);
            int[] ndxs = new int[eos.length + edit.getRowCount()];
            int cnt = 0;
            for (int i = 0; i < eos.length; ++i) {
                long[] a = SnmpUtil.getLongArray((String)eos[i].getObjectIdentifier());
                if (a.length < 4 || this.isWritable(a) != isWritable) continue;
                int ndx = this.getNdx(a);
                ndxs[cnt++] = ndx;
            }
            int ci = edit.getRow(0).getColumnIndex(BSnmpExportManager.this.mcolObjId);
            for (int i = 0; i < edit.getRowCount() - 1; ++i) {
                String oid = edit.getValueAt(i, ci).toString();
                long[] a = SnmpUtil.getLongArray((String)oid);
                if (a.length < 4 || this.isWritable(a) != isWritable) continue;
                int ndx = this.getNdx(a);
                ndxs[cnt++] = ndx;
            }
            return SnmpUtil.findFreeIndex((int[])ndxs, (int)cnt);
        }

        private boolean isWritable(long[] a) {
            return a[a.length - 4] == 1L;
        }

        private int getNdx(long[] a) {
            return (int)a[a.length - 1];
        }

        public boolean isExisting(Object discovery, BComponent component) {
            return !this.canExport(discovery);
        }

        private boolean canExport(Object discovery) {
            String typeSpec = BSnmpExportManager.this.dcolType.get(discovery).toString();
            TypeInfo type = Sys.getRegistry().getType(typeSpec);
            return type.is(BControlPoint.TYPE);
        }

        public void bqlDiscover(BFoxSession session, BTypeSpec filterType) throws Exception {
            BComponentSpace space;
            BStation station;
            BBqlQueryBuilder builder;
            BOrd bql;
            if (this.bqlQuery == null) {
                String projection = this.getBqlProjection();
                this.bqlQuery = BOrd.make((String)("station:|slot:/|bql:select " + projection + " from " + filterType));
            }
            if ((bql = (builder = new BBqlQueryBuilder((BObject)(station = (BStation)(space = (BComponentSpace)session.getNavChild("station")).getRootComponent()), this.bqlQuery, false)).open((BWidget)this.getManager())) == null) {
                return;
            }
            if (!bql.relativizeToSession().toString().startsWith("station")) {
                return;
            }
            this.bqlQuery = bql;
            BITable table = (BITable)bql.get((BObject)station);
            this.updateTable(session, table);
        }

        public String getBqlProjection() {
            StringBuffer s = new StringBuffer();
            MgrColumn[] cols = this.getColumns();
            for (int i = 0; i < cols.length; ++i) {
                if (i > 0) {
                    s.append(",");
                }
                LearnColumn col = (LearnColumn)cols[i];
                s.append(col.projection);
            }
            s.append(",icon");
            return s.toString();
        }

        public void updateTable(BFoxSession session, BITable table) {
            BIRandomAccessTable rtable = Tables.slurp((BITable)table);
            Object[] roots = new ExportNode[rtable.size()];
            for (int i = 0; i < roots.length; ++i) {
                roots[i] = this.makeNode(session);
                ((ExportNode)roots[i]).update(rtable, i);
            }
            this.lastLearn = roots;
            this.updateRoots(roots);
        }

        void updateTable(ExportNode[] table) {
            this.lastLearn = table;
            this.updateRoots(table);
        }

        protected ExportNode makeNode(BFoxSession session) {
            return new ExportNode(session);
        }
    }

    class ExportModel
    extends FolderModel {
        public ExportModel(BSnmpExportManager manager) {
            super((BFolderManager)manager);
        }

        public String makeTableTitle() {
            return lexExportedObjects;
        }

        public Type getFolderType() {
            return BSnmpExportFolder.TYPE;
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpExportManager.this.mcols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BSnmpExportObject.TYPE, BISnmpExportFolder.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return NEW_TYPES;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BComponent obj = type.newInstance();
            return obj;
        }
    }
}

