/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bql.util;

import com.tridium.bql.compiler.RuntimeCompilerException;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAbstractExprComponent
extends BComponent
implements BIStatus {
    public static final Property status = BAbstractExprComponent.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BAbstractExprComponent.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (int)60));
    public static final Property executionDelay = BAbstractExprComponent.newProperty((int)512, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)));
    public static final Property expr = BAbstractExprComponent.newProperty((int)512, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (int)60), (BFacets)BFacets.make((String)"multiLine", (boolean)true)));
    public static final Action execute = BAbstractExprComponent.newAction((int)20, null);
    public static final Action rebuild = BAbstractExprComponent.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BAbstractExprComponent.class);
    private OrdTarget target;
    private BqlQuery query;
    private volatile Clock.Ticket executionTicket = Clock.expiredTicket;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BRelTime getExecutionDelay() {
        return (BRelTime)this.get(executionDelay);
    }

    public void setExecutionDelay(BRelTime v) {
        this.set(executionDelay, (BValue)v, null);
    }

    public String getExpr() {
        return this.getString(expr);
    }

    public void setExpr(String v) {
        this.setString(expr, v, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public void rebuild() {
        this.invoke(rebuild, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                this.modified();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
                break;
            }
            case 12: {
                this.fwStopped();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwChanged(Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (property == status || property == faultCause) {
            return;
        }
        if (property == expr) {
            this.rebuild();
        }
        if (Flags.isExecuteOnChange((BComplex)this, (Slot)property)) {
            BRelTime delay = this.getExecutionDelay();
            if (delay.equals((Object)BRelTime.DEFAULT)) {
                this.execute();
            } else if (this.executionTicket.isExpired()) {
                this.executionTicket = Clock.schedule((BComponent)this, (BRelTime)delay, (Action)execute, null);
            }
        }
    }

    private void fwStopped() {
        this.executionTicket.cancel();
    }

    private void modified() {
        if (this.isRunning()) {
            this.rebuild();
            this.execute();
        }
    }

    public final void doExecute(Context cx) {
        Exception failX = null;
        try {
            if (this.query == null) {
                this.doRebuild();
            }
            if (this.query != null) {
                BITable result = (BITable)this.query.resolve(this.target).get();
                this.updateOutputs(result, cx);
            }
        }
        catch (RuntimeCompilerException e) {
            failX = new Exception(e.toDisplay());
        }
        catch (Exception e) {
            failX = e;
        }
        if (failX == null) {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        } else {
            this.setStatus(BStatus.make((int)18));
            this.setFaultCause(failX.toString());
        }
    }

    public final void doRebuild() {
        this.query = null;
        if (this.getExpr().trim().length() > 0) {
            this.target = BOrd.make((BOrd)this.getSpace().getAbsoluteOrd(), (BOrd)this.getHandleOrd()).resolve();
            this.query = BqlQuery.make(new StringBuffer().append('{').append(this.getExpr()).append('}').toString());
        }
    }

    protected abstract void updateOutputs(BITable<?> var1, Context var2) throws Exception;
}

