/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bql;

import com.tridium.bql.compiler.BqlParser;
import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.collection.BEmptyTable;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;

public abstract class BqlQuery
implements OrdQuery {
    protected String scheme = "bql";
    private String body;
    private String unescaped;

    public static BqlQuery make(String bqlText) {
        return BqlQuery.make("bql", bqlText);
    }

    public static BqlQuery make(String scheme, String bqlText) {
        if (bqlText == null || bqlText.length() == 0) {
            EmptyBqlQuery result = new EmptyBqlQuery();
            result.body = "";
            result.scheme = scheme;
            return result;
        }
        String unescaped = SlotPath.unescape((String)bqlText);
        BqlTokenizer tokens = new BqlTokenizer(unescaped);
        BqlParser parser = new BqlParser();
        BqlQuery result = parser.parse(tokens);
        result.body = bqlText;
        result.unescaped = unescaped;
        result.scheme = scheme;
        return result;
    }

    public abstract OrdTarget resolve(OrdTarget var1);

    public String getScheme() {
        return this.scheme;
    }

    public String getBody() {
        return this.body;
    }

    public String getUnescaped() {
        if (this.unescaped == null) {
            this.unescaped = this.body == null ? "" : SlotPath.unescape((String)this.body);
        }
        return this.unescaped;
    }

    protected void setBody(String body) {
        this.body = body;
    }

    public boolean isHost() {
        return false;
    }

    public boolean isSession() {
        return false;
    }

    public void normalize(OrdQueryList list, int index) {
    }

    public String toString() {
        return this.getScheme() + ":" + this.getBody();
    }

    public static String toBqlLiteral(BSimple s) {
        String encoded = null;
        String type = s.getType().getModule().getModuleName().equals("baja") ? s.getType().getTypeName() : s.getType().toString();
        try {
            encoded = s.encodeToString();
        }
        catch (Exception x) {
            encoded = s.toString();
        }
        return new StringBuffer().append(type).append(" '").append(SlotPath.escape((String)encoded)).append("'").toString();
    }

    private static class EmptyBqlQuery
    extends BqlQuery {
        private EmptyBqlQuery() {
        }

        @Override
        public OrdTarget resolve(OrdTarget base) {
            return new OrdTarget(base, (BObject)new BEmptyTable());
        }
    }
}

