/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.query;

import com.tridium.bql.BBqlExtent;
import com.tridium.bql.BBqlInterval;
import com.tridium.bql.BBqlLibrary;
import com.tridium.bql.BBqlTime;
import com.tridium.bql.BSelect;
import com.tridium.bql.expression.BBqlFunction;
import com.tridium.query.QueryStringVisitor;
import javax.baja.bql.BqlQuery;
import javax.baja.query.BExtent;
import javax.baja.query.BNull;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Type;

public class BqlVisitor
extends QueryStringVisitor {
    public void visit(BQuery node) {
        BSelect s;
        this.queryText.append("SELECT ");
        if (node instanceof BSelect && (s = (BSelect)node).getTop() != null) {
            this.queryText.append("TOP ").append(s.getTop().getLimit()).append(' ');
        }
        if (node.hasProjection()) {
            this.visit(node.getProjection());
        }
        if (node.hasExtent()) {
            this.visit(node.getExtent());
        }
        if (node.hasPredicate()) {
            this.queryText.append("WHERE ");
            this.visit(node.getPredicate());
            this.queryText.append(' ');
        }
        if (node.hasHaving()) {
            this.queryText.append("HAVING ");
            this.visit(node.getHaving());
            this.queryText.append(' ');
        }
        if (node.hasOrdering()) {
            this.queryText.append("ORDER BY ");
            this.visit(node.getOrdering());
            this.queryText.append(' ');
        }
    }

    public void visit(BExtent node) {
        String[] extents = node.list();
        for (int i = 0; i < extents.length; ++i) {
            if (i > 0) {
                this.queryText.append(", ");
            } else {
                this.queryText.append("FROM ");
            }
            this.queryText.append(extents[i]);
        }
        if (node instanceof BBqlExtent) {
            BBqlExtent bqlExtent = (BBqlExtent)node;
            if (bqlExtent.getDepth() != Integer.MAX_VALUE) {
                this.queryText.append(" DEPTH=").append(bqlExtent.getDepth());
            }
            if (bqlExtent.getStop()) {
                this.queryText.append(" STOP");
            }
        }
        this.queryText.append(' ');
    }

    public void visit(BFunctionExpression node) {
        BBqlFunction f;
        if (node instanceof BBqlFunction && !(f = (BBqlFunction)node).getLib().getResolvedType().equals(BBqlLibrary.TYPE)) {
            if (f.getLib().getResolvedType().equals(BBqlTime.TYPE)) {
                this.queryText.append("bqltime.");
            } else {
                this.queryText.append(f.getLib().toString()).append('.');
            }
        }
        super.visit(node);
    }

    public void visit(BSimpleExpression node) {
        BSimple s = node.getSimpleValue();
        Type t = s.getType();
        if (t.is(BString.TYPE)) {
            this.queryText.append("'").append(s.toString()).append("'");
        } else if (t.is(BNumber.TYPE)) {
            this.queryText.append(s.toString());
        } else if (t.is(BBoolean.TYPE)) {
            this.queryText.append(((BBoolean)s).getDisplayTag(null));
        } else if (t.is(BFrozenEnum.TYPE)) {
            this.queryText.append(t.toString()).append('.').append(((BFrozenEnum)s).getTag());
        } else if (t.is(BNull.TYPE)) {
            this.queryText.append(BNull.NULL.toString(null));
        } else if (t.is(BBqlInterval.TYPE)) {
            this.queryText.append("interval '").append(s.toString()).append("'");
        } else {
            this.queryText.append(BqlQuery.toBqlLiteral(s));
        }
    }
}

