/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.projection;

import com.tridium.bql.Projection;
import com.tridium.bql.collection.BqlColumnList;
import com.tridium.bql.projection.BProjectionTable;
import com.tridium.bql.projection.ColumnProjectionColumn;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.sys.BIObject;
import javax.baja.sys.Context;

public class NoProjection
implements Projection {
    protected final ColumnList overrideCols;

    public NoProjection() {
        this(null);
    }

    public NoProjection(ColumnList overrideCols) {
        this.overrideCols = overrideCols;
    }

    @Override
    public BITable<? extends BIObject> getTable(BITable<? extends BIObject> table, Context cx) {
        BqlColumnList columns = new BqlColumnList();
        this.addProjColumns(columns, table.getColumns());
        return new BProjectionTable<BIObject>(columns, table);
    }

    protected void addProjColumns(BqlColumnList projCols, ColumnList innerCols) {
        Column[] toAdd = innerCols.list();
        if (this.overrideCols != null) {
            toAdd = new Column[this.overrideCols.size()];
            for (int i = 0; i < toAdd.length; ++i) {
                toAdd[i] = innerCols.get(this.overrideCols.get(i).getName());
            }
        }
        for (Column aToAdd : toAdd) {
            if (aToAdd == null) {
                throw new IllegalStateException();
            }
            if (projCols.get(aToAdd.getName()) != null || !this.acceptColumn(aToAdd)) continue;
            projCols.addColumn(new ColumnProjectionColumn(aToAdd, null));
        }
    }

    protected boolean acceptColumn(Column col) {
        if (this.overrideCols == null) {
            return true;
        }
        return this.overrideCols.get(col.getName()) != null;
    }

    public String toString() {
        return " ";
    }
}

