/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.filter;

import com.tridium.bql.filter.BBitStringFilter;
import com.tridium.bql.filter.BNullBitString;
import com.tridium.bql.filter.BStringFilter;
import java.io.IOException;
import javax.baja.bql.BIBqlFilter;
import javax.baja.data.BIDataValue;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFacetsFilter
extends BComponent
implements BIBqlFilter,
BIQueryFilter {
    public static final Property filterEntries = BFacetsFilter.newProperty((int)0, (BValue)new BVector(), null);
    public static final Type TYPE = Sys.loadType(BFacetsFilter.class);

    public BVector getFilterEntries() {
        return (BVector)this.get(filterEntries);
    }

    public void setFilterEntries(BVector v) {
        this.set(filterEntries, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacetsFilter() {
    }

    public BFacetsFilter(String[] keys, BIBqlFilter[] values) {
        BVector entries = this.getFilterEntries();
        for (int i = 0; i < keys.length; ++i) {
            this.addFacetFilter(keys[i], values[i]);
        }
    }

    public void addFacetFilter(String key, BIBqlFilter filter) {
        BVector entries = this.getFilterEntries();
        BValue value = ((BValue)filter).newCopy(true);
        if (entries.get(key) == null) {
            entries.add(key, value);
        } else {
            entries.set(key, value);
        }
    }

    public BIBqlFilter removeFacetFilter(String key) {
        BVector entries = this.getFilterEntries();
        BValue filter = entries.get(key);
        entries.remove(key);
        return (BIBqlFilter)filter;
    }

    public String[] keys() {
        return (String[])this.getFilterEntries().getProperties().stream().map(prop -> prop.getName()).toArray(String[]::new);
    }

    public BIBqlFilter getValue(String key) {
        return (BIBqlFilter)this.getFilterEntries().get(key);
    }

    @Override
    public void init(BObject o) {
    }

    @Override
    public String getPredicate(String columnName) {
        StringBuilder pred = new StringBuilder();
        BVector entries = this.getFilterEntries();
        for (Property prop : entries.getProperties()) {
            if (pred.length() > 0) {
                pred.append(" and ");
            }
            BIBqlFilter filter = (BIBqlFilter)entries.get(prop);
            pred.append(filter.getPredicate(columnName + "." + prop.getName()));
        }
        return pred.length() > 0 ? pred.toString() : null;
    }

    public BExpression getExpression(BExpression columnExpression) {
        ExpressionBuilder builder = new ExpressionBuilder();
        BVector entries = this.getFilterEntries();
        entries.getProperties().stream().forEach(prop -> {
            String name = prop.getName();
            BFacets singleFacet = BFacets.make((String)name, (BIDataValue)((BIDataValue)entries.get(name)));
            try {
                builder.and(Predicates.like((BExpression)columnExpression, (BString)BString.make((String)("%" + singleFacet.encodeToString() + "%"))));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Invalid facet encoding");
            }
        });
        return builder.getExpression();
    }

    @Override
    public boolean accept(BObject o) {
        BFacets facets = (BFacets)o;
        BVector entries = this.getFilterEntries();
        return entries.getProperties().stream().map(prop -> {
            String name = prop.getName();
            BIBqlFilter bqlFilter = (BIBqlFilter)entries.get(name);
            if (facets.get(name) == null) {
                if (bqlFilter instanceof BStringFilter) {
                    return bqlFilter.accept((BObject)BString.DEFAULT);
                }
                if (bqlFilter instanceof BBitStringFilter) {
                    return bqlFilter.accept((BObject)BNullBitString.DEFAULT);
                }
                return false;
            }
            return bqlFilter.accept(facets.get(name));
        }).reduce(true, (a, b) -> a != false && b != false);
    }
}

