/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.expression;

import java.util.Vector;

public class Pattern {
    private static final char ONE_CHAR = '\u0000';
    private char[][] pattern;
    private boolean matchAll;

    public Pattern(String patternString) {
        this.init(patternString.toCharArray());
    }

    private void init(char[] patternStr) {
        if (patternStr.length == 0) {
            this.pattern = new char[0][];
            return;
        }
        this.matchAll = true;
        for (int i = 0; i < patternStr.length; ++i) {
            if (patternStr[i] == '*' || patternStr[i] == '%') continue;
            this.matchAll = false;
            break;
        }
        if (this.matchAll) {
            return;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        StringBuffer buf = new StringBuffer(16);
        while (true) {
            if (i == patternStr.length) {
                if (buf.length() <= 0) break;
                v.addElement(buf.toString());
                break;
            }
            if (patternStr[i] == '\\') {
                if (buf.length() == 0) {
                    buf.append(' ');
                }
                if (i < patternStr.length - 1) {
                    char next = patternStr[i + 1];
                    if (next == '%' || next == '*' || next == '_' || next == '\\') {
                        buf.append(next);
                    } else if (next == 'n') {
                        buf.append('\n');
                    } else if (next == 'r') {
                        buf.append('\r');
                    } else if (next == 't') {
                        buf.append('\t');
                    } else {
                        throw new IllegalArgumentException("Invalid escape sequence: \\" + next);
                    }
                    i += 2;
                    continue;
                }
                throw new IllegalArgumentException("Invalid escape sequence: \\");
            }
            if (patternStr[i] == '%' || patternStr[i] == '*' || patternStr[i] == '_') {
                if (patternStr[i] == '_') {
                    if (buf.length() == 0) {
                        buf.append(' ');
                    }
                    buf.append('\u0000');
                    ++i;
                    continue;
                }
                if (buf.length() > 0) {
                    v.addElement(buf.toString());
                }
                v.addElement("*");
                while (i < patternStr.length && (patternStr[i] == '%' || patternStr[i] == '*')) {
                    ++i;
                }
                buf.setLength(0);
                continue;
            }
            if (buf.length() == 0) {
                buf.append(' ');
            }
            buf.append(patternStr[i++]);
        }
        this.pattern = new char[v.size()][];
        for (int j = 0; j < v.size(); ++j) {
            this.pattern[j] = ((String)v.elementAt(j)).toCharArray();
        }
    }

    public boolean isMatch(String testStr) {
        if (this.matchAll) {
            return true;
        }
        char[] test = testStr.toCharArray();
        int ti = 0;
        int len = test.length;
        boolean afterWildcard = false;
        if (len == 0) {
            return this.pattern.length == 0;
        }
        block0: for (int pi = 0; pi < this.pattern.length; ++pi) {
            if (this.pattern[pi][0] == '*') {
                if (pi == this.pattern.length - 1) {
                    return true;
                }
                afterWildcard = true;
                continue;
            }
            while (ti < len) {
                int ei;
                int start = ti;
                for (ei = 1; ti < len && ei < this.pattern[pi].length && (this.pattern[pi][ei] == '\u0000' || this.pattern[pi][ei] == test[ti]); ++ti, ++ei) {
                }
                if (ei == this.pattern[pi].length) {
                    if (pi == this.pattern.length - 1) {
                        if (ti == len) {
                            return true;
                        }
                        if (afterWildcard) {
                            ti = len - (this.pattern[pi].length - 1);
                            continue;
                        }
                        return false;
                    }
                    afterWildcard = false;
                    continue block0;
                }
                if (ti == len) {
                    return false;
                }
                if (!afterWildcard) {
                    return false;
                }
                ti = start + 1;
                if (ti != len) continue;
                return false;
            }
        }
        return false;
    }
}

