/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.expression;

import com.tridium.bql.BBqlLibrary;
import com.tridium.bql.FunctionUtil;
import com.tridium.bql.expression.BAggregateFunction;
import com.tridium.bql.expression.BScalarFunction;
import com.tridium.query.expression.BFunction;
import java.lang.reflect.Field;
import javax.baja.query.expression.BListExpression;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public abstract class BBqlFunction
extends BFunction {
    public static final Property lib = BBqlFunction.newProperty((int)0, (BValue)BBqlLibrary.TYPE.getTypeSpec(), null);
    public static final Type TYPE = Sys.loadType(BBqlFunction.class);

    public BTypeSpec getLib() {
        return (BTypeSpec)this.get(lib);
    }

    public void setLib(BTypeSpec v) {
        this.set(lib, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBqlFunction() {
    }

    public BBqlFunction(BTypeSpec libType, String functionName, BListExpression params) {
        this.setLib(libType);
        this.setFunction(functionName);
        this.setParameterList(params);
    }

    public static synchronized BBqlFunction make(BTypeSpec libType, String functionName, BListExpression params) {
        Class cls = libType.getResolvedType().getTypeClass();
        Field aggDef = FunctionUtil.getAggregateDef(cls, functionName);
        if (aggDef == null) {
            return new BScalarFunction(libType, functionName, params);
        }
        return new BAggregateFunction(libType, functionName, params, aggDef);
    }

    public abstract boolean isScalar();

    public final boolean isAggregate() {
        return !this.isScalar();
    }

    public static String toFunctionDebug(String name, Class<?>[] types) {
        StringBuffer sb = new StringBuffer(64).append(name).append('(');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(types[i].getName());
        }
        sb.append(')');
        return sb.toString();
    }
}

