/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.expression;

import com.tridium.bql.FunctionUtil;
import com.tridium.bql.expression.BBqlFunction;
import com.tridium.bql.expression.ExprEngine;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.baja.bql.BIAggregator;
import javax.baja.naming.UnresolvedException;
import javax.baja.query.BExpression;
import javax.baja.query.BNull;
import javax.baja.query.expression.BListExpression;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BAggregateFunction
extends BBqlFunction {
    public static final Type TYPE = Sys.loadType(BAggregateFunction.class);
    private Field aggregateDef;
    private HashMap<BObject, FunctionRecord> resolvedPrototypes;
    private HashMap<BObject, HashMap> distinctParams;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BAggregateFunction() {
    }

    public BAggregateFunction(BTypeSpec libType, String functionName, BListExpression params, Field aggregateDef) {
        super(libType, functionName, params);
        this.aggregateDef = aggregateDef;
        this.resolvedPrototypes = new HashMap();
        this.distinctParams = new HashMap();
    }

    public void cloneTo(BAggregateFunction target) {
        target.resolvedPrototypes = this.resolvedPrototypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accumulate(BObject prototype, BObject target, ExprEngine engine, Context cx) {
        BExpression[] paramExprs = this.getParameterList().getExpressions();
        BObject[] paramValues = new BObject[paramExprs.length];
        for (int i = 0; i < paramExprs.length; ++i) {
            paramValues[i] = engine.evaluate(paramExprs[i], target, cx);
        }
        FunctionRecord record = null;
        BAggregateFunction bAggregateFunction = this;
        synchronized (bAggregateFunction) {
            record = this.resolvedPrototypes.get(prototype);
            if (record == null) {
                record = this.resolveFunctionInstance(paramValues);
                this.resolvedPrototypes.put(prototype, record);
            }
        }
        try {
            if (this.isDistinct()) {
                bAggregateFunction = this;
                synchronized (bAggregateFunction) {
                    if (!this.isDistinctParameters(prototype, paramValues)) {
                        return;
                    }
                }
            }
            record.aggregate.invoke((Object)record.function, (Object[])paramValues);
        }
        catch (IllegalArgumentException iae) {
            StringBuffer buf = new StringBuffer(128);
            buf.append("Error invoking aggregate function: ").append(this.getFunction().toUpperCase());
            buf.append("\nExpected to be called with formal parameter(s) matching\n");
            buf.append(BAggregateFunction.toFunctionDebug(this.getFunction(), record.aggregate.getParameterTypes()));
            buf.append("\nbut was called with:\n");
            Class[] paramTypes = new Class[paramValues.length];
            for (int i = 0; i < paramValues.length; ++i) {
                paramTypes[i] = paramValues[i].getClass();
            }
            buf.append(BAggregateFunction.toFunctionDebug(this.getFunction(), paramTypes));
            throw new UnresolvedException(buf.toString(), (Throwable)iae);
        }
        catch (Exception x) {
            throw new UnresolvedException("Error invoking accumulate method for aggregate function: " + this.getFunction(), (Throwable)x);
        }
    }

    private synchronized FunctionRecord resolveFunctionInstance(BObject[] params) {
        StringBuffer buf = new StringBuffer(128);
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getClass();
        }
        try {
            Type[] candidates = (Type[])this.aggregateDef.get(null);
            for (int c = 0; c < candidates.length; ++c) {
                try {
                    Method aggregateMethod = FunctionUtil.getFunction(candidates[c].getTypeClass(), "aggregate", paramTypes, false);
                    if (aggregateMethod == null) continue;
                    Method commitMethod = FunctionUtil.getFunction(candidates[c].getTypeClass(), "commit", new Class[0], false);
                    if (!BObject.class.isAssignableFrom(commitMethod.getReturnType())) {
                        throw new UnresolvedException("Return type must be BObject. Return type for " + this.getFunction() + " is " + commitMethod.getReturnType().getName());
                    }
                    this.setReturnType(Sys.getType(commitMethod.getReturnType()).getTypeSpec());
                    BIAggregator aggFunc = (BIAggregator)candidates[c].getInstance();
                    return new FunctionRecord(aggFunc, aggregateMethod, commitMethod);
                }
                catch (ClassCastException cce) {
                    throw new UnresolvedException("Implementation of " + candidates[c] + " does not implement BIAggregateFunction", (Throwable)cce);
                }
                catch (UnresolvedException ue) {
                    throw ue;
                }
                catch (Exception e) {
                    throw new UnresolvedException("Could not resolve: " + candidates[c], (Throwable)e);
                }
            }
            buf.append("Could not find a BIAggregateFunction that takes the following parameters:\n").append(BAggregateFunction.toFunctionDebug(this.getFunction(), paramTypes)).append("\n").append("Try narrowing your extent.");
            throw new UnresolvedException(buf.toString());
        }
        catch (IllegalAccessException iae) {
            throw new UnresolvedException("Could not cast to javax.baja.sys.Type[]", (Throwable)iae);
        }
    }

    private boolean isDistinctParameters(BObject prototype, BObject[] paramValues) {
        boolean isDistinct = false;
        HashMap paramMap = this.distinctParams.get(prototype);
        if (paramMap == null) {
            paramMap = new HashMap();
            this.distinctParams.put(prototype, paramMap);
            isDistinct = true;
        }
        for (int i = 0; i < paramValues.length; ++i) {
            if (!paramMap.containsKey(paramValues[i])) {
                isDistinct = true;
                paramMap.put(paramValues[i], new HashMap());
            }
            paramMap = (HashMap)paramMap.get(paramValues[i]);
        }
        return isDistinct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BObject evaluate(BObject root, Context cx) {
        FunctionRecord record;
        if (root == null) {
            return null;
        }
        BAggregateFunction bAggregateFunction = this;
        synchronized (bAggregateFunction) {
            record = this.resolvedPrototypes.get(root);
        }
        if (record == null) {
            return BNull.NULL;
        }
        try {
            return (BObject)record.commit.invoke((Object)record.function, (Object[])null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BNull.NULL;
        }
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    private class FunctionRecord {
        BIAggregator function;
        Method aggregate;
        Method commit;

        public FunctionRecord(BIAggregator function, Method aggregate, Method commit) {
            this.function = function;
            this.aggregate = aggregate;
            this.commit = commit;
        }
    }
}

