/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.compiler.RuntimeCompilerException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;

public class TimeUtil {
    private static final char[] DATE_DELIM = new char[]{'-', ' ', '/', '\\'};
    private static final char[] AFTER_MINUTE = new char[]{':', ' '};
    private static final char[] AFTER_SECOND = new char[]{' ', '.'};

    public static BAbsTime parseDate(String s) {
        DateTimeFields fields = new DateTimeFields();
        if (TimeUtil.parseDate(s.toCharArray(), 0, fields) != s.length()) {
            throw new RuntimeCompilerException(0, "invalid.format.date", s);
        }
        return BAbsTime.make((int)fields.year, (BMonth)BMonth.make((int)fields.month), (int)fields.day, (int)0, (int)0, (int)0, (int)0);
    }

    public static BAbsTime parseTimestamp(String s) {
        char[] c = s.toCharArray();
        int len = s.length();
        DateTimeFields fields = new DateTimeFields();
        int index = TimeUtil.parseDate(c, 0, fields);
        if (index == len || c[index] != ' ') {
            throw new RuntimeCompilerException(0, "invalid.format.timestamp", s);
        }
        if ((index = TimeUtil.parseTime(c, index + 1, fields)) != s.length()) {
            throw new RuntimeCompilerException(0, "invalid.format.timestamp", s);
        }
        return BAbsTime.make((int)fields.year, (BMonth)BMonth.make((int)fields.month), (int)fields.day, (int)fields.hour, (int)fields.minute, (int)fields.second, (int)fields.milli);
    }

    public static int parseDate(char[] c, int offset, DateTimeFields fields) {
        Object err = null;
        int oneVal = 0;
        int twoVal = 0;
        int threeVal = 0;
        int index = offset;
        int start = offset;
        int len = c.length;
        start = index;
        index = TimeUtil.advance(c, index, DATE_DELIM);
        oneVal = TimeUtil.stringToInt(c, start, index - start);
        if (index == len) {
            throw new RuntimeCompilerException(0, "invalid.format.date", new String(c));
        }
        start = ++index;
        index = TimeUtil.advance(c, index, DATE_DELIM);
        twoVal = Character.isDigit(c[start]) ? TimeUtil.stringToInt(c, start, index - start) - 1 : TimeUtil.stringToMonth(c, start, index - start);
        if (index == len) {
            throw new RuntimeCompilerException(0, "invalid.format.date", new String(c));
        }
        start = ++index;
        index = TimeUtil.advance(c, index, DATE_DELIM);
        threeVal = TimeUtil.stringToInt(c, start, index - start);
        if (oneVal > 1000) {
            fields.year = oneVal;
            fields.month = twoVal;
            fields.day = threeVal;
            return index;
        }
        if (threeVal > 1000) {
            fields.year = threeVal;
            fields.month = twoVal;
            fields.day = oneVal;
            return index;
        }
        throw new RuntimeCompilerException(0, "required.fourDigitYear", new String(c));
    }

    public static BTime parseTime(String s) {
        DateTimeFields fields = new DateTimeFields();
        if (TimeUtil.parseTime(s.toCharArray(), 0, fields) != s.length()) {
            throw new RuntimeCompilerException(0, "invalid.format.time", s);
        }
        return BTime.make((int)fields.hour, (int)fields.minute, (int)fields.second, (int)fields.milli);
    }

    private static int parseTime(char[] c, int offset, DateTimeFields fields) {
        int hour = 0;
        int minute = 0;
        int second = 0;
        int milli = 0;
        int start = offset;
        int index = offset;
        int len = c.length;
        start = index;
        index = TimeUtil.advance(c, start, ':');
        hour = TimeUtil.stringToInt(c, start, index - start);
        if (c[index++] != ':') {
            throw new RuntimeCompilerException(0, "invalid.format.time", new String(c));
        }
        start = index;
        index = TimeUtil.advance(c, start, AFTER_MINUTE);
        minute = TimeUtil.stringToInt(c, start, index - start);
        if (index != len && c[index] == ':') {
            start = ++index;
            index = TimeUtil.advance(c, start, AFTER_SECOND);
            second = TimeUtil.stringToInt(c, start, index - start);
            if (index != len && c[index] == '.') {
                start = ++index;
                index = TimeUtil.advance(c, start, ' ');
                milli = TimeUtil.stringToInt(c, start, index - start);
            }
        }
        if (hour > 23 || minute > 59 || second > 59 || milli > 999) {
            throw new RuntimeCompilerException(0, "invalid.format.time", new String(c));
        }
        fields.hour = hour;
        fields.minute = minute;
        fields.second = second;
        fields.milli = milli;
        return index;
    }

    private static boolean in(char c, char[] delim) {
        int len = delim.length;
        for (int i = 0; i < len; ++i) {
            if (delim[i] != c) continue;
            return true;
        }
        return false;
    }

    private static int advance(char[] c, int start, char[] delim) {
        int index;
        int len = c.length;
        int delimCount = delim.length;
        for (index = start; index != len; ++index) {
            for (int i = 0; i < delimCount; ++i) {
                if (c[index] != delim[i]) continue;
                return index;
            }
        }
        return index;
    }

    private static int advance(char[] c, int start, char delim) {
        int index;
        int len = c.length;
        for (index = start; index != len; ++index) {
            if (c[index] != delim) continue;
            return index;
        }
        return index;
    }

    private static int stringToInt(char[] c, int offset, int len) {
        int result = 0;
        int factor = 1;
        if (len == 0) {
            throw new NumberFormatException(new String(c, offset, len));
        }
        for (int i = offset + len - 1; i >= offset; --i) {
            if (c[i] >= '0' && c[i] <= '9') {
                result += (c[i] - 48) * factor;
            } else {
                throw new NumberFormatException(new String(c, offset, len));
            }
            factor *= 10;
        }
        return result;
    }

    private static int stringToMonth(char[] c, int offset, int len) {
        String s = new String(c, offset, len).toLowerCase();
        char first = s.charAt(0);
        switch (first) {
            case 'a': {
                if (s.equals("apr")) {
                    return 3;
                }
                if (s.equals("aug")) {
                    return 7;
                }
                return -1;
            }
            case 'd': {
                if (s.equals("dec")) {
                    return 11;
                }
                return -1;
            }
            case 'f': {
                if (s.equals("feb")) {
                    return 1;
                }
                return -1;
            }
            case 'j': {
                if (s.equals("jan")) {
                    return 0;
                }
                if (s.equals("jun")) {
                    return 5;
                }
                if (s.equals("jul")) {
                    return 6;
                }
                return -1;
            }
            case 'm': {
                if (s.equals("mar")) {
                    return 2;
                }
                if (s.equals("may")) {
                    return 4;
                }
                return -1;
            }
            case 'n': {
                if (s.equals("nov")) {
                    return 10;
                }
                return -1;
            }
            case 'o': {
                if (s.equals("oct")) {
                    return 9;
                }
                return -1;
            }
            case 's': {
                if (s.equals("sep")) {
                    return 8;
                }
                return -1;
            }
        }
        return -1;
    }

    private static class DateTimeFields {
        public int year = 0;
        public int month = 0;
        public int day = 0;
        public int hour = 0;
        public int minute = 0;
        public int second = 0;
        public int milli = 0;

        private DateTimeFields() {
        }
    }

    private static class CharBuf {
        public char[] buf;
        public int offset;
        public int len;
        public int end;
        public int index;

        public CharBuf(char[] buf, int offset, int len) {
            this.buf = buf;
            this.offset = offset;
            this.len = len;
            this.end = offset + len;
            this.index = offset;
        }

        public final boolean done() {
            return this.index == this.end;
        }

        public final void advance() {
            if (this.index != this.end) {
                ++this.index;
            }
        }

        public final void skip(char delim) {
            while (this.index != this.end && this.buf[this.index] == delim) {
                ++this.index;
            }
        }

        public final void skip(char[] delim) {
            while (this.index != this.end && TimeUtil.in(this.buf[this.index], delim)) {
                ++this.index;
            }
        }

        public final void checkDone(String errKey) {
            if (this.index != this.end) {
                throw new RuntimeCompilerException(0, errKey, this.toString());
            }
        }

        public final void checkNotDone(String errKey) {
            if (this.index == this.end) {
                throw new RuntimeCompilerException(0, errKey, this.toString());
            }
        }

        public final void checkCurrent(char c, String errKey) {
            if (this.index == this.end || this.buf[this.index] != c) {
                throw new RuntimeCompilerException(0, errKey, this.toString());
            }
        }

        public final int readNumber() {
            int start = this.index;
            if (!Character.isDigit(this.buf[start])) {
                System.out.println("not digit: '" + this.buf[start] + "'");
                throw new RuntimeCompilerException(0, "invalid.format.interval", new String(this.buf, this.offset, this.len));
            }
            while (this.index < this.end && Character.isDigit(this.buf[this.index])) {
                ++this.index;
            }
            return TimeUtil.stringToInt(this.buf, start, this.index - start);
        }

        public final String readString(char[] delim) {
            int strStart = this.index;
            while (this.index < this.end && !TimeUtil.in(this.buf[this.index], delim)) {
                ++this.index;
            }
            int strEnd = this.index;
            int last = strEnd - 1;
            if (this.buf[last] == 's' && last != strStart) {
                --strEnd;
            }
            return new String(this.buf, strStart, strEnd - strStart);
        }

        public final String toString() {
            return new String(this.buf, this.offset, this.len);
        }
    }
}

