/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.collection;

import com.tridium.bql.collection.BqlColumn;
import com.tridium.bql.collection.ColumnUtil;
import com.tridium.bql.collection.FieldColumn;
import com.tridium.bql.collection.PropertyColumn;
import com.tridium.script.PropertyField;
import com.tridium.script.ScriptField;
import com.tridium.script.ScriptUtil;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class TypeColumnList
implements ColumnList {
    Context cx;
    BObject prototype;
    ArrayList<Column> list;
    HashMap<String, Column> table;
    boolean loaded;

    public TypeColumnList(Type baseType, Context cx) {
        this.cx = cx;
        this.prototype = ColumnUtil.makePrototype(baseType);
        this.loaded = false;
    }

    public int size() {
        this.load();
        return this.list.size();
    }

    public Column get(int index) {
        this.load();
        return this.list.get(index);
    }

    public synchronized Column get(String name) {
        if (this.loaded) {
            return this.table.get(name);
        }
        ScriptField field = ScriptUtil.getField(this.prototype, name);
        if (field == null) {
            return null;
        }
        if (field instanceof PropertyField) {
            return new PropertyColumn(((PropertyField)field).getProperty());
        }
        return new FieldColumn(field, this.cx);
    }

    public int indexOf(String name) {
        this.load();
        int count = this.list.size();
        for (int i = 0; i < count; ++i) {
            if (!this.list.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public Column[] list() {
        this.load();
        return this.list.toArray(new Column[this.list.size()]);
    }

    private synchronized void load() {
        this.list = new ArrayList(32);
        this.table = new HashMap();
        for (ScriptField field : ScriptUtil.scriptFields(this.prototype)) {
            BqlColumn col;
            if (field.isProperty()) {
                col = new PropertyColumn(((PropertyField)field).getProperty());
                this.list.add(col);
                this.table.put(((PropertyColumn)col).getName(), col);
                continue;
            }
            col = new FieldColumn(field, this.cx);
            this.list.add(col);
            this.table.put(((FieldColumn)col).getName(), col);
        }
        this.loaded = true;
    }
}

