/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.collection;

import com.tridium.bql.collection.BqlColumn;
import com.tridium.bql.util.BqlUtil;
import com.tridium.script.ScriptField;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class FieldColumn
extends BqlColumn {
    private Context cx;
    private ScriptField field;
    private Type columnType;

    public FieldColumn(ScriptField field, Context cx) {
        this.field = field;
        this.cx = cx;
        this.columnType = BqlUtil.toType(field.scriptType());
    }

    public String getName() {
        return this.field.scriptName();
    }

    public String getDisplayName(Context cx) {
        return this.field.scriptDisplayName(null, cx);
    }

    public Type getType() {
        return this.columnType;
    }

    @Override
    public BObject get(BObject target) {
        try {
            return BqlUtil.toBObject(this.field.scriptGet(target, this.cx));
        }
        catch (Exception e) {
            System.out.println("field name = " + this.field.scriptName());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public float getFloat(BObject target) {
        try {
            Object o = this.field.scriptGet(target, this.cx);
            if (o instanceof Float) {
                return ((Float)o).floatValue();
            }
            return ((BFloat)o).getFloat();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    @Override
    public double getDouble(BObject target) {
        try {
            Object o = this.field.scriptGet(target, this.cx);
            if (o instanceof Double) {
                return (Double)o;
            }
            return ((BDouble)o).getDouble();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    @Override
    public String getString(BObject target) {
        try {
            Object o = this.field.scriptGet(target, this.cx);
            if (o == null) {
                return "null";
            }
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof BString) {
                return ((BString)o).getString();
            }
            return o.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean getBoolean(BObject target) {
        try {
            Object o = this.field.scriptGet(target, this.cx);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return ((BBoolean)o).getBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int getInt(BObject target) {
        try {
            Object o = this.field.scriptGet(target, this.cx);
            if (o instanceof Integer) {
                return (Integer)o;
            }
            return ((BInteger)o).getInt();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public long getLong(BObject target) {
        try {
            Object o = this.field.scriptGet(target, this.cx);
            if (o instanceof Long) {
                return (Long)o;
            }
            return ((BLong)o).getLong();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    public int getFlags(BObject target) {
        return 0;
    }

    @Override
    public BFacets getFacets(BObject target) {
        return BFacets.NULL;
    }
}

