/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.collection;

import com.tridium.bql.collection.BqlRow;
import com.tridium.bql.collection.TypeColumnList;
import java.util.ArrayList;
import javax.baja.collection.AbstractTableCursor;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BObjectTable
extends BObject
implements BIRandomAccessTable<BIObject> {
    public static final Type TYPE = Sys.loadType(BObjectTable.class);
    private ColumnList columns;
    private final BITable<? extends BIObject> inner;
    private ArrayList<Row<? extends BIObject>> list;
    private Type baseType;

    public Type getType() {
        return TYPE;
    }

    public BObjectTable(ColumnList columns, BITable<? extends BIObject> inner) {
        this.columns = columns;
        this.inner = inner;
    }

    public BObjectTable(BITable<? extends BIObject> inner) {
        this(null, inner);
    }

    public TableCursor<BIObject> cursor() {
        return new ObjectTableCursor((BITable<BIObject>)this, (TableCursor<? extends BIObject>)this.inner.cursor());
    }

    public Row<BIObject> get(int row) {
        this.load();
        return new BqlRow<BIObject>((BITable<BIObject>)this, this.list.get(row).rowObject());
    }

    public int size() {
        this.load();
        return this.list.size();
    }

    public ColumnList getColumns() {
        if (this.columns == null) {
            this.load();
            this.columns = new TypeColumnList(this.baseType, null);
        }
        return this.columns;
    }

    public BFacets getTableFacets() {
        return BFacets.NULL;
    }

    private void load() {
        if (this.list != null) {
            return;
        }
        TableCursor c = this.inner.cursor();
        this.list = new ArrayList(16);
        this.baseType = null;
        while (c.next()) {
            BObject o = (BObject)c.get();
            this.updateType(o.getType());
            this.list.add((Row<? extends BIObject>)c.row());
        }
        if (this.baseType == null) {
            this.baseType = BObject.TYPE;
        }
    }

    private void updateType(Type newType) {
        if (this.baseType == null) {
            this.baseType = newType;
            return;
        }
        if (this.baseType == newType) {
            return;
        }
        while (this.baseType != BObject.TYPE && !newType.is(this.baseType)) {
            this.baseType = this.baseType.getSuperType();
        }
    }

    private static class ObjectTableCursor
    extends AbstractTableCursor<BIObject> {
        final TableCursor<?> inner;

        public ObjectTableCursor(BITable<BIObject> table, TableCursor<? extends BIObject> inner) {
            super(table);
            this.inner = inner;
        }

        public Context getContext() {
            return this.inner.getContext();
        }

        public boolean advanceCursor() {
            return this.inner.next();
        }

        public Row<BIObject> row() {
            return new BqlRow<BIObject>(this.getTable(), (BIObject)this.inner.get());
        }

        protected void closeCursor() {
            this.inner.close();
        }
    }
}

