/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.collection;

import com.tridium.bql.BSelect;
import com.tridium.bql.collection.BqlColumn;
import com.tridium.bql.collection.BqlRow;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.collection.AbstractTableCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.query.BProjectionColumn;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDistinctTable<T extends BIObject>
extends BObject
implements BITable<T> {
    public static final Type TYPE = Sys.loadType(BDistinctTable.class);
    protected final BITable<T> inner;
    protected final BSelect query;
    protected final Context cx;
    private final TableCursor<T> innerCursor;
    private ArrayList<T> distinctObjs = new ArrayList();
    private HashMap<BObject, HashMap> map = new HashMap(31);
    private BProjectionColumn[] projCols;
    private boolean finished;

    public Type getType() {
        return TYPE;
    }

    public BDistinctTable(BITable<T> inner, BSelect query, Context cx) {
        this.inner = inner;
        this.innerCursor = inner.cursor();
        this.query = query;
        this.projCols = query.getProjection().getProjectionColumns();
        this.cx = cx;
    }

    public BObject get(int index) {
        return (BObject)this.getDistinct(index);
    }

    public TableCursor<T> cursor() {
        return new DistinctCursor(this);
    }

    public ColumnList getColumns() {
        return this.inner.getColumns();
    }

    public BObject get(int row, Column column) {
        return ((BqlColumn)column).get((BObject)this.getDistinct(row));
    }

    public int getFlags(int row, Column column) {
        return ((BqlColumn)column).getFlags((BObject)this.getDistinct(row));
    }

    public BFacets getFacets(int row, Column column) {
        return ((BqlColumn)column).getFacets((BObject)this.getDistinct(row));
    }

    public BFacets getTableFacets() {
        return this.inner.getTableFacets();
    }

    private T getDistinct(int row) {
        if (row < this.distinctObjs.size()) {
            return (T)((BIObject)this.distinctObjs.get(row));
        }
        while (!this.finished && this.innerCursor.next()) {
            BIObject o = (BIObject)this.innerCursor.get();
            if (!this.isDistinct(o)) continue;
            this.distinctObjs.add(o);
            if (row >= this.distinctObjs.size()) continue;
            return (T)o;
        }
        this.finished = true;
        this.map = null;
        throw new IndexOutOfBoundsException("row = " + row);
    }

    private boolean isDistinct(T o) {
        HashMap currentMap = this.map;
        boolean isDistinct = false;
        for (int c = 0; c < this.projCols.length; ++c) {
            BObject colVal = this.query.getExprEngine().evaluate(this.projCols[c].getColumnExpression(), (BObject)o, this.cx);
            if (currentMap.containsKey(colVal)) {
                currentMap = currentMap.get(colVal);
                continue;
            }
            HashMap newMap = new HashMap(5);
            currentMap.put(colVal, newMap);
            currentMap = newMap;
            isDistinct = true;
        }
        return isDistinct;
    }

    class DistinctCursor
    extends AbstractTableCursor<T> {
        private int row;

        DistinctCursor(BDistinctTable<T> dt) {
            super(dt);
            this.row = -1;
        }

        public Context getContext() {
            return BDistinctTable.this.cx;
        }

        public boolean advanceCursor() {
            ++this.row;
            try {
                return BDistinctTable.this.getDistinct(this.row) != null;
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
        }

        public Row<T> row() {
            return new BqlRow<BIObject>(BDistinctTable.this, BDistinctTable.this.getDistinct(this.row));
        }
    }
}

