/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.RangeSetImpl;
import com.tridium.bql.SelectQuery;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.ExprUtil;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.expression.ExprEngine;
import javax.baja.bql.BqlQuery;
import javax.baja.query.BExpression;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BUnaryExpression;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Type;
import javax.baja.util.BAbsTimeRange;
import javax.baja.util.BTypeSpec;

public class RangeUtil
implements Constants {
    private BExpression expr;
    private ExprEngine engine;
    private ExprEngine.MorphUtil morpher;
    private String index;
    private Type prototype;
    private boolean equalityOnly = false;
    private int notDepth = 0;

    public RangeUtil(BExpression expr, ExprEngine engine, String index, Type prototype) {
        this.expr = expr;
        this.engine = engine;
        this.morpher = new ExprEngine.MorphUtil();
        this.index = index;
        this.prototype = prototype;
    }

    public RangeSet solveRange(boolean equalityOnly) {
        try {
            this.equalityOnly = equalityOnly;
            RangeSet range = this.solve(this.expr);
            range.sort();
            return range;
        }
        catch (CannotIndex x) {
            return Range.ALL;
        }
        catch (CannotSolve x) {
            return Range.ALL;
        }
    }

    protected RangeSet solve(BExpression current) {
        int opId = ExprUtil.getOpId(current);
        switch (opId) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.comparison((BBinaryExpression)current, opId);
            }
            case 13: {
                return this.solveAnd((BBinaryExpression)current);
            }
            case 14: {
                return this.solveOr((BBinaryExpression)current);
            }
            case 12: {
                return this.solveNot((BUnaryExpression)current);
            }
            case 15: {
                return this.containment((BBinaryExpression)current);
            }
            case 11: {
                throw new CannotIndex("like expressions cannot be indexed", current);
            }
        }
        throw new CannotSolve("opId: " + opId);
    }

    protected RangeSet comparison(BBinaryExpression current, int opId) {
        BExpression toEval = null;
        if (this.isProperty(current.lhs())) {
            toEval = current.rhs();
        } else if (this.isProperty(current.rhs())) {
            toEval = current.lhs();
            opId = this.reverseOperator(opId);
        } else {
            throw new CannotIndex("comparison not on index", (BExpression)current);
        }
        if (this.equalityOnly) {
            if (this.notDepth % 2 == 0 && opId != 5) {
                throw new CannotSolve("equality violated");
            }
            if (this.notDepth % 2 == 1 && opId != 6) {
                throw new CannotSolve("equality violated");
            }
        }
        if (!Comparable.class.isAssignableFrom(this.prototype.getTypeClass()) && opId != 5 && opId != 6) {
            throw new IllegalArgumentException("Range evaluation can only be performed on Comparable objects");
        }
        BSimple val = this.eval(toEval);
        if (opId == 5) {
            return new Range(val);
        }
        if (opId == 6) {
            return new Range(val).not();
        }
        if (opId == 7 || opId == 8) {
            return new Range(val, opId == 8, null, false);
        }
        if (opId == 9 || opId == 10) {
            return new Range(null, false, val, opId == 10);
        }
        throw new IllegalArgumentException("Cannot create range from operator id: " + opId);
    }

    protected RangeSet solveAnd(BBinaryExpression expr) {
        RangeSet leftRange = null;
        RangeSet rightRange = null;
        try {
            leftRange = this.solve(expr.lhs());
        }
        catch (CannotIndex cannotIndex) {
            // empty catch block
        }
        try {
            rightRange = this.solve(expr.rhs());
        }
        catch (CannotIndex cannotIndex) {
            // empty catch block
        }
        if (leftRange == null && rightRange == null) {
            throw new CannotIndex("<not index> AND <not index>", (BExpression)expr);
        }
        if (leftRange == null) {
            return rightRange;
        }
        if (rightRange == null) {
            return leftRange;
        }
        return RangeSetImpl.crossProduct(leftRange, rightRange);
    }

    protected RangeSet solveOr(BBinaryExpression expr) {
        RangeSet leftRange = this.solve(expr.lhs());
        RangeSet rightRange = this.solve(expr.rhs());
        return new RangeSetImpl(leftRange, rightRange).union();
    }

    protected RangeSet solveNot(BUnaryExpression expr) {
        ++this.notDepth;
        try {
            if (expr.operand() instanceof BPath && !this.isProperty(expr.operand())) {
                throw new CannotIndex("unary on non-indexed property");
            }
            RangeSet rangeSet = this.solve(expr.operand()).not().union();
            return rangeSet;
        }
        catch (CannotIndex e) {
            throw e;
        }
        finally {
            --this.notDepth;
        }
    }

    protected RangeSet containment(BBinaryExpression expr) {
        if (!this.isProperty(expr.lhs())) {
            throw new CannotIndex("", (BExpression)expr);
        }
        try {
            if (this.prototype.equals(BAbsTime.TYPE)) {
                if (this.equalityOnly) {
                    throw new CannotSolve("equality only with BAbsTimeRange");
                }
                BObject val = this.engine.evaluate(expr.rhs(), null, null);
                if (val instanceof BAbsTimeRange) {
                    BAbsTimeRange range = (BAbsTimeRange)val;
                    return new Range((BSimple)range.getStartTime(), true, (BSimple)range.getEndTime(), true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new CannotIndex("", (BExpression)expr);
    }

    protected BSimple eval(BExpression toEval) {
        try {
            BObject result = this.engine.evaluate(toEval, null, null);
            if (!result.getType().is(this.prototype)) {
                ExprEngine.MorphUtil.MorphedTuple tuple = this.morpher.morph(this.prototype.getInstance(), result);
                result = tuple.rhs;
                if (!result.getType().is(this.prototype)) {
                    throw new CannotIndex("evaluated to non-prototype '" + result.getTypeDisplayName(null) + "'");
                }
            }
            return result.asSimple();
        }
        catch (CannotIndex e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CannotIndex("failed to evaluate", toEval);
        }
    }

    protected boolean isProperty(BExpression ex) {
        BPath path;
        return ex instanceof BPath && (path = (BPath)ex).getPath().getName().equals(this.index);
    }

    protected int reverseOperator(int opId) {
        switch (opId) {
            case 7: {
                return 9;
            }
            case 9: {
                return 7;
            }
            case 8: {
                return 10;
            }
            case 10: {
                return 8;
            }
            case 5: 
            case 6: {
                return opId;
            }
        }
        throw new IllegalStateException();
    }

    public static void main(String[] args) {
        Type p = BTypeSpec.make((String)args[0]).getResolvedType();
        boolean equalityOnly = Boolean.valueOf(args[1]);
        SelectQuery select = (SelectQuery)BqlQuery.make("select * where " + args[2]);
        RangeSet range = select.getRange("x", p, equalityOnly);
        System.out.println("Prototype: " + p);
        System.out.println("Query: " + select);
        System.out.println("Range: " + range);
    }

    private class CannotSolve
    extends RuntimeException {
        public CannotSolve(String message) {
            super(message);
        }
    }

    private class CannotIndex
    extends RuntimeException {
        public CannotIndex(String message, BExpression expr) {
            this(message + ": " + ExprUtil.toExprStr(expr));
        }

        public CannotIndex(String message) {
            super(message);
        }
    }
}

