/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.util.FormatDenylist;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.sys.Type;

public class FunctionUtil {
    private static final HashMap<Boolean, HashMap<Class<?>, HashMap<String, ArrayList<Method>>>> classToMethodMap;
    private static final HashMap<Class<?>, HashMap<String, Field>> fieldMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFunctions(Class<?> cls, boolean staticOnly) {
        HashMap<Boolean, HashMap<Class<?>, HashMap<String, ArrayList<Method>>>> hashMap = classToMethodMap;
        synchronized (hashMap) {
            HashMap<Class<?>, HashMap<String, ArrayList<Method>>> classMap = classToMethodMap.get(staticOnly);
            HashMap<String, ArrayList<Method>> methodMap = classMap.get(cls);
            if (methodMap == null) {
                Method[] methods;
                methodMap = new HashMap();
                for (Method method : methods = cls.getMethods()) {
                    String methodName = method.getName();
                    if ((method.getModifiers() & 8) == 0 && staticOnly || (method.getModifiers() & 8) != 0 && !staticOnly || FormatDenylist.isDenied(cls, (String)methodName, (Class[])method.getParameterTypes())) continue;
                    ArrayList methodList = methodMap.computeIfAbsent(methodName, k -> new ArrayList());
                    methodList.add(method);
                }
                classMap.put(cls, methodMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getFunction(Class<?> cls, String methodName, Class<?>[] actualParams, boolean staticOnly) {
        HashMap<String, ArrayList<Method>> methodMap;
        FunctionUtil.loadFunctions(cls, staticOnly);
        HashMap<Boolean, HashMap<Class<?>, HashMap<String, ArrayList<Method>>>> hashMap = classToMethodMap;
        synchronized (hashMap) {
            HashMap<Class<?>, HashMap<String, ArrayList<Method>>> classMap = classToMethodMap.get(staticOnly);
            methodMap = classMap.get(cls);
        }
        if (methodMap == null) {
            return null;
        }
        ArrayList<Method> list = methodMap.get(methodName);
        if (list == null) {
            return null;
        }
        for (Method method : list) {
            Class<?>[] formalParams = method.getParameterTypes();
            if (formalParams.length != actualParams.length) continue;
            for (int j = 0; j < formalParams.length; ++j) {
                if (formalParams[j].isAssignableFrom(actualParams[j])) continue;
                method = null;
                break;
            }
            if (method == null) continue;
            return method;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field getAggregateDef(Class<?> cls, String fieldName) {
        HashMap<String, Field> clsFieldMap;
        FunctionUtil.loadFields(cls);
        HashMap<Class<?>, HashMap<String, Field>> hashMap = fieldMap;
        synchronized (hashMap) {
            clsFieldMap = fieldMap.get(cls);
        }
        if (clsFieldMap == null) {
            return null;
        }
        return clsFieldMap.get(fieldName.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFields(Class<?> cls) {
        HashMap<Class<?>, HashMap<String, Field>> hashMap = fieldMap;
        synchronized (hashMap) {
            HashMap<String, Field> clsFieldMap = fieldMap.get(cls);
            if (clsFieldMap == null) {
                Field[] fields;
                clsFieldMap = new HashMap();
                for (Field field : fields = cls.getFields()) {
                    if ((field.getModifiers() & 8) == 0 || (field.getModifiers() & 0x10) == 0 || (field.getModifiers() & 1) == 0 || !field.getType().isArray() || !field.getType().getComponentType().equals(Type.class)) continue;
                    String fieldName = field.getName().toLowerCase();
                    clsFieldMap.put(fieldName, field);
                }
                fieldMap.put(cls, clsFieldMap);
            }
        }
    }

    static {
        fieldMap = new HashMap();
        classToMethodMap = new HashMap();
        classToMethodMap.put(Boolean.TRUE, new HashMap());
        classToMethodMap.put(Boolean.FALSE, new HashMap());
    }
}

