/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import com.tridium.util.CompUtil;
import java.util.Collection;
import java.util.Optional;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelation;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tagdictionary.BRelationInfo;

@NiagaraType
public class BEquipRelation
extends BRelationInfo {
    public static final Type TYPE = Sys.loadType(BEquipRelation.class);
    static final Id ID_EQUIP = Id.newId((String)"hs", (String)"equip");
    static final Id ID_EQUIP_REF = Id.newId((String)"hs", (String)"equipRef");

    public Type getType() {
        return TYPE;
    }

    public Optional<Relation> getRelation(Entity source) {
        if (!(source instanceof BControlPoint) || BEquipRelation.hasDirectRelation((BComponent)source, ID_EQUIP_REF)) {
            return Optional.empty();
        }
        BComponent equip = BEquipRelation.getImpliedEquip((BControlPoint)source);
        if (equip != null) {
            return Optional.of(new BasicRelation(ID_EQUIP_REF, (Entity)equip, false));
        }
        return Optional.empty();
    }

    public void addRelations(Entity source, Collection<Relation> relations) {
        Optional<Relation> outbound = this.getRelation(source);
        if (outbound.isPresent()) {
            relations.add(outbound.get());
        }
        if (!(source instanceof BComponent) || !source.tags().contains(ID_EQUIP)) {
            return;
        }
        for (BControlPoint childPoint : (BControlPoint[])CompUtil.getDescendants((BComponent)((BComponent)source), BControlPoint.class)) {
            if (BEquipRelation.hasDirectRelation((BComponent)childPoint, ID_EQUIP_REF) || BEquipRelation.getImpliedEquip(childPoint) != source) continue;
            relations.add((Relation)new BasicRelation(ID_EQUIP_REF, (Entity)childPoint, true));
        }
    }

    static BComponent getEquip(BControlPoint point) {
        BRelation equipRelation = BEquipRelation.getDirectRelation((BComponent)point, ID_EQUIP_REF);
        if (equipRelation != null) {
            return (BComponent)equipRelation.getEndpoint();
        }
        return BEquipRelation.getImpliedEquip(point);
    }

    private static BComponent getImpliedEquip(BControlPoint point) {
        if (point.getProxyExt() instanceof BNullProxyExt) {
            return null;
        }
        for (BComplex parent = point.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.asComponent().tags().contains(ID_EQUIP)) continue;
            return parent.asComponent();
        }
        return null;
    }

    static BRelation getDirectRelation(BComponent component, Id id) {
        for (BRelation relation : component.getComponentRelations()) {
            if (!relation.getId().equals((Object)id)) continue;
            return relation;
        }
        return null;
    }

    static boolean hasDirectRelation(BComponent component, Id id) {
        return BEquipRelation.getDirectRelation(component, id) != null;
    }
}

