/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.schema.ui;

import com.tridium.seriestransform.graph.ui.BConfigItem;
import com.tridium.seriestransform.graph.ui.BSchemaConfigEditor;
import com.tridium.seriestransform.schema.ui.BSchemaElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.history.BHistoryRecord;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public class BNodeSchemaEditor
extends BSchemaConfigEditor {
    public static final Type TYPE = Sys.loadType(BNodeSchemaEditor.class);
    private static final Lexicon lex = Lexicon.make(BNodeSchemaEditor.class);
    private static final String TITLE = "nodeschemeeditor.title";
    private static final String DISPLAY_TITLE = lex.getText("outputSchemaEditor.schema");
    private static final Command[] EMPTY_COMMANDS = new Command[0];
    private final Set<String> fieldNames = new HashSet<String>();
    private boolean keyPresent;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BSeriesSchema open(BWidget owner, BSeriesSchema schema) {
        if (null == schema) {
            schema = new BSeriesSchema();
        }
        BNodeSchemaEditor editor = new BNodeSchemaEditor(schema);
        int result = BRoundedDialog.open((BWidget)owner, (String)lex.getText(TITLE), (Object)((Object)editor), (int)3);
        if (result == 2) {
            return null;
        }
        return editor.getSchema();
    }

    public BNodeSchemaEditor() {
        this(new BSeriesSchema());
    }

    public BNodeSchemaEditor(BSeriesSchema schema) {
        BWidget schemaEditor = this.buildTableDisplay(DISPLAY_TITLE, new Command[]{new AddElementCmd((BWidget)this)});
        this.setCenter(schemaEditor);
        this.loadSchema(schema);
    }

    private void loadSchema(BSeriesSchema schema) {
        String[] fieldNames;
        String keyField = schema.getKeyField();
        if (null == keyField && null != schema.getFieldType(BHistoryRecord.timestamp.getName())) {
            keyField = BHistoryRecord.timestamp.getName();
        }
        BFacets keyFacets = schema.getFieldFacets(keyField);
        BTypeSpec keyType = schema.getFieldType(keyField);
        if (null != keyType) {
            BSchemaElement keyElement = this.makeElementConfig(keyField, keyType, keyFacets);
            keyElement.setEnabled(false);
            this.addConfig(keyElement, EMPTY_COMMANDS);
            this.keyPresent = true;
        }
        for (String fieldName : fieldNames = schema.getFieldNames()) {
            BTypeSpec fieldType = schema.getFieldType(fieldName);
            BFacets fieldFacets = schema.getFieldFacets(fieldName);
            BSchemaElement slice = this.makeElementConfig(fieldName, fieldType, fieldFacets);
            this.addElementConfig(slice);
        }
    }

    public BSeriesSchema getSchema() {
        BSeriesSchema schema = new BSeriesSchema();
        for (BConfigItem row : this.rows) {
            BSchemaElement element = (BSchemaElement)row;
            String fieldName = element.getElementName();
            BTypeSpec spec = element.getTypeSpec();
            BFacets fieldFacets = BFacets.NULL;
            try {
                fieldFacets = element.getFieldFacets();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (schema.hasField(fieldName)) continue;
            schema.addField(fieldName, spec, fieldFacets);
        }
        return schema;
    }

    private BSchemaElement makeElementConfig(String elementName, BTypeSpec spec, BFacets facets) {
        BSchemaElement field;
        if (null == elementName) {
            elementName = "";
        }
        if (!elementName.isEmpty() && this.fieldNames.contains(elementName)) {
            return null;
        }
        if (null == spec) {
            field = new BSchemaElement();
        } else {
            String moduleName = spec.getModuleName();
            String typeName = spec.getTypeName();
            field = new BSchemaElement(moduleName, typeName, elementName, facets);
        }
        this.rows.add(field);
        this.fieldNames.add(elementName);
        return field;
    }

    private void addElementConfig(BSchemaElement field) {
        Command[] commands;
        if (field == null) {
            return;
        }
        RemoveElementCmd remove = new RemoveElementCmd((BWidget)this, (BWidget)field);
        if (!this.keyPresent) {
            SetKeyCmd setKey = new SetKeyCmd((BWidget)this, field);
            commands = new Command[]{setKey, remove};
        } else {
            commands = new Command[]{remove};
        }
        this.addConfig(field, commands);
    }

    private class SetKeyCmd
    extends Command {
        private final BSchemaElement elem;

        public SetKeyCmd(BWidget owner, BSchemaElement elem) {
            super(owner, "");
            this.elem = elem;
        }

        public BImage getIcon() {
            return keyIcon;
        }

        public CommandArtifact doInvoke() throws Exception {
            BFacets fieldFacets = this.elem.getFieldFacets();
            BFacets key = BFacets.make((String)"primaryKeyField", (boolean)true);
            fieldFacets = BFacets.make((BFacets)fieldFacets, (BFacets)key);
            this.elem.setFieldFacets(fieldFacets);
            for (BConfigItem row : BNodeSchemaEditor.this.rows) {
                BFacets configFacets;
                BSchemaElement config = (BSchemaElement)row;
                if (config.equals((Object)this.elem) || null == (configFacets = config.getFieldFacets()).get("primaryKeyField")) continue;
                String[] list = configFacets.list();
                HashMap<String, BIDataValue> facetMap = new HashMap<String, BIDataValue>();
                for (String facetKey : list) {
                    BObject bObject;
                    if (facetKey.equals("primaryKeyField") || !((bObject = configFacets.get(facetKey)) instanceof BIDataValue)) continue;
                    facetMap.put(facetKey, (BIDataValue)bObject);
                }
                BFacets newFacets = BFacets.make(facetMap);
                config.setFieldFacets(newFacets);
            }
            return null;
        }
    }

    private class RemoveElementCmd
    extends Command {
        BWidget elem;

        public RemoveElementCmd(BWidget owner, BWidget elem) {
            super(owner, "");
            this.elem = elem;
        }

        public BImage getIcon() {
            return minusIcon;
        }

        public CommandArtifact doInvoke() {
            BNodeSchemaEditor.this.rows.remove(this.elem);
            BNodeSchemaEditor.this.removeConfig(this.elem);
            BNodeSchemaEditor.this.validateConfig();
            return null;
        }
    }

    private class AddElementCmd
    extends Command {
        public AddElementCmd(BWidget owner) {
            super(owner, "");
        }

        public BImage getIcon() {
            return addIcon;
        }

        public CommandArtifact doInvoke() {
            BNodeSchemaEditor.this.addElementConfig(BNodeSchemaEditor.this.makeElementConfig(null, null, null));
            BNodeSchemaEditor.this.resize();
            return null;
        }
    }
}

