/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.px.editor.make;

import com.tridium.data.BDataTable;
import com.tridium.px.editor.make.BMwBoundLabel;
import com.tridium.px.editor.make.BMwConfig;
import com.tridium.px.editor.make.BMwWorkbenchView;
import com.tridium.px.editor.make.WidgetCopier;
import com.tridium.seriestransform.graph.BTransformGraph;
import com.tridium.util.ClassUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:TransformGraph"})})
public class BMwTransformWbView
extends BMwWorkbenchView {
    public static final Type TYPE = Sys.loadType(BMwTransformWbView.class);

    public Type getType() {
        return TYPE;
    }

    public BTypeSpec getSuperceedingType() {
        return BMwWorkbenchView.TYPE.getTypeSpec();
    }

    public void load() {
        Object[] objects = this.mw.getDrawingObjects();
        if (ClassUtil.anyNull((Object[])objects)) {
            this.command.setEnabled(false);
        } else {
            this.command.setEnabled(true);
            try {
                HashSet<AgentInfo> agentInfos = new HashSet<AgentInfo>();
                for (Object object : objects) {
                    agentInfos.addAll(BMwTransformWbView.getAgents((BObject)object));
                }
                this.viewAgents = agentInfos.toArray(new AgentInfo[agentInfos.size()]);
                this.view.removeAllItems();
                for (AgentInfo viewAgent : this.viewAgents) {
                    this.view.addItem((Object)viewAgent.getDisplayName(null));
                }
                if (this.viewAgents.length == 0) {
                    BMwConfig config;
                    this.command.setEnabled(false);
                    if (this.command.isSelected() && null != (config = this.mw.getConfig(BMwBoundLabel.TYPE))) {
                        config.getCommand().setSelected(true);
                    }
                } else {
                    this.view.setSelectedIndex(0);
                }
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }

    private static List<AgentInfo> getAgents(BObject obj) {
        if (obj instanceof BTransformGraph) {
            obj = new BDataTable();
        }
        return Arrays.asList(obj.getAgents().filter(AgentFilter.is((Type)BWbView.TYPE)).list()).stream().filter(agentInfo -> !"pxEditor".equals(agentInfo.getAgentType().getModuleName())).collect(Collectors.toList());
    }

    public BWidget[] makePxWidgets(WidgetCopier wc) {
        BWidget[] createdWidgets;
        for (BWidget widget : createdWidgets = super.makePxWidgets(wc)) {
            BBinding[] bindings = widget.getBindings();
            if (bindings.length <= 0) continue;
            BBinding binding = bindings[0];
            BOrd targetOrd = bindings[0].getOrd();
            targetOrd = BOrd.make((BOrd)targetOrd, (String)"transform:");
            binding.setOrd(targetOrd);
        }
        return createdWidgets;
    }
}

