/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.interval.ui;

import com.tridium.seriestransform.interval.BSeriesInterval;
import com.tridium.seriestransform.interval.BSeriesIntervalEnum;
import com.tridium.workbench.fieldeditors.BRelTimeFE;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:SeriesInterval"})})
@NiagaraAction(name="updateDisplay")
public class BSeriesIntervalFE
extends BWbFieldEditor {
    public static final Action updateDisplay = BSeriesIntervalFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSeriesIntervalFE.class);
    private static final String PROP_TIMEFE = "timeFE";
    private static final String PROP_SELECTOR = "selector";
    private final BGridPane display;
    private final BRelTimeFE timeFE = new BRelTimeFE();
    private final BListDropDown enumSelector = new BListDropDown();

    public void updateDisplay() {
        this.invoke(updateDisplay, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSeriesIntervalFE() {
        int[] ordinals;
        BEnumRange range = BSeriesIntervalEnum.auto.getRange();
        for (int ordinal : ordinals = range.getOrdinals()) {
            String tag = range.getDisplayTag(ordinal, null);
            this.enumSelector.getList().addItem((Object)new IntervalItem(tag, BSeriesIntervalEnum.make((int)ordinal)));
        }
        this.linkTo((BComponent)this.enumSelector, (Slot)BDropDown.valueModified, (Slot)updateDisplay);
        this.linkTo((BComponent)this.enumSelector, (Slot)BDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.timeFE, (Slot)BWbPlugin.setModified, (Slot)setModified);
        this.display = new BGridPane(2);
        this.display.add(PROP_SELECTOR, (BValue)this.enumSelector);
        this.display.add(PROP_TIMEFE, (BValue)new BNullWidget());
        this.setContent((BWidget)this.display);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        BSeriesInterval interval = (BSeriesInterval)value;
        BPermissions permissions = interval.getPermissions(context);
        this.setReadonly(!permissions.hasOperatorWrite());
        BRelTime relTime = interval.getTime();
        BSeriesIntervalEnum intervalEnum = interval.getDesc();
        BFacets facets = BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1));
        this.timeFE.loadValue((BObject)relTime, (Context)facets);
        this.setSelectorValue(intervalEnum);
    }

    private void setSelectorValue(BSeriesIntervalEnum intervalEnum) {
        int itemCount = this.enumSelector.getList().getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            IntervalItem item = (IntervalItem)this.enumSelector.getList().getItem(i);
            BSeriesIntervalEnum interval = item.getSeriesInterval();
            if (interval.getOrdinal() != intervalEnum.getOrdinal()) continue;
            this.enumSelector.setSelectedIndex(i);
            break;
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BSeriesInterval interval = (BSeriesInterval)value;
        interval.lease();
        IntervalItem item = (IntervalItem)this.enumSelector.getSelectedItem();
        interval.setDesc(item.getSeriesInterval());
        interval.setTime((BRelTime)this.timeFE.saveValue());
        return interval;
    }

    protected void doSetReadonly(boolean readonly) {
        this.timeFE.setEnabled(!readonly);
        this.enumSelector.setEnabled(!readonly);
    }

    public void doUpdateDisplay() {
        IntervalItem item = (IntervalItem)this.enumSelector.getSelectedItem();
        BSeriesIntervalEnum intervalEnum = item.getSeriesInterval();
        if (intervalEnum == BSeriesIntervalEnum.custom) {
            this.display.set(PROP_TIMEFE, (BValue)this.timeFE);
        } else {
            this.display.set(PROP_TIMEFE, (BValue)new BNullWidget());
        }
        this.repaint();
    }

    static class IntervalItem {
        private final String label;
        private final BSeriesIntervalEnum interval;

        public IntervalItem(String label, BSeriesIntervalEnum interval) {
            this.label = label;
            this.interval = interval;
        }

        public String toString() {
            return this.label;
        }

        public String getLabel() {
            return this.label;
        }

        public BSeriesIntervalEnum getTimeInterval() {
            return this.interval;
        }

        public BSeriesIntervalEnum getSeriesInterval() {
            return this.interval;
        }
    }
}

