/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.graph.ui;

import com.tridium.seriestransform.BTransformQuery;
import com.tridium.seriestransform.NQueryParameters;
import com.tridium.seriestransform.graph.BTransformGraph;
import com.tridium.seriestransform.graph.ParameterSlot;
import com.tridium.seriestransform.graph.ui.BGraphOrdFE;
import com.tridium.workbench.celleditors.BStringCE;
import com.tridium.workbench.celltable.BAbstractCellTable;
import com.tridium.workbench.celltable.BLabeledCellTable;
import com.tridium.workbench.fieldeditors.BOrdFE;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSlotScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.celleditor.BWbCellEditor;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:TransformQuery"})})
@NiagaraAction(name="updateQueryTable")
public class BTransformQueryEditor
extends BWbEditor {
    public static final Action updateQueryTable = BTransformQueryEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BTransformQueryEditor.class);
    private static final Lexicon lex = Lexicon.make(BTransformQueryEditor.class);
    private static final String COL_PARAM_VAL = lex.getText("transformParams.editor.colName");
    private static final String LBL_GRAPH_ORD = lex.getText("transformParams.editor.lblGraphOrd");
    private static final String LBL_PARAM_TBL = lex.getText("transformParams.editor.lblParamTbl");
    private static final String TITLE = lex.getText("transformParams.editor.title");
    private static final Logger log = Logger.getLogger("seriesTransform");
    private final BGraphOrdFE graphOrdFE = new BGraphOrdFE();
    private BTransformQuery query;
    private BLabeledCellTable paramTable;
    private final Map<String, BWbCellEditor> paramValueMap = new HashMap<String, BWbCellEditor>();
    private BWidget owner;
    private BOrd base;

    public void updateQueryTable() {
        this.invoke(updateQueryTable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BTransformQuery open(BWidget owner, BOrd base, BTransformQuery query, Context cx) throws Exception {
        if (null == query) {
            query = new BTransformQuery();
        }
        BTransformQueryEditor editor = new BTransformQueryEditor(owner, base);
        editor.loadValue((BObject)query, cx);
        int result = BDialog.open((BWidget)owner, (String)TITLE, (Object)((Object)editor), (int)3);
        if (result != 1) {
            return null;
        }
        query = (BTransformQuery)editor.saveValue();
        return query;
    }

    public BTransformQueryEditor() {
    }

    public BTransformQueryEditor(BWidget owner) {
        this(owner, null);
    }

    public BTransformQueryEditor(BWidget owner, BOrd base) {
        this.owner = owner;
        this.base = base;
        this.buildUI();
    }

    private void buildUI() {
        String[] colNames = new String[]{COL_PARAM_VAL};
        this.paramTable = new BLabeledCellTable(colNames);
        this.graphOrdFE.setOrdFieldLength(45);
        BScrollPane scroll = new BScrollPane((BWidget)this.paramTable);
        scroll.setVpolicy(BScrollBarPolicy.asNeeded);
        scroll.setHpolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane cp = new BConstrainedPane((BWidget)scroll);
        cp.setMinHeight(100.0);
        cp.setMaxHeight(150.0);
        cp.setMinWidth(300.0);
        BGridPane content = new BGridPane(2);
        content.setRowGap(10.0);
        content.setColumnGap(10.0);
        content.add(null, (BValue)new BLabel(LBL_GRAPH_ORD));
        content.add(null, (BValue)this.graphOrdFE);
        content.add(null, (BValue)new BLabel(LBL_PARAM_TBL));
        content.add(null, (BValue)cp);
        this.linkTo((BComponent)this.paramTable, (Slot)BAbstractCellTable.modified, (Slot)setModified);
        this.linkTo((BComponent)this.graphOrdFE, (Slot)BOrdFE.textModified, (Slot)updateQueryTable);
        this.linkTo((BComponent)this.graphOrdFE, (Slot)BOrdFE.textModified, (Slot)setModified);
        this.setContent((BWidget)content);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.query = (BTransformQuery)value;
        BOrd graphOrd = this.query.getGraphOrd();
        this.graphOrdFE.loadValue((BObject)graphOrd);
        BTransformGraph graph = this.resolveGraphOrd(graphOrd);
        if (null != graph) {
            NQueryParameters parameterMap = this.query.decodeQueryParameters(graph);
            this.populateParameterTable(graphOrd, parameterMap);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BOrd graphOrd = (BOrd)this.graphOrdFE.saveValue();
        BTransformGraph graph = this.resolveGraphOrd(graphOrd);
        graph.lease(3);
        SlotPath graphSlotPath = graph.getSlotPath();
        Set<String> slotPaths = this.paramValueMap.keySet();
        this.query.lease();
        this.query.setGraphOrd(BOrd.make((OrdQuery)graphSlotPath));
        for (String slotPath : slotPaths) {
            BWbCellEditor ce = this.paramValueMap.get(slotPath);
            BValue v = (BValue)ce.saveValue();
            SlotPath sp = new SlotPath(slotPath);
            String strOrd = graph.getSlotPath().toString();
            if (sp.toString().startsWith(strOrd)) {
                slotPath = sp.toString().substring(strOrd.length());
            }
            BOrd slotPathOrd = BOrd.make((OrdQuery)sp);
            String[] split = TextUtil.split((String)slotPath, (char)'/');
            graph.lease(split.length);
            BValue currentValue = (BValue)slotPathOrd.get((BObject)graph);
            if (null == currentValue || currentValue.equals((Object)v)) continue;
            this.query.encodeParameter(sp, v);
        }
        return this.query;
    }

    private void populateParameterTable(BOrd graphOrd, NQueryParameters definedParams) {
        if (null == graphOrd || graphOrd == BOrd.NULL) {
            this.clearParamTable();
        } else {
            BTransformGraph graph = this.resolveGraphOrd(graphOrd);
            if (null != graph) {
                this.buildParamTable(graph, definedParams);
            }
        }
    }

    private void buildParamTable(BTransformGraph graph, NQueryParameters parameterMap) {
        ParameterSlot[] parameterSlots;
        graph.lease(3);
        String graphSlotPath = graph.getSlotPath().toString();
        graphSlotPath = graphSlotPath.substring(BSlotScheme.INSTANCE.getId().length() + 1);
        for (ParameterSlot param : parameterSlots = graph.getParameterSlots()) {
            SlotPath path = param.getSlotPath();
            SlotPath parent = path.getParent();
            String[] pathNames = path.getNames();
            String property = pathNames[pathNames.length - 1];
            BOrd paramOrd = BOrd.make((BOrd)graph.getAbsoluteOrd(), (OrdQuery)parent);
            BObject object = paramOrd.get((BObject)graph);
            if (!(object instanceof BComponent)) continue;
            BComponent complex = (BComponent)object;
            complex.lease();
            Property p = complex.getProperty(property);
            BValue defaultValue = complex.get(p);
            BWbCellEditor ce = BWbCellEditor.makeFor((BObject)defaultValue, (Context)this.getCurrentContext());
            BValue v = parameterMap.get(path);
            if (null != v && v.getType().is(defaultValue.getType())) {
                defaultValue = v;
            }
            ce.loadValue((BObject)defaultValue, this.getCurrentContext());
            String displayString = path.toDisplayString();
            displayString = displayString.substring(graphSlotPath.length() + 1);
            this.paramTable.addRow(displayString, new BWbCellEditor[]{ce});
            this.paramValueMap.put(path.getBody(), ce);
        }
        if (this.paramTable.getRowCount() == 0) {
            this.paramTable.addRow("<params>", new BWbCellEditor[]{new BStringCE()});
            this.paramTable.setEnabled(false);
        }
        this.paramTable.getModel().updateTable();
        this.paramTable.relayout();
        this.repaint();
    }

    private void clearParamTable() {
        this.paramTable.clearRows();
        this.paramTable.addRow("<params>", new BWbCellEditor[]{new BStringCE()});
        this.paramTable.setEnabled(false);
        this.paramTable.getModel().updateTable();
        this.paramTable.relayout();
        this.repaint();
    }

    private BTransformGraph resolveGraphOrd(BOrd graphOrd) {
        if (null == this.base) {
            BWbShell wbShell = BWbShell.getWbShell((BWidget)this.owner);
            if (null == wbShell) {
                return null;
            }
            BOrd activeOrd = wbShell.getActiveOrd();
            if (null == activeOrd || activeOrd == BOrd.NULL) {
                return null;
            }
            OrdQuery[] queries = activeOrd.parse();
            OrdQueryList myQueries = new OrdQueryList(queries);
            myQueries.shiftToSession(myQueries.size());
            this.base = BOrd.make((OrdQuery[])myQueries.toArray());
        }
        if (null != graphOrd && graphOrd != BOrd.NULL) {
            graphOrd = BOrd.make((String)("station:|" + graphOrd.encodeToString()));
            BObject bObject = (graphOrd = BOrd.make((BOrd)this.base, (BOrd)graphOrd)).get();
            if (!(bObject instanceof BTransformGraph)) {
                return null;
            }
            BTransformGraph graph = (BTransformGraph)bObject;
            return graph;
        }
        return null;
    }

    public void doUpdateQueryTable() {
        try {
            String text = this.graphOrdFE.getTextField().getText();
            BOrd graphOrd = BOrd.make((String)text);
            BTransformGraph graph = this.resolveGraphOrd(graphOrd);
            if (null != graph) {
                NQueryParameters parameterMap = this.query.decodeQueryParameters(graph);
                this.paramTable.clearRows();
                this.populateParameterTable(graphOrd, parameterMap);
            }
        }
        catch (Exception e) {
            log.severe("Transform Query Editor failed to process transform query parameters for graph ORD: " + this.graphOrdFE.getTextField().getText());
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

