/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.graph.ui;

import com.tridium.history.ui.BHistoryOrdChooser;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.BTextEditorOptions;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.TextRenderer;
import javax.baja.util.BFormat;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.ord.BIOrdChooser;

@NiagaraType
public class BFormatOrdFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BFormatOrdFE.class);
    private static final BImage browseIcon = BImage.make((String)"module://icons/x16/open.png");
    private final BTextField field = new BTextField("", 30);
    private final Browse defaultBrowse;
    private final BButton button;
    private final BMenu menu;
    private BWbShell shell;

    public Type getType() {
        return TYPE;
    }

    public BFormatOrdFE() {
        this.field.setRenderer((TextRenderer)new Renderer());
        this.field.setParser((TextParser)new Parser());
        this.menu = new BMenu();
        this.defaultBrowse = new Browse(BHistoryOrdChooser.TYPE.getTypeInfo(), true);
        this.menu.add(null, (Command)new Browse(BHistoryOrdChooser.TYPE.getTypeInfo(), false));
        this.button = new BButton((Command)this.defaultBrowse);
        this.button.setMenuController((BAbstractButton.MenuController)new MenuController());
        this.button.setButtonStyle(BButtonStyle.toolBar);
        if (this.button != null) {
            this.button.setVisible(this.menu.getMenuItems().length > 0);
        }
        BGridPane grid = new BGridPane(2);
        grid.setStretchColumn(0);
        grid.add(null, (BValue)this.field);
        grid.add(null, (BValue)this.button);
        this.setContent((BWidget)grid);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    public void started() throws Exception {
        this.shell = this.getWbShell();
    }

    protected void doSetReadonly(boolean readonly) {
        this.field.setEditable(!readonly);
        this.button.setEnabled(!readonly);
    }

    protected void doLoadValue(BObject v, Context cx) {
        BFormat format = (BFormat)v;
        this.field.setText(format.getFormat());
    }

    protected BObject doSaveValue(BObject v, Context cx) throws Exception {
        return BFormat.make((String)this.field.getText());
    }

    public boolean isRelativize(BOrd currentOrd) {
        return BFormatOrdFE.isRelativize(currentOrd, this.getCurrentContext(), this.shell);
    }

    public static boolean isRelativize(BOrd currentOrd, Context cx, BWbShell shell) {
        BObject val;
        BFacets facets;
        if (cx != null && (facets = cx.getFacets()) != null && (val = facets.get("ordRelativize")) instanceof BBoolean) {
            return ((BBoolean)val).getBoolean();
        }
        if (shell != null) {
            BOrd activeOrd = shell.getActiveOrd();
            OrdQuery[] active = activeOrd.parse();
            OrdQuery[] current = currentOrd.parse();
            if (active.length > 1 && current.length > 1) {
                if (!active[0].toString().equals(current[0].toString())) {
                    return false;
                }
                if (!active[1].toString().equals(current[1].toString())) {
                    return false;
                }
            }
        }
        return true;
    }

    private static class Parser
    extends TextParser {
        private Parser() {
        }

        protected Segment nextSegment() {
            Segment whitespace = this.parseWhitespace();
            if (whitespace != null) {
                return whitespace;
            }
            if (this.current == 37 && (this.next != 37 || this.next == -1)) {
                while (this.advance()) {
                    if (this.current != 37) continue;
                    this.advance();
                    return this.newSegment(6);
                }
                return this.newSegment(6);
            }
            while (this.advance()) {
                if (this.current != 37 || this.next == 37 && this.next != -1) continue;
                return this.newSegment(0);
            }
            return this.newSegment(0);
        }
    }

    private static class Renderer
    extends TextRenderer {
        private Renderer() {
        }

        public BBrush getForeground(Segment seg) {
            return BTextEditorOptions.make().getColorCoding().getColor(seg).toBrush();
        }
    }

    protected class Browse
    extends Command {
        public boolean def;

        public Browse(TypeInfo info, boolean def) {
            super((BWidget)BFormatOrdFE.this, info.getDisplayName(null));
            this.def = def;
        }

        public CommandArtifact doInvoke() {
            String text;
            BObject base = null;
            if (BFormatOrdFE.this.shell != null) {
                base = BFormatOrdFE.this.shell.getActiveOrdTarget().get();
            }
            if ((text = BFormatOrdFE.this.field.getText()).isEmpty()) {
                text = "null";
            }
            BOrd temp = BOrd.make((String)text);
            BIOrdChooser chooser = (BIOrdChooser)BHistoryOrdChooser.TYPE.getInstance();
            BOrd ord = chooser.openChooser((BWidget)BFormatOrdFE.this, base, temp, BFormatOrdFE.this.getCurrentContext());
            if (ord != null) {
                if (BFormatOrdFE.this.isRelativize(ord)) {
                    ord = ord.relativizeToSession();
                }
                BFormatOrdFE.this.field.setText(ord.toString());
            }
            return null;
        }

        public String getLabel() {
            return this.def ? null : super.getLabel();
        }

        public BImage getIcon() {
            return this.def ? browseIcon : null;
        }
    }

    class MenuController
    implements BAbstractButton.MenuController {
        MenuController() {
        }

        public boolean isMenuDistinct() {
            return true;
        }

        public BMenu getMenu(BAbstractButton b) {
            return BFormatOrdFE.this.menu;
        }
    }
}

