/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.functions.ui;

import com.tridium.seriestransform.functions.BFunctionMap;
import com.tridium.seriestransform.functions.BFunctionMapping;
import com.tridium.seriestransform.functions.ui.BFunctionMapBuilder;
import com.tridium.workbench.fieldeditors.BDialogFE;
import java.util.ArrayList;
import java.util.List;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:FunctionMap"})})
public class BFunctionMapFE
extends BDialogFE {
    public static final Type TYPE = Sys.loadType(BFunctionMapFE.class);
    private static final Lexicon lex = Lexicon.make(BFunctionMapFE.class);
    private static final String LEX_OUTPUT_COLUMN = lex.getText("FunctionMapFE.outputColumn");
    private static final String LEX_FUNCTION_NAME = lex.getText("FunctionMapFE.functionName");
    private static final String LEX_FUNCTION_DESC = lex.getText("FunctionMapFE.functionDesc");
    private static final int COL_OUTPUT_NAME = 0;
    private static final int COL_FUNCTION = 1;
    private static final int COL_DESC = 2;
    private final List<BFunctionMapping> rows = new ArrayList<BFunctionMapping>();
    private final BTable display = new BTable((TableModel)new Model());
    private BFunctionMap functionMap;
    boolean enabled = true;

    public Type getType() {
        return TYPE;
    }

    public BFunctionMapFE() {
        BScrollPane scroll = new BScrollPane((BWidget)this.display);
        scroll.setVpolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane pane = new BConstrainedPane((BWidget)scroll);
        pane.setMinHeight(100.0);
        pane.setMinWidth(250.0);
        BGridPane main = new BGridPane(2);
        main.add(null, (BValue)pane);
        main.add(null, (BValue)this.getEditButton());
        this.setContent((BWidget)main);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.functionMap = (BFunctionMap)value;
        BPermissions permissions = this.functionMap.getPermissions(context);
        this.setReadonly(!permissions.hasOperatorWrite());
        this.functionMap.lease();
        BFunctionMapping[] mappings = (BFunctionMapping[])this.functionMap.getChildren(BFunctionMapping.class);
        this.rows.clear();
        for (BFunctionMapping mapping : mappings) {
            mapping.lease();
            this.rows.add(mapping);
        }
        this.display.getModel().updateTable();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return this.functionMap;
    }

    protected void doSetReadonly(boolean readonly) {
        this.enabled = !readonly;
        this.setEnabled(!readonly);
    }

    public void doEditPressed() {
        try {
            BFunctionMap map = BFunctionMapBuilder.open((BWidget)this, this.functionMap);
            if (null != map && !map.equivalent((Object)this.functionMap)) {
                this.functionMap = map;
                this.setModified();
                this.loadValue((BObject)this.functionMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.doEditPressed();
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return LEX_OUTPUT_COLUMN;
                }
                case 1: {
                    return LEX_FUNCTION_NAME;
                }
                case 2: {
                    return LEX_FUNCTION_DESC;
                }
            }
            return "?";
        }

        public int getRowCount() {
            return BFunctionMapFE.this.rows.size();
        }

        public Object getValueAt(int row, int col) {
            if (row >= BFunctionMapFE.this.rows.size()) {
                return null;
            }
            BFunctionMapping mapping = (BFunctionMapping)BFunctionMapFE.this.rows.get(row);
            switch (col) {
                case 0: {
                    return mapping.getOutputField();
                }
                case 1: {
                    return mapping.getFunctionTypeSpec();
                }
                case 2: {
                    BTypeSpec functionTypeSpec = mapping.getFunctionTypeSpec();
                    BTransformFunction instance = (BTransformFunction)functionTypeSpec.getInstance();
                    String functionDesc = instance.getFunctionDesc();
                    return functionDesc;
                }
            }
            return "?";
        }
    }
}

