/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.filter.ui;

import com.tridium.seriestransform.filter.BMatchTypeEnum;
import com.tridium.seriestransform.graph.ui.BConfigItem;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BFilterJoinTypeConfig
extends BConfigItem {
    public static final Type TYPE = Sys.loadType(BFilterJoinTypeConfig.class);
    private static final Lexicon lex = Lexicon.make(BFilterJoinTypeConfig.class);
    private static final String DESC = lex.getText("bqlfilter.matchtype.desc");
    private final BWbFieldEditor matchTypeEditor = BWbFieldEditor.makeFor((BObject)BMatchTypeEnum.DEFAULT);
    private boolean readonly;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFilterJoinTypeConfig() {
        this(BMatchTypeEnum.DEFAULT);
    }

    public BFilterJoinTypeConfig(BMatchTypeEnum matchType) {
        this.buildUI(matchType);
    }

    public BFilterJoinTypeConfig(String matchType) {
        BMatchTypeEnum matchEnum = BMatchTypeEnum.DEFAULT;
        if (null != matchType) {
            if (BMatchTypeEnum.DEFAULT.getRange().isTag(matchType)) {
                matchEnum = BMatchTypeEnum.make((String)matchType);
            } else if ("or".equals(matchType.toLowerCase())) {
                matchEnum = BMatchTypeEnum.matchAny;
            } else if ("and".equals(matchType.toLowerCase())) {
                matchEnum = BMatchTypeEnum.matchAll;
            }
        }
        this.buildUI(matchEnum);
    }

    private void buildUI(BMatchTypeEnum matchType) {
        this.matchTypeEditor.loadValue((BObject)matchType);
        BGridPane content = new BGridPane(4);
        content.add("warning", (BValue)this.statusIcon);
        content.add("description", (BValue)new BLabel(DESC));
        content.add("matchType", (BValue)this.matchTypeEditor);
        this.setCenter((BWidget)content);
        this.linkTo((BComponent)this.matchTypeEditor, (Slot)BWbPlugin.setModified, (Slot)modified);
    }

    public BMatchTypeEnum getMatchType() throws Exception {
        BObject saveValue = this.matchTypeEditor.saveValue();
        return (BMatchTypeEnum)saveValue;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.matchTypeEditor.setEnabled(!readonly);
    }

    public boolean getReadonly() {
        return this.readonly;
    }
}

