/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.filter.ui;

import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.bql.compiler.Token;
import com.tridium.seriestransform.filter.BBqlFilterNode;
import com.tridium.seriestransform.filter.BMatchTypeEnum;
import com.tridium.seriestransform.filter.ui.BFilterJoinTypeConfig;
import com.tridium.seriestransform.filter.ui.BFilterMatchConfig;
import com.tridium.seriestransform.graph.ui.BConfigEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;

@NiagaraType
public class BBqlFilterQueryBuilder
extends BConfigEditor {
    public static final Type TYPE = Sys.loadType(BBqlFilterQueryBuilder.class);
    private static final Lexicon lex = Lexicon.make(BBqlFilterQueryBuilder.class);
    private static final String TITLE = lex.getText("filterQueryBuilder.title");
    private static final String PREDICATES_SECTION = lex.getText("bqlFilterEditor.section.predicates");
    private static final Command[] EMPTY_COMMANDS = new Command[0];
    private BSeriesSchema srcSchema;
    private String srcQuery;
    private boolean readonly;
    private final List<BFilterMatchConfig> rows = new ArrayList<BFilterMatchConfig>();
    private BFilterJoinTypeConfig joinTypeConfig;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static String open(BWidget owner, BBqlFilterNode filterNode) throws Exception {
        if (null == filterNode) {
            throw new Exception("BqlFilterNode cannot be NULL");
        }
        BBqlFilterQueryBuilder fqb = new BBqlFilterQueryBuilder(filterNode);
        int result = BRoundedDialog.open((BWidget)owner, (String)TITLE, (Object)((Object)fqb), (int)3);
        if (result != 1) {
            return null;
        }
        return fqb.saveQuery();
    }

    public BBqlFilterQueryBuilder() {
    }

    public BBqlFilterQueryBuilder(BBqlFilterNode filterNode) {
        filterNode.lease();
        this.srcSchema = filterNode.getSchema();
        this.srcQuery = filterNode.getQueryText();
        this.buildUI();
    }

    private void buildUI() {
        BWidget display = this.buildTableDisplay(PREDICATES_SECTION, new Command[]{new AddMatchCmd((BWidget)this)});
        this.setCenter(display);
        this.joinTypeConfig = BBqlFilterQueryBuilder.makeJoinType(this.srcQuery);
        this.addConfig(this.joinTypeConfig, EMPTY_COMMANDS);
        this.parseMatches(this.srcQuery);
    }

    private static BFilterJoinTypeConfig makeJoinType(String whereClause) {
        BMatchTypeEnum matchType = BMatchTypeEnum.matchAny;
        if (null != whereClause && whereClause.toLowerCase().indexOf(" and ") > 0) {
            matchType = BMatchTypeEnum.matchAll;
        }
        return new BFilterJoinTypeConfig(matchType);
    }

    private void parseMatches(String whereClause) {
        BqlTokenizer tokenizer = new BqlTokenizer(whereClause);
        Token token = tokenizer.next();
        while (token.type != 2) {
            if ("and".equals(token.lex) || "or".equals(token.lex)) {
                token = tokenizer.next();
            }
            StringBuilder field = new StringBuilder();
            StringBuilder type = new StringBuilder();
            StringBuilder value = new StringBuilder();
            field.append(token.lex);
            token = tokenizer.next();
            while (token.type == 12) {
                token = tokenizer.next();
                field.append('.');
                field.append(token.lex);
                token = tokenizer.next();
            }
            String op = token.lex;
            token = tokenizer.next();
            if (token.type == 23) {
                type.append(token.lex);
                token = tokenizer.next();
            }
            value.append(token.lex);
            token = tokenizer.next();
            while (token.type == 12) {
                token = tokenizer.next();
                value.append('.');
                value.append(token.lex);
                token = tokenizer.next();
            }
            this.makeMatchConfig(field.toString(), op, type.toString(), value.toString());
        }
    }

    private BFilterMatchConfig makeMatchConfig(String field, String op, String type, String value) {
        BFilterMatchConfig config = new BFilterMatchConfig(this.srcSchema, field, op, type, value);
        this.addConfig(config, new Command[]{new RemoveMatchCmd((BWidget)this, config)});
        this.rows.add(config);
        return config;
    }

    public String saveQuery() throws Exception {
        StringBuilder saveQueryVal = new StringBuilder();
        BMatchTypeEnum matchType = this.joinTypeConfig.getMatchType();
        String joiner = matchType == BMatchTypeEnum.matchAll ? "AND" : "OR";
        Iterator<BFilterMatchConfig> it = this.rows.iterator();
        while (it.hasNext()) {
            BFilterMatchConfig config = it.next();
            saveQueryVal.append(config.saveMatch());
            if (!it.hasNext()) continue;
            saveQueryVal.append(' ').append(joiner).append(' ');
        }
        return saveQueryVal.toString();
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.joinTypeConfig.setReadonly(readonly);
        for (BFilterMatchConfig config : this.rows) {
            config.setReadonly(readonly);
        }
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    @Override
    public boolean doValidate() {
        this.setModified();
        return true;
    }

    private class RemoveMatchCmd
    extends Command {
        private final BFilterMatchConfig config;

        public RemoveMatchCmd(BWidget owner, BFilterMatchConfig config) {
            super(owner, "");
            this.config = config;
        }

        public CommandArtifact doInvoke() throws Exception {
            BBqlFilterQueryBuilder.this.rows.remove((Object)this.config);
            BBqlFilterQueryBuilder.this.removeConfig((BWidget)this.config);
            BBqlFilterQueryBuilder.this.setModified();
            return null;
        }

        public BImage getIcon() {
            return minusIcon;
        }
    }

    private class AddMatchCmd
    extends Command {
        public AddMatchCmd(BWidget owner) {
            super(owner, "");
        }

        public CommandArtifact doInvoke() throws Exception {
            BBqlFilterQueryBuilder.this.makeMatchConfig(null, null, null, null);
            BBqlFilterQueryBuilder.this.setModified();
            return null;
        }

        public BImage getIcon() {
            return addIcon;
        }
    }
}

