/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.sentience.util;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import java.io.Reader;
import java.io.StringReader;
import java.util.Base64;
import javax.baja.sys.BAbsTime;
import javax.baja.timezone.BTimeZone;

public class BearerTokenInfo {
    private static final String JWT_ALGORITHM = "alg";
    private static final String JWT_ISSUER = "iss";
    private static final String JWT_AUDIENCE = "aud";
    private static final String JWT_EXPIRATION = "exp";
    private static final String JWT_NOT_BEFORE = "nbf";
    public static final String INVALID_JWT_FORMAT = "Invalid JWT format";
    private String algorithm;
    private String systemId;
    private String systemType;
    private String issuer;
    private String audience;
    private BAbsTime notBefore;
    private BAbsTime expirationTime;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getAudience() {
        return this.audience;
    }

    public BAbsTime getNotBefore() {
        return this.notBefore;
    }

    public BAbsTime getExpirationTime() {
        return this.expirationTime;
    }

    public BearerTokenInfo(String idjwt) {
        this.fromString(idjwt);
    }

    public void fromString(String idjwt) {
        if (!idjwt.isEmpty()) {
            String[] jwtParts = idjwt.split("\\.");
            if (jwtParts == null || jwtParts.length < 2) {
                this.invalid();
            } else {
                try {
                    String joseHdr = new String(Base64.getDecoder().decode(jwtParts[0]));
                    JSONTokener tokener = new JSONTokener((Reader)new StringReader(joseHdr));
                    JSONObject obj = new JSONObject(tokener);
                    this.algorithm = obj.getString(JWT_ALGORITHM);
                    String jwtClaims = new String(Base64.getDecoder().decode(jwtParts[1]));
                    tokener = new JSONTokener((Reader)new StringReader(jwtClaims));
                    obj = new JSONObject(tokener);
                    this.systemId = obj.getString("SystemId");
                    this.systemType = obj.getString("SystemType");
                    this.issuer = obj.getString(JWT_ISSUER);
                    this.audience = obj.getString(JWT_AUDIENCE);
                    this.notBefore = BAbsTime.make((BAbsTime)BAbsTime.make((long)((long)obj.getInt(JWT_NOT_BEFORE) * 1000L), (BTimeZone)BTimeZone.UTC), (BTimeZone)BTimeZone.getLocal());
                    this.expirationTime = BAbsTime.make((BAbsTime)BAbsTime.make((long)((long)obj.getInt(JWT_EXPIRATION) * 1000L), (BTimeZone)BTimeZone.UTC), (BTimeZone)BTimeZone.getLocal());
                }
                catch (Exception err) {
                    this.invalid();
                }
            }
        } else {
            this.clear();
        }
    }

    private void invalid() {
        this.clear();
        this.algorithm = INVALID_JWT_FORMAT;
    }

    public void clear() {
        this.algorithm = "";
        this.systemId = "";
        this.systemType = "n4-station";
        this.issuer = "";
        this.audience = "";
        this.notBefore = BAbsTime.DEFAULT;
        this.expirationTime = BAbsTime.DEFAULT;
    }
}

