/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.sentience;

import com.tridium.cloud.client.BCloudConnector;
import com.tridium.cloud.client.BIBearerTokenProvider;
import com.tridium.cloud.client.MessageCallback;
import com.tridium.cloud.client.iothub.BAbstractIotHubConnectorImpl;
import com.tridium.cloud.client.iothub.MessageClientConnectionState;
import com.tridium.cloud.client.sentience.BSentienceDevTestComponent;
import com.tridium.cloud.client.sentience.BSystemRegistrationState;
import com.tridium.cloud.client.sentience.SystemAuthenticationException;
import com.tridium.cloud.client.sentience.util.BearerTokenInfo;
import com.tridium.cloud.client.sentience.util.RpkChallengeParameters;
import com.tridium.cloud.client.sentience.util.RpkChallengeResponseParameters;
import com.tridium.cloud.util.HttpStatusException;
import com.tridium.cloud.util.HttpUtils;
import com.tridium.cloud.util.StandardHttpUtils;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.HsmManager;
import javax.baja.nre.security.IKeyPurpose;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.security.crypto.X509CertificateFactory;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.net.SocketFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="systemId", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="gatewayId", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="systemType", type="BString", defaultValue=""), @NiagaraProperty(name="systemOwnershipCode", type="String", defaultValue="", flags=1), @NiagaraProperty(name="systemPublicKey", type="BString", defaultValue="", flags=7), @NiagaraProperty(name="deviceRegistrationUrl", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="deviceAuthenticationUrl", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="registrationUrl", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="migrationUrl", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="cloudCertVerification", type="BBoolean", defaultValue="BBoolean.FALSE", flags=133), @NiagaraProperty(name="certIsValid", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="registrationState", type="BSystemRegistrationState", defaultValue="BSystemRegistrationState.DEFAULT", flags=1), @NiagaraProperty(name="httpConnectTimeout", type="BRelTime", defaultValue="BRelTime.makeMinutes(2)"), @NiagaraProperty(name="httpReadTimeout", type="BRelTime", defaultValue="BRelTime.makeMinutes(10)")})
@NiagaraTopic(name="registrationFailed", eventType="BString", flags=4)
public final class BSentienceConnectorImpl
extends BAbstractIotHubConnectorImpl
implements BIBearerTokenProvider,
MessageCallback {
    public static final Property systemId = BSentienceConnectorImpl.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property gatewayId = BSentienceConnectorImpl.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property systemType = BSentienceConnectorImpl.newProperty((int)0, (String)"", null);
    public static final Property systemOwnershipCode = BSentienceConnectorImpl.newProperty((int)1, (String)"", null);
    public static final Property systemPublicKey = BSentienceConnectorImpl.newProperty((int)7, (String)"", null);
    public static final Property deviceRegistrationUrl = BSentienceConnectorImpl.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property deviceAuthenticationUrl = BSentienceConnectorImpl.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property registrationUrl = BSentienceConnectorImpl.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property migrationUrl = BSentienceConnectorImpl.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property cloudCertVerification = BSentienceConnectorImpl.newProperty((int)133, (boolean)((BBoolean)BBoolean.FALSE.as(BBoolean.class)).getBoolean(), null);
    public static final Property certIsValid = BSentienceConnectorImpl.newProperty((int)5, (boolean)false, null);
    public static final Property registrationState = BSentienceConnectorImpl.newProperty((int)1, (BValue)BSystemRegistrationState.DEFAULT, null);
    public static final Property httpConnectTimeout = BSentienceConnectorImpl.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), null);
    public static final Property httpReadTimeout = BSentienceConnectorImpl.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)10), null);
    public static final Topic registrationFailed = BSentienceConnectorImpl.newTopic((int)4, null);
    public static final Type TYPE = Sys.loadType(BSentienceConnectorImpl.class);
    private static final Lexicon lex = Lexicon.make((String)"cloudSentienceConnector");
    private static final Logger log = Logger.getLogger("cloud.connector.sentience");
    private static SecureRandom sRand;
    private long jwtExpirationClockSkew;
    private ECPrivateKey myPrivateKey;
    private ECPublicKey myPublicKey;
    private static final Provider KEYGEN_PROVIDER;
    private ScheduledFuture<?> reconnectFuture;
    private volatile Map<String, ConnectionInfo> cachedConnectionInfoMap = Collections.emptyMap();
    private final HttpUtils httpUtils = StandardHttpUtils.make();
    private String connectionString = "";
    private static final Pattern JWT_PATTERN;
    private static final Pattern SAS_PATTERN;
    private static final int MAX_KEYCHECK_ITERS = 99;
    private static final int ITERS_LEN = 2;
    private static final int MAX_SAFE_NAME_LEN = 23;
    private static final int HOSTID_INDEX = 2;
    public static final String REGEX = "^(http[s]?://www\\.|http[s]?://|www\\.)";
    private static final Pattern URL_BEGIN;
    public static final int PORT = 443;
    private static final DateTimeFormatter SAS_DATE_FORMATTER;
    private static final byte[] EMPTY_BYTES;
    private static final String SAS_KEY_SE = "se";

    public String getSystemId() {
        return this.getString(systemId);
    }

    public void setSystemId(String v) {
        this.setString(systemId, v, null);
    }

    public String getGatewayId() {
        return this.getString(gatewayId);
    }

    public void setGatewayId(String v) {
        this.setString(gatewayId, v, null);
    }

    public String getSystemType() {
        return this.getString(systemType);
    }

    public void setSystemType(String v) {
        this.setString(systemType, v, null);
    }

    public String getSystemOwnershipCode() {
        return this.getString(systemOwnershipCode);
    }

    public void setSystemOwnershipCode(String v) {
        this.setString(systemOwnershipCode, v, null);
    }

    public String getSystemPublicKey() {
        return this.getString(systemPublicKey);
    }

    public void setSystemPublicKey(String v) {
        this.setString(systemPublicKey, v, null);
    }

    public String getDeviceRegistrationUrl() {
        return this.getString(deviceRegistrationUrl);
    }

    public void setDeviceRegistrationUrl(String v) {
        this.setString(deviceRegistrationUrl, v, null);
    }

    public String getDeviceAuthenticationUrl() {
        return this.getString(deviceAuthenticationUrl);
    }

    public void setDeviceAuthenticationUrl(String v) {
        this.setString(deviceAuthenticationUrl, v, null);
    }

    public String getRegistrationUrl() {
        return this.getString(registrationUrl);
    }

    public void setRegistrationUrl(String v) {
        this.setString(registrationUrl, v, null);
    }

    public String getMigrationUrl() {
        return this.getString(migrationUrl);
    }

    public void setMigrationUrl(String v) {
        this.setString(migrationUrl, v, null);
    }

    public boolean getCloudCertVerification() {
        return this.getBoolean(cloudCertVerification);
    }

    public void setCloudCertVerification(boolean v) {
        this.setBoolean(cloudCertVerification, v, null);
    }

    public boolean getCertIsValid() {
        return this.getBoolean(certIsValid);
    }

    public void setCertIsValid(boolean v) {
        this.setBoolean(certIsValid, v, null);
    }

    public BSystemRegistrationState getRegistrationState() {
        return (BSystemRegistrationState)this.get(registrationState);
    }

    public void setRegistrationState(BSystemRegistrationState v) {
        this.set(registrationState, (BValue)v, null);
    }

    public BRelTime getHttpConnectTimeout() {
        return (BRelTime)this.get(httpConnectTimeout);
    }

    public void setHttpConnectTimeout(BRelTime v) {
        this.set(httpConnectTimeout, (BValue)v, null);
    }

    public BRelTime getHttpReadTimeout() {
        return (BRelTime)this.get(httpReadTimeout);
    }

    public void setHttpReadTimeout(BRelTime v) {
        this.set(httpReadTimeout, (BValue)v, null);
    }

    public void fireRegistrationFailed(BString event) {
        this.fire(registrationFailed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.jwtExpirationClockSkew = Long.getLong("niagara.cloud.jwt.expiration.skew", BRelTime.HOUR.getSeconds());
        this.setTimeouts();
        this.validateSystemInfo();
        this.initializeKeys();
        this.getCloudConnector().addMessageCallback((MessageCallback)this);
        String gatewayIdEnvVariable = AccessController.doPrivileged(() -> {
            String s = System.getenv("PELION_DEVICE_ID");
            return s != null ? s : "";
        });
        this.setGatewayId(gatewayIdEnvVariable);
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(httpConnectTimeout) || p.equals(httpReadTimeout)) {
            this.setTimeouts();
        } else if (p.equals(systemType) && !this.getCloudConnector().isDisabled()) {
            this.getCloudConnector().reconnect();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getCloudConnector().removeMessageCallback((MessageCallback)this);
        try {
            if (this.reconnectFuture != null) {
                this.reconnectFuture.cancel(true);
            }
        }
        finally {
            this.reconnectFuture = null;
        }
    }

    public AgentList filterCloudConnectorAgents(AgentList list, Context cx) {
        String ts = "cloudSentienceConnector:DeviceRegistrationWidget";
        list.add(ts);
        list.toTop(ts);
        return list;
    }

    private void setTimeouts() {
        try {
            this.httpUtils.setConnectTimeout(Math.toIntExact(this.getHttpConnectTimeout().getMillis()));
        }
        catch (ArithmeticException e) {
            log.config("Could not set configured HTTP connect timeout, connector will use previously saved value");
        }
        try {
            this.httpUtils.setReadTimeout(Math.toIntExact(this.getHttpReadTimeout().getMillis()));
        }
        catch (ArithmeticException e) {
            log.config("Could not set configured HTTP read timeout, connector will use previously saved value");
        }
    }

    private void generateCertVerificationAlarm() {
        try {
            BAlarmSourceInfo info = new BAlarmSourceInfo();
            if (this.getCloudConnector() != null && this.getCloudConnector().getName() != null) {
                info.setSourceName(BFormat.make((String)this.getCloudConnector().getName()));
            }
            info.setToOffnormalText(BFormat.make((String)lex.get("certVerificationDisabled")));
            info.setToNormalText(BFormat.make((String)lex.get("certVerificationEnabled")));
            AlarmSupport alarmSupport = new AlarmSupport((BIAlarmSource)this.getCloudConnector(), info);
            if (!this.getCloudCertVerification()) {
                log.warning(lex.get("certVerificationDisabled"));
                alarmSupport.newOffnormalAlarm(BFacets.DEFAULT);
            } else {
                log.warning(lex.get("certVerificationEnabled"));
                alarmSupport.toNormal(null);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, lex.get("certAlarmError"), e);
        }
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "cloudSentienceConnector");
    }

    public boolean canConnect() {
        return this.getSystemType() != null && !this.getSystemType().isEmpty() && super.canConnect();
    }

    protected void doConnect() throws Exception {
        long connectTicks = Clock.ticks();
        this.validateSentienceIdpCertificate();
        this.registerDevice();
        super.doConnect();
        this.setRegistrationState(BSystemRegistrationState.registered);
        log.config(() -> String.format("Connected to Sentience: %s - %s ms", this.getCloudConnector().getId(), Clock.ticks() - connectTicks));
        this.scheduleRenewal(this.getRenewalInterval().getMinutes());
    }

    private void scheduleRenewal(int minutes) {
        if (minutes <= 0) {
            return;
        }
        this.reconnectFuture = this.getCloudConnector().scheduleExec("SentienceConnectorImpl.scheduleRenewal", Executors.callable(this::doRenewal), (long)minutes, TimeUnit.MINUTES);
        log.config(() -> String.format("Next Cloud Connector token renewal scheduled for: %s", ZonedDateTime.now().plusMinutes(minutes).format(SAS_DATE_FORMATTER)));
    }

    private void doRenewal() {
        try {
            log.config(() -> "Renewing Cloud Connector tokens.");
            this.connect();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(log.getLevel(), "Cloud Connector token renewal failed." + e.getMessage());
            } else {
                log.log(Level.WARNING, "Cloud Connector token renewal failed.");
            }
            if (this.getMessageClient().getConnectionState() == MessageClientConnectionState.DISCONNECTED) {
                log.warning("BMessageClient is disconnected, invoking reconnect");
                this.getCloudConnector().doReconnect();
                return;
            }
            this.scheduleRenewal(this.getRenewalFailureInterval().getMinutes());
        }
    }

    public BRelTime getRenewalInterval() {
        Property p = this.getProperty("renewalInterval");
        BRelTime interval = p != null && p.getType().is(BRelTime.TYPE) ? (BRelTime)this.get(p).as(BRelTime.class) : this.calculateRenewal();
        return interval;
    }

    public BRelTime getRenewalFailureInterval() {
        Property p = this.getProperty("renewalFailureInterval");
        BRelTime interval = p != null && p.getType().is(BRelTime.TYPE) ? (BRelTime)this.get(p).as(BRelTime.class) : this.calculateRenewal();
        return interval;
    }

    private BRelTime calculateRenewal() {
        BRelTime interval = BRelTime.make((long)0L);
        ConnectionInfo iotHubInfo = BSentienceConnectorImpl.getIotHubConnectionInfo(this.cachedConnectionInfoMap);
        if (iotHubInfo == null) {
            return interval;
        }
        try {
            Map<String, String> sasParams = BSentienceConnectorImpl.parseSasToken(iotHubInfo.getPassword());
            String expEpochSecStr = sasParams.get(SAS_KEY_SE);
            if (expEpochSecStr != null) {
                long expEpochSec = Long.parseLong(expEpochSecStr);
                long intervalSec = expEpochSec - Instant.now().getEpochSecond();
                if (intervalSec > 1200L) {
                    interval = BRelTime.makeSeconds((int)Math.toIntExact(intervalSec / 2L));
                } else {
                    ZonedDateTime expDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(expEpochSec), ZoneId.systemDefault());
                    log.log(Level.WARNING, "The Iot Hub connection token expires too soon for renewal: " + expDateTime.format(SAS_DATE_FORMATTER) + "  (" + expEpochSecStr + ')');
                }
            }
        }
        catch (Exception e) {
            log.log(Level.CONFIG, "An error occured while calculating the IoT Hub token renewal interval: ", e);
        }
        return interval;
    }

    protected void registerDevice() throws Exception {
        Map<String, ConnectionInfo> connectionInfo;
        String provisioningSrvToken;
        BCloudConnector connector = this.getCloudConnector();
        if (connector.isFatalFault()) {
            throw new IllegalStateException();
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Connecting to Sentience");
        }
        this.initializeKeys();
        try {
            provisioningSrvToken = this.rpkChallenge(this.getSystemId(), this.getSystemType(), this.getDeviceAuthenticationUrl());
        }
        catch (HttpStatusException e) {
            if (e.getStatusCode() == 404) {
                this.setRegistrationState(BSystemRegistrationState.unregistered);
                this.fireRegistrationFailed(BString.DEFAULT);
                throw new IOException("Device not registered");
            }
            throw e;
        }
        if (this.getRegistrationState() == BSystemRegistrationState.unregistered) {
            this.setRegistrationState(BSystemRegistrationState.needsProvisioning);
        }
        if ((connectionInfo = this.systemConnections(provisioningSrvToken, this.getRegistrationUrl())).isEmpty()) {
            throw new RuntimeException("Could not find any system connection information");
        }
        ConnectionInfo iotHubInfo = BSentienceConnectorImpl.getIotHubConnectionInfo(connectionInfo);
        connector.setId(iotHubInfo.getUserName());
        this.cachedConnectionInfoMap = connectionInfo;
        String sasToken = iotHubInfo.getPassword();
        String path = iotHubInfo.getPath();
        this.connectionString = String.format("HostName=%s;DeviceId=%s;SharedAccessSignature=%s;X509Cert=False", path, this.getCloudConnector().getId(), sasToken);
    }

    protected String getConnectionString() {
        NiagaraBasicPermission getConnectionStringPermission = new NiagaraBasicPermission("CLOUD_GET_CONNECTION_INFORMATION");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)getConnectionStringPermission);
        } else {
            log.info("Security Manager is null; cloud connection string permission check not engaged.");
        }
        return this.connectionString;
    }

    public Map<String, String> getConnectionInfo(String id) {
        ConnectionInfo info;
        if (!this.getCloudConnector().isOperational()) {
            log.finest("getConnectionInfo called while authenticator is not operational");
            return Collections.emptyMap();
        }
        NiagaraBasicPermission getConnectionStringPermission = new NiagaraBasicPermission("CLOUD_GET_CONNECTION_INFORMATION");
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            log.finest("getConnectionInfo called with no security manager");
            return Collections.emptyMap();
        }
        sm.checkPermission((Permission)getConnectionStringPermission);
        HashMap<String, String> connectionMap = new HashMap<String, String>();
        if (this.cachedConnectionInfoMap != null) {
            info = this.cachedConnectionInfoMap.get(id);
            if (info != null && this.isSasTokenExpired(info.getPassword()).orElse(false).booleanValue()) {
                info = this.refreshToken(id);
            }
        } else {
            info = this.refreshToken(id);
        }
        if (info != null) {
            connectionMap.put("hostName", info.getPath());
            connectionMap.put("id", info.getUserName());
            connectionMap.put("token", info.getPassword());
        } else {
            log.finest("getConnectionInfo called but no connection info found for given id.");
        }
        return connectionMap;
    }

    private ConnectionInfo refreshToken(String id) {
        if (this.canConnect()) {
            log.config("Refreshing IoT Hub token");
            try {
                this.registerDevice();
                ConnectionInfo refreshedInfo = this.cachedConnectionInfoMap.get(id);
                if (refreshedInfo != null) {
                    log.config("Refreshed IoT Hub token");
                    return refreshedInfo;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not refresh IoT Hub token", e);
            }
        }
        return null;
    }

    private Optional<Boolean> isSasTokenExpired(String token) {
        try {
            Map<String, String> sasParams;
            String sasValueSe;
            if (BSentienceConnectorImpl.isSasToken(token) && (sasValueSe = (sasParams = BSentienceConnectorImpl.parseSasToken(token)).get(SAS_KEY_SE)) != null) {
                long epochSec = Long.parseLong(sasValueSe);
                BAbsTime expirationTime = BAbsTime.make((long)((epochSec - this.jwtExpirationClockSkew) * 1000L));
                BAbsTime now = BAbsTime.now();
                log.config(() -> String.format("Expiration time from token: %s", expirationTime));
                return Optional.of(expirationTime.isBefore(now));
            }
        }
        catch (Exception e) {
            log.fine(() -> String.format("Could not determine expiration of token: %s", e));
        }
        return Optional.empty();
    }

    private static ConnectionInfo getIotHubConnectionInfo(Map<String, ConnectionInfo> connections) {
        if (connections == null) {
            return null;
        }
        ConnectionInfo iotHubInfo = connections.get("IoTHub2");
        if (iotHubInfo == null) {
            iotHubInfo = connections.get("IoTHub");
        }
        return iotHubInfo;
    }

    private static boolean isSasToken(String sasToken) {
        if (sasToken == null || sasToken.isEmpty()) {
            return false;
        }
        return sasToken.trim().startsWith("SharedAccessSignature");
    }

    private static Map<String, String> parseSasToken(String sasToken) {
        HashMap<String, String> sasParams = new HashMap<String, String>();
        if (sasToken == null || sasToken.isEmpty()) {
            return sasParams;
        }
        try {
            Matcher matcher = SAS_PATTERN.matcher(sasToken);
            while (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2);
                if (key == null || key.isEmpty()) continue;
                value = value == null ? "unavailable" : URLDecoder.decode(value.trim(), "UTF-8");
                sasParams.put(key, value);
            }
        }
        catch (Exception e) {
            log.log(Level.CONFIG, "An error occured while parsing the SAS Token.", e);
        }
        return sasParams;
    }

    protected void doDisconnect() throws Exception {
        try {
            super.doDisconnect();
            if (this.reconnectFuture != null) {
                this.reconnectFuture.cancel(true);
            }
        }
        finally {
            this.reconnectFuture = null;
            this.cachedConnectionInfoMap = Collections.emptyMap();
            this.connectionString = "";
        }
    }

    public String getBearerToken(String id) {
        NiagaraBasicPermission getBearerTokenPermission = new NiagaraBasicPermission("CLOUD_GET_CONNECTION_INFORMATION");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)getBearerTokenPermission);
        } else {
            log.info("Security Manager is null; cloud bearer token permission check not engaged.");
        }
        String bearerToken = "";
        if (bearerToken != null && !bearerToken.isEmpty()) {
            log.fine("Returning bearer token from cloudLinkAuthenticator");
            return bearerToken;
        }
        ConnectionInfo info = this.cachedConnectionInfoMap.get(id);
        if (info != null) {
            JSONObject claims;
            block18: {
                bearerToken = info.getPassword();
                claims = null;
                Matcher matcher = JWT_PATTERN.matcher(bearerToken);
                if (matcher.matches()) {
                    try {
                        String claimsStr = new String(Base64.getDecoder().decode(matcher.group(2)));
                        claims = new JSONObject(claimsStr);
                    }
                    catch (Exception exception) {
                        if (!log.isLoggable(Level.FINE)) break block18;
                        log.log(Level.FINE, exception.getMessage());
                    }
                }
            }
            if (claims != null && claims.has("exp")) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Testing bearer token for refresh: " + id);
                }
                BAbsTime expirationTime = BAbsTime.make((long)((claims.getLong("exp") - this.jwtExpirationClockSkew) * 1000L));
                BAbsTime now = BAbsTime.now();
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Bearer token calculated expiration time: " + expirationTime);
                }
                if (expirationTime.isBefore(now)) {
                    if (!this.getCloudConnector().isConnected()) {
                        log.warning("Could not refresh Cloud Bearer token - not connected: " + id);
                    } else {
                        if (log.isLoggable(Level.CONFIG)) {
                            log.config("Refreshing bearer token: " + id);
                        }
                        try {
                            String provisioningSrvToken = this.rpkChallenge(this.getSystemId(), this.getSystemType(), this.getDeviceAuthenticationUrl());
                            Map<String, ConnectionInfo> connectionInfo = this.systemConnections(provisioningSrvToken, this.getRegistrationUrl());
                            ConnectionInfo refreshedInfo = connectionInfo.get(id);
                            if (refreshedInfo != null) {
                                bearerToken = refreshedInfo.getPassword();
                                if (log.isLoggable(Level.CONFIG)) {
                                    log.config("Refreshed bearer token: " + id);
                                }
                            }
                            this.cachedConnectionInfoMap = connectionInfo;
                        }
                        catch (Exception err) {
                            bearerToken = "";
                            log.log(Level.WARNING, "Could not refresh Cloud Bearer token: " + id, err);
                        }
                    }
                }
            }
        }
        return bearerToken;
    }

    protected void doPing() {
        BCloudConnector connector = this.getCloudConnector();
        try {
            JSONObject heartbeatPayload = new JSONObject();
            heartbeatPayload.put("SystemTime", (Object)BAbsTime.now().encodeToString());
            String systemGuid = connector.getId();
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("ObjectType", "HeartbeatRequest");
            props.put("ObjectVersion", "1");
            props.put("SystemGuid", systemGuid);
            props.put("From", systemGuid);
            props.put("EventId", UUID.randomUUID().toString());
            CompletableFuture future = new CompletableFuture();
            this.sendMessage(heartbeatPayload.toString().getBytes(StandardCharsets.UTF_8), props, future);
            if (!future.isCompletedExceptionally() && log.isLoggable(Level.FINE)) {
                log.fine("Heartbeat request sent");
            }
        }
        catch (Exception err) {
            log.log(Level.SEVERE, "Could not send Cloud Connector heartbeat message", err);
            connector.pingFail("SentienceConnectorImpl.doPing():" + err);
        }
    }

    public void onMessage(String messageId, byte[] payload, Map<String, String> props) {
        if ("HeartbeatResponse".equals(props.get("objecttype"))) {
            JSONObject obj = new JSONObject(new String(payload));
            try {
                BAbsTime cloudTime = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(obj.getString("CloudTime"));
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Heartbeat response received: " + cloudTime);
                }
                BCloudConnector connector = this.getCloudConnector();
                connector.pingOk();
            }
            catch (IOException err) {
                log.log(Level.SEVERE, "Could not decode Cloud Connector Heartbeat time", err);
            }
        }
    }

    void resetConnectorInfo() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Starting resetConnectorInfo");
        }
        this.cachedConnectionInfoMap = Collections.emptyMap();
        this.setRegistrationState(BSystemRegistrationState.unregistered);
        this.getCloudConnector().setId("");
        this.myPublicKey = null;
        this.myPrivateKey = null;
        try {
            IKeyStore keyStore = CertManagerFactory.getInstance().getKeyStore();
            keyStore.deleteEntry(this.getKeyStoreKeyName() + "pub");
            keyStore.deleteEntry(this.getKeyStoreKeyName());
            String systemClass = AccessController.doPrivileged(() -> {
                String s = System.getenv("cloud_id_systemClass");
                return s != null ? s : "N4";
            });
            this.initConnectorInfo(systemClass);
            this.initializeKeys();
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Completed resetConnectorInfo");
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error clearing or setting Sentience keys from local keystore", e);
        }
        this.validateSystemInfo();
        this.reconnectFuture = this.getCloudConnector().scheduleExec("SentienceConnectorImpl.resetConnectorInfo()", Executors.callable(() -> this.getCloudConnector().reconnectAsync("reset")), 0L, TimeUnit.NANOSECONDS);
    }

    private void initConnectorInfo(String systemClass) {
        if (systemClass == null || "N4".equals(systemClass)) {
            String safeStationName = this.getSafeStationName();
            this.setSystemId(this.generateSystemId(systemClass, safeStationName));
            this.setSystemOwnershipCode(BSentienceConnectorImpl.makeSystemOwnershipCode(24));
        } else if ("GUID".equals(systemClass)) {
            this.setSystemId(BSentienceConnectorImpl.generateGuidSystemId());
            this.setSystemOwnershipCode(BSentienceConnectorImpl.makeSystemOwnershipCode(24));
        } else {
            throw new IllegalArgumentException("Invalid systemClass for initializing Sentience Connector Impl: " + systemClass);
        }
    }

    private String generateSystemId(String systemClass, String stationName) {
        if (systemClass == null || "N4".equals(systemClass)) {
            BSentienceDevTestComponent[] dtcs = (BSentienceDevTestComponent[])this.getChildren(BSentienceDevTestComponent.class);
            if (dtcs == null || dtcs.length < 1) {
                return "N4:" + stationName + ":" + Sys.getHostId();
            }
            return dtcs[0].makeSystemId(stationName);
        }
        if ("GUID".equals(systemClass)) {
            return BSentienceConnectorImpl.generateGuidSystemId();
        }
        throw new IllegalArgumentException("Invalid system class specified:" + systemClass);
    }

    private static String generateGuidSystemId() {
        return "GUID:" + UUID.randomUUID();
    }

    private String getSafeStationNameFromSystemId() {
        String sysId = this.getSystemId();
        if (sysId.contains(":")) {
            if (((BSentienceDevTestComponent[])this.getChildren(BSentienceDevTestComponent.class)).length < 1) {
                return sysId.split(":")[1];
            }
            return BSentienceDevTestComponent.getSafeStationNameFromSystemId(sysId);
        }
        return null;
    }

    private String getKeyStoreKeyName() {
        return "Cloud_" + this.getSystemId();
    }

    private int maxSafeNameLen() {
        BSentienceDevTestComponent[] dtcs = (BSentienceDevTestComponent[])this.getChildren(BSentienceDevTestComponent.class);
        if (dtcs == null || dtcs.length < 1) {
            return Sys.getHostId().contains("TITAN") ? 17 : 23;
        }
        return dtcs[0].isJace8000() ? 17 : 23;
    }

    private static String getSystemClass(String systemId) {
        if (systemId != null && systemId.contains(":")) {
            return systemId.substring(0, systemId.indexOf(":"));
        }
        throw new IllegalArgumentException("Cannot determine systemClass from systemId " + systemId);
    }

    private void validateSystemInfo() {
        try {
            String systemId = this.getSystemId();
            String systemClass = AccessController.doPrivileged(() -> {
                String s = System.getenv("cloud_id_systemClass");
                return s != null ? s : "N4";
            });
            if (systemId.isEmpty()) {
                this.initConnectorInfo(systemClass);
            } else {
                String systemClassFromId = BSentienceConnectorImpl.getSystemClass(systemId);
                if (systemClassFromId.equals(systemClass)) {
                    switch (systemClassFromId) {
                        case "N4": {
                            this.validateStandardSystemInfo(systemId);
                            break;
                        }
                        case "GUID": {
                            BSentienceConnectorImpl.validateGuidSystemId(systemId);
                            break;
                        }
                        default: {
                            String message = String.format("Invalid systemClass specified in systemId: %s", systemClassFromId);
                            this.getCloudConnector().configFatal(message);
                            throw new IllegalStateException(message);
                        }
                    }
                } else {
                    String message = String.format("System ID class %s does not match System ID environment type %s", systemClassFromId, systemClass);
                    this.getCloudConnector().configFatal(message);
                    throw new IllegalStateException(message);
                }
            }
            this.getCloudConnector().configOk();
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.format("Could not validate system id format: %s", this.getSystemId()), e);
            this.getCloudConnector().configFail(lex.getText("invalidSystemId"));
        }
    }

    private void validateStandardSystemInfo(String systemId) {
        String hostIdFromSystemId = systemId.split(":")[2];
        String hostIdFromPlatform = Sys.getHostId();
        if (!hostIdFromPlatform.equals(hostIdFromSystemId)) {
            BSentienceDevTestComponent[] dtcs = (BSentienceDevTestComponent[])this.getChildren(BSentienceDevTestComponent.class);
            if (dtcs == null || dtcs.length < 1) {
                this.resetConnectorInfo();
            } else {
                log.finest("HostID mismatch between SystemID and platform; this is normal if you are using a DevTestComponent");
            }
        }
    }

    private static void validateGuidSystemId(String systemId) {
        log.info("GUID-based systemId validated");
    }

    private void validateSentienceIdpCertificate() throws Exception {
        if (this.getCloudCertVerification()) {
            if (this.hasMessageClient()) {
                boolean validCert = false;
                SocketFactory factory = SSLSocketFactory.getDefault();
                String uri = URL_BEGIN.matcher(this.getDeviceAuthenticationUrl()).replaceFirst("");
                try (SSLSocket socket = (SSLSocket)factory.createSocket(uri, 443);){
                    Certificate[] certificates = socket.getSession().getPeerCertificates();
                    AgentInfo agent = this.getAgents().get("cloudConfig:CertObject");
                    if (agent == null) {
                        log.severe("No agents found for cloudConfig:CertObject");
                        this.disconnect();
                        this.setCertIsValid(false);
                        throw new SSLPeerUnverifiedException(lex.get("certError"));
                    }
                    BComponent bComponent = agent.getInstance().asComponent();
                    BValue value = bComponent.invoke(bComponent.getAction("extractPublicKey"), null);
                    String publicKey = value.toString();
                    for (Certificate certificate : certificates) {
                        if (!Base64.getEncoder().encodeToString(certificate.getPublicKey().getEncoded()).equals(publicKey)) continue;
                        validCert = true;
                        this.setCertIsValid(validCert);
                        break;
                    }
                }
                if (!validCert) {
                    this.disconnect();
                    this.setCertIsValid(false);
                    log.severe(lex.getText("certVerificationFailed"));
                    throw new SSLPeerUnverifiedException(lex.get("certError"));
                }
            } else {
                this.setCloudCertVerification(false);
                this.setCertIsValid(true);
                log.info("Cloud certificate validation is only needed when MessageClient is not null");
            }
        }
    }

    @NiagaraRpc(permissions="W", transports={@Transport(type=TransportType.box)})
    public String getBajaVersion(Context cx) {
        return Sys.getBajaVersion().toString();
    }

    String getSafeStationName() {
        String stationName = Sys.isStation() ? Sys.getStation().getStationName() : "offline";
        String safename = stationName.replace('_', '-');
        int maxSafeNameLen = this.maxSafeNameLen();
        if (safename.length() <= maxSafeNameLen) {
            return safename;
        }
        String nameStart = safename.substring(0, maxSafeNameLen - 2);
        for (int iterCnt = 1; iterCnt <= 99; ++iterCnt) {
            String nameCandidate = nameStart + iterCnt;
            if (BSentienceConnectorImpl.isKey(nameCandidate)) continue;
            return nameCandidate;
        }
        log.severe(String.format("Could not find safe station name for generating System ID for station %s", stationName));
        return safename.substring(0, 23);
    }

    private static boolean isKey(String keyName) {
        try {
            return CertManagerFactory.getInstance().getKeyStore().isKeyEntry(keyName);
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, exception.getMessage());
            }
            return true;
        }
    }

    private String generateSystemType() {
        String defaultSystemType = "";
        BSentienceDevTestComponent[] dtc = (BSentienceDevTestComponent[])this.getChildren(BSentienceDevTestComponent.class);
        if (dtc.length >= 1) {
            defaultSystemType = dtc[0].getDefaultSystemType();
        }
        return this.getLicenseFeature().get("systemType", defaultSystemType);
    }

    private static String makeSystemOwnershipCode(int numBytes) {
        byte[] b = new byte[numBytes];
        sRand.nextBytes(b);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numBytes; ++i) {
            sb.append(String.format("%02x", b[i]));
        }
        return sb.toString();
    }

    private void initializeKeys() throws Exception {
        if (SecurityInitializer.getInstance().isFips()) {
            log.severe("Cannot initialize keys: Honeywell Sentience Cloud Connector is incompatible with FIPS");
            this.getCloudConnector().configFatal(lex.getText("fatal.fipsMode"));
        } else if (this.areLocalKeysInitialized()) {
            this.retrieveLocalKeys();
        } else {
            HsmManager hsmManager = Nre.getHsmManager();
            if (hsmManager.hasHsmEngine()) {
                this.retrieveHsmKeys();
            } else {
                this.retrieveLocalKeys();
            }
        }
    }

    private boolean areLocalKeysInitialized() {
        try {
            log.config("Checking for existing locally initialized keys");
            String keyName = this.getKeyStoreKeyName();
            IKeyStore keyStore = CertManagerFactory.getInstance().getKeyStore();
            X509Certificate pubKeyCertByConnector = keyStore.getCertificate(keyName);
            ECPrivateKey prvKeyByConnector = (ECPrivateKey)keyStore.getKey(keyName, "".toCharArray());
            if (prvKeyByConnector != null && pubKeyCertByConnector != null && pubKeyCertByConnector.getPublicKey() != null) {
                log.fine(() -> String.format("Public/private keys by connector: public: %s; private: %s", BSentienceConnectorImpl.safespy(pubKeyCertByConnector, "ok"), BSentienceConnectorImpl.safespy(prvKeyByConnector, "ok")));
                return true;
            }
            keyName = this.getSafeStationNameFromSystemId();
            if (keyName != null) {
                X509Certificate pubKeyCertByStation = keyStore.getCertificate(keyName);
                Key prvKeyByStation = keyStore.getKey(keyName, "".toCharArray());
                log.fine(() -> String.format("Public/private keys by safeStationName: public: %s; private: %s", BSentienceConnectorImpl.safespy(pubKeyCertByStation, "ok"), BSentienceConnectorImpl.safespy(prvKeyByStation, "ok")));
                return prvKeyByStation instanceof ECPrivateKey && pubKeyCertByStation != null && pubKeyCertByStation.getPublicKey() instanceof ECPublicKey;
            }
            return false;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private void retrieveHsmKeys() throws Exception {
        log.config("Retrieving keys from HSM");
        KeyStore keyStore = KeyStore.getInstance("NiagaraHsm");
        keyStore.load(null, null);
        PublicKey publicKey = (PublicKey)keyStore.getKey("public_0", null);
        this.setSystemPublicKey(Base64.getEncoder().encodeToString(publicKey.getEncoded()));
    }

    private void retrieveLocalKeys() throws Exception {
        log.config("Retrieving keys from local keystore");
        String keyName = this.getKeyStoreKeyName();
        IKeyStore keyStore = CertManagerFactory.getInstance().getKeyStore();
        X509Certificate myCert = keyStore.getCertificate(keyName);
        if (myCert != null) {
            this.myPublicKey = (ECPublicKey)myCert.getPublicKey();
        }
        this.myPrivateKey = (ECPrivateKey)keyStore.getKey(keyName, "".toCharArray());
        if (this.myPublicKey == null || this.myPrivateKey == null) {
            X509Certificate oldCert;
            String oldKeyName = this.getSafeStationNameFromSystemId();
            if (oldKeyName != null && (oldCert = keyStore.getCertificate(oldKeyName)) != null) {
                PublicKey pubkey = oldCert.getPublicKey();
                Key prvkey = keyStore.getKey(oldKeyName, "".toCharArray());
                if (pubkey instanceof ECPublicKey && prvkey instanceof ECPrivateKey) {
                    ECPublicKey oldPubKey = (ECPublicKey)pubkey;
                    ECPrivateKey oldPrvKey = (ECPrivateKey)prvkey;
                    log.config("Found keys under deprecated key name; migrating to new key name");
                    this.myPublicKey = oldPubKey;
                    this.myPrivateKey = oldPrvKey;
                    X509Certificate[] certChain = keyStore.getCertificateChain(oldKeyName);
                    KeyPair pair = new KeyPair(this.myPublicKey, this.myPrivateKey);
                    keyStore.setKeyEntry(keyName, (Key)this.myPrivateKey, "".toCharArray(), certChain);
                    keyStore.deleteEntry(oldKeyName);
                    keyStore.deleteEntry(oldKeyName + "pub");
                    keyStore.save();
                }
            }
            if (this.myPublicKey == null || this.myPrivateKey == null) {
                log.config(() -> "Keys could not be retrieved from keystore; regenerating keypair...");
                KeyPair pair = BSentienceConnectorImpl.generateLocalKeys();
                this.myPrivateKey = (ECPrivateKey)pair.getPrivate();
                this.myPublicKey = (ECPublicKey)pair.getPublic();
                keyStore.setKeyEntry(keyName, (Key)this.myPrivateKey, "".toCharArray(), BSentienceConnectorImpl.generateLocalCertChain(pair, this.getSystemId()));
                keyStore.save();
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Sentience Keys stored in keystore");
                }
            }
        }
        this.setSystemPublicKey(Base64.getEncoder().encodeToString(this.myPublicKey.getEncoded()));
    }

    private static KeyPair generateLocalKeys() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("ECDSA", KEYGEN_PROVIDER);
        ECGenParameterSpec ecParameterSpec = new ECGenParameterSpec("P-256");
        keyGen.initialize(ecParameterSpec, sRand);
        return keyGen.generateKeyPair();
    }

    private static X509Certificate[] generateLocalCertChain(KeyPair keyPair, String systemId) throws Exception {
        Calendar cal = Calendar.getInstance();
        Date notBefore = cal.getTime();
        cal.set(1, cal.get(1) + 20);
        Date notAfter = cal.getTime();
        IX509CertificateEntry entry = X509CertificateFactory.getInstance().generateSelfSignedCert(keyPair, "sentienceConnector", String.format("CN=%s,O=Tridium,C=US", systemId), String.format("CN=%s,O=Tridium,C=US", systemId), notBefore, notAfter, IKeyPurpose.CLIENT_CERT, null, null);
        return entry.getCertificates();
    }

    private static String getChallengeParameterString(RpkChallengeParameters challengeParameters) {
        StringWriter sw = new StringWriter();
        JSONWriter jw = new JSONWriter((Appendable)sw);
        jw.object().key("SystemId").value((Object)challengeParameters.getSystemId()).key("SystemType").value((Object)challengeParameters.getSystemType()).endObject();
        return sw.toString();
    }

    private static String getRpkChallengeResponseParameterString(RpkChallengeResponseParameters responseParameters) {
        StringWriter sw = new StringWriter();
        JSONWriter jw = new JSONWriter((Appendable)sw);
        jw.object().key("SystemId").value((Object)responseParameters.getSystemId()).key("SystemType").value((Object)responseParameters.getSystemType()).key("ClientRandom").value((Object)Base64.getEncoder().encodeToString(responseParameters.getClientRandom())).key("ClientRandomSignature").value((Object)Base64.getEncoder().encodeToString(responseParameters.getClientRandomSignature())).endObject();
        return sw.toString();
    }

    private RpkChallengeResponseParameters generateRpkChallengeResponse(String challengeString, String systemId, String systemType) throws Exception {
        byte[] challenge = Base64.getDecoder().decode(challengeString);
        if (challenge == null || challenge.length != 32) {
            throw new SystemAuthenticationException("Server challenge is null or incorrect length");
        }
        byte[] clientRnd = new byte[8];
        sRand.nextBytes(clientRnd);
        byte[] buffer = new byte[40];
        System.arraycopy(challenge, 0, buffer, 0, 32);
        System.arraycopy(clientRnd, 0, buffer, 32, 8);
        byte[] signature = this.signChallengeResponse(buffer);
        return new RpkChallengeResponseParameters(systemId, systemType, clientRnd, signature);
    }

    private byte[] signChallengeResponse(byte[] saltedChallenge) throws Exception {
        byte[] signature = EMPTY_BYTES;
        if (SecurityInitializer.getInstance().isFips()) {
            log.severe("Cannot authenticate to Honeywell Sentience: Honeywell Sentience Cloud Connector is incompatible with FIPS");
            this.getCloudConnector().configFatal(lex.getText("fatal.fipsMode"));
        } else {
            HsmManager hsmManager;
            signature = this.areLocalKeysInitialized() ? this.signWithLocalKeys(saltedChallenge) : ((hsmManager = Nre.getHsmManager()).hasHsmEngine() ? BSentienceConnectorImpl.signWithHsmKeys(saltedChallenge) : this.signWithLocalKeys(saltedChallenge));
        }
        if (signature.length == 0) {
            log.warning("RPK Signature generation failed: signature is empty!");
        }
        return signature;
    }

    private static byte[] signWithHsmKeys(byte[] saltedChallenge) throws Exception {
        log.config("Authenticating using HSM keys");
        try {
            return AccessController.doPrivileged(() -> {
                KeyStore keyStore = KeyStore.getInstance("NiagaraHsm");
                keyStore.load(null, null);
                PrivateKey privateKey = (PrivateKey)keyStore.getKey("private_0", null);
                Signature signer = Signature.getInstance("SHA256WITHECDSA.NiagaraHsm");
                signer.initSign(privateKey);
                signer.update(saltedChallenge);
                return signer.sign();
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private byte[] signWithLocalKeys(byte[] saltedChallenge) throws Exception {
        log.config("Authenticating using software keys");
        Signature signer = Signature.getInstance("SHA256withECDSA");
        signer.initSign(this.myPrivateKey);
        signer.update(saltedChallenge);
        return signer.sign();
    }

    private String rpkChallenge(String systemId, String systemType, String authenticationUrl) throws Exception {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Starting RPK Challenge");
        }
        RpkChallengeParameters challengeRequestParams = new RpkChallengeParameters(systemId, systemType);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Completed RpkChallengeParameters('%s', '%s')", systemId, systemType));
        }
        String challParamStr = BSentienceConnectorImpl.getChallengeParameterString(challengeRequestParams);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Completed getChallengeParameterString(%s) with result %s", challengeRequestParams, challParamStr));
        }
        long t0 = Clock.ticks();
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Completed Clock.ticks() with result %d", t0));
        }
        String activityId = UUID.randomUUID().toString();
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.format("Sending RPK Challenge request to URI %s: %s, with activity id %s", authenticationUrl + "/api/authentication/rpkchallenge", challParamStr, activityId));
        }
        JSONObject rpkChallenge = (JSONObject)this.httpUtils.post(authenticationUrl + "/api/authentication/rpkchallenge", "application/json; charset=utf-8", Collections.singletonMap("x-activity-id", activityId), -1L, Optional.of(HttpUtils.fromStringToOutputStreamFunc((Object)challParamStr)), Optional.of(HttpUtils::fromInputStreamToJsonObject), Optional.empty());
        String challengeString = rpkChallenge.getString("ChallengeString");
        RpkChallengeResponseParameters responseParams = this.generateRpkChallengeResponse(challengeString, systemId, systemType);
        String rpkChallRespStr = BSentienceConnectorImpl.getRpkChallengeResponseParameterString(responseParams);
        activityId = UUID.randomUUID().toString();
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.format("Sending RPK Challenge Response to URI %s: %s, with activity id %s", authenticationUrl + "/api/authentication/rpkchallengeresponse", rpkChallRespStr, activityId));
        }
        JSONObject jwtObject = (JSONObject)this.httpUtils.post(authenticationUrl + "/api/authentication/rpkchallengeresponse", "application/json; charset=utf-8", Collections.singletonMap("x-activity-id", activityId), -1L, Optional.of(HttpUtils.fromStringToOutputStreamFunc((Object)rpkChallRespStr)), Optional.of(HttpUtils::fromInputStreamToJsonObject), Optional.empty());
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.format("Completed RPK Challenge - %s ms", Clock.ticks() - t0));
        }
        return jwtObject.getString("IdentityJwt");
    }

    private Map<String, ConnectionInfo> systemConnections(String bearerToken, String registrationUrl) throws IOException, HttpStatusException {
        String activityId = UUID.randomUUID().toString();
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Starting System Connections with activity id " + activityId);
        }
        Map headers = HttpUtils.makeAuthHeaderMap((String)bearerToken);
        headers.put("x-activity-id", activityId);
        long t0 = Clock.ticks();
        JSONArray connections = (JSONArray)this.httpUtils.post(registrationUrl + "/api/system/connections", "application/json; charset=utf-8", headers, -1L, Optional.empty(), Optional.of(HttpUtils::fromInputStreamToJsonArray), Optional.empty());
        HashMap<String, ConnectionInfo> map = new HashMap<String, ConnectionInfo>(connections.length());
        for (int i = 0; i < connections.length(); ++i) {
            JSONObject info = connections.getJSONObject(i);
            if (!info.has("ServerType") || !info.has("UserName") || !info.has("Password") || !info.has("Path")) continue;
            map.put(info.getString("ServerType"), new ConnectionInfo(info.getString("UserName"), info.getString("Password"), info.getString("Path")));
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.format("Completed System Connections: %s ms", Clock.ticks() - t0));
        }
        return map;
    }

    public void spy(SpyWriter out) throws Exception {
        ECPublicKey publicKey;
        out.startProps("Sentience Connector");
        out.prop((Object)"jwtExpirationClockSkew", (double)this.jwtExpirationClockSkew);
        out.prop((Object)"reconnectFuture", this.reconnectFuture);
        Map<String, ConnectionInfo> connectionInfo = this.cachedConnectionInfoMap;
        out.prop((Object)"Connection Information Size", connectionInfo.size());
        out.endProps();
        for (Map.Entry<String, ConnectionInfo> entry : connectionInfo.entrySet()) {
            out.startProps("Connection Information: " + entry.getKey());
            String password = entry.getValue().getPassword();
            if (BSentienceConnectorImpl.isSasToken(password)) {
                Map<String, String> sasParams = BSentienceConnectorImpl.parseSasToken(password);
                for (Map.Entry<String, String> stringStringEntry : sasParams.entrySet()) {
                    String sasKey = stringStringEntry.getKey();
                    StringBuilder sasValue = new StringBuilder(stringStringEntry.getValue());
                    if (SAS_KEY_SE.equals(sasKey)) {
                        try {
                            long epochSec = Long.parseLong(sasValue.toString());
                            ZonedDateTime expDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSec), ZoneId.systemDefault());
                            sasValue = new StringBuilder(expDateTime.format(SAS_DATE_FORMATTER)).append("  (").append((CharSequence)sasValue).append(')');
                        }
                        catch (Exception e) {
                            log.log(Level.CONFIG, "An error occurred while formatting the SAS token expiration date: ", e);
                        }
                    }
                    out.prop((Object)sasKey, (Object)sasValue.toString());
                }
            } else {
                BearerTokenInfo tokenInfo = new BearerTokenInfo(password);
                out.prop((Object)"algorithm", (Object)tokenInfo.getAlgorithm());
                out.prop((Object)"systemId", (Object)tokenInfo.getSystemId());
                out.prop((Object)"systemType", (Object)tokenInfo.getSystemType());
                out.prop((Object)"issuer", (Object)tokenInfo.getIssuer());
                out.prop((Object)"audience", (Object)tokenInfo.getAudience());
                out.prop((Object)"notBefore", (Object)tokenInfo.getNotBefore());
                out.prop((Object)"expirationTime", (Object)tokenInfo.getExpirationTime());
            }
            out.endProps();
        }
        out.startProps("Encryption Information");
        SecureRandom sr = sRand;
        out.prop((Object)"SecureRandom", (Object)BSentienceConnectorImpl.safespy(sr, "SecureRandom"));
        if (sr != null) {
            out.prop((Object)"SR algorithm", (Object)sr.getAlgorithm());
        }
        if ((publicKey = this.myPublicKey) != null) {
            BSentienceConnectorImpl.spy(publicKey, out);
        }
        out.prop((Object)"Private Key", (Object)BSentienceConnectorImpl.safespy(this.myPrivateKey, "Generated"));
        out.endProps();
        super.spy(out);
    }

    private static String safespy(Object o, String message) {
        return o == null ? "null" : (message != null ? message : o.getClass().toString());
    }

    private static void spy(PublicKey pubk, SpyWriter out) {
        out.prop((Object)"Public Key", (Object)Base64.getEncoder().encodeToString(pubk.getEncoded()));
        out.prop((Object)"Key algorithm", (Object)pubk.getAlgorithm());
        out.prop((Object)"Key format", (Object)pubk.getFormat());
    }

    static {
        try {
            sRand = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            sRand = new SecureRandom();
        }
        KEYGEN_PROVIDER = SecurityInitializer.getInstance().getCryptoProvider().getProvider();
        JWT_PATTERN = Pattern.compile("([^.]+)\\.([^.]+)\\.([^.]+)");
        SAS_PATTERN = Pattern.compile("(\\w+)=([^&]+)(?:&|$)");
        URL_BEGIN = Pattern.compile(REGEX);
        SAS_DATE_FORMATTER = DateTimeFormatter.ofPattern("dd-MMM-yy h:mm a z");
        EMPTY_BYTES = new byte[0];
    }

    public static final class ConnectionInfo {
        private final String userName;
        private final String password;
        private final String path;

        public ConnectionInfo(String userName, String password, String path) {
            this.userName = userName;
            this.password = password;
            this.path = path;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public String getPath() {
            return this.path;
        }
    }
}

