/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.view;

import com.tridium.ui.Binder;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.util.WbUtil;
import javax.baja.agent.AgentList;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.toolbar.BIToolBar;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbViewBinding;

public abstract class BWbView
extends BWbEditor {
    public static final Type TYPE = Sys.loadType(BWbView.class);
    public static final int CUT = 0;
    public static final int COPY = 1;
    public static final int PASTE = 2;
    public static final int DUPLICATE = 3;
    public static final int DELETE = 4;
    public static final int RENAME = 5;
    public static final int FIND = 6;
    public static final int FIND_PREV = 7;
    public static final int FIND_NEXT = 8;
    public static final int REPLACE = 9;
    public static final int GOTO = 10;
    public static final int PASTE_SPECIAL = 11;
    static final int COUNT = 12;
    static final String[] STRINGS = new String[]{"cut", "copy", "paste", "duplicate", "delete", "rename", "find", "findPrev", "findNext", "replace", "goto", "pasteSpecial"};
    private boolean[] enabled = new boolean[12];
    private BTransferWidget transferWidget;
    protected Binder binder;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIMenu[] getViewMenus() {
        return null;
    }

    public BIToolBar getViewToolBar() {
        return null;
    }

    public BWidget getViewStatusBarSupplement() {
        return null;
    }

    public void prime() {
    }

    public void activated() {
    }

    public void deactivated() {
    }

    @Override
    public void clearModified() {
        BWbShell wbShell;
        super.clearModified();
        BWidgetShell shell = this.getShell();
        if (shell instanceof BWbShell && (wbShell = (BWbShell)shell).getActiveView() == this) {
            ((BNiagaraWbShell)wbShell).clearModified(this);
        }
    }

    public static String commandIdToString(int id) {
        try {
            return STRINGS[id];
        }
        catch (Exception e) {
            return "invalid[" + id + "]";
        }
    }

    public final boolean isCommandEnabled(int id) {
        return this.enabled[id];
    }

    public final void setCommandEnabled(int id, boolean enabled) {
        if (this.enabled[id] == enabled) {
            return;
        }
        this.enabled[id] = enabled;
        this.statesChanged();
    }

    public CommandArtifact invokeCommand(int id) throws Exception {
        BTransferWidget w = this.transferWidget;
        if (w != null) {
            switch (id) {
                case 0: {
                    return w.doCut();
                }
                case 1: {
                    return w.doCopy();
                }
                case 2: {
                    return w.doPaste();
                }
                case 11: {
                    return w.doPasteSpecial();
                }
                case 3: {
                    return w.doDuplicate();
                }
                case 4: {
                    return w.doDelete();
                }
                case 5: {
                    return w.doRename();
                }
            }
        }
        throw new UnsupportedOperationException(BWbView.commandIdToString(id));
    }

    public final BTransferWidget getTransferWidget() {
        return this.transferWidget;
    }

    public final void setTransferWidget(BTransferWidget transferWidget) {
        this.transferWidget = transferWidget;
        this.updateTransferWidgetStates();
    }

    public void updateTransferWidgetStates() {
        BTransferWidget w = this.transferWidget;
        if (w == null) {
            this.enabled[0] = false;
            this.enabled[1] = false;
            this.enabled[2] = false;
            this.enabled[11] = false;
            this.enabled[3] = false;
            this.enabled[4] = false;
            this.enabled[5] = false;
        } else {
            this.enabled[0] = w.isCutEnabled();
            this.enabled[1] = w.isCopyEnabled();
            this.enabled[2] = w.isPasteEnabled();
            this.enabled[11] = w.isPasteSpecialEnabled();
            this.enabled[3] = w.isDuplicateEnabled();
            this.enabled[4] = w.isDeleteEnabled();
            this.enabled[5] = w.isRenameEnabled();
        }
        this.statesChanged();
    }

    private void statesChanged() {
        BWbShell wbShell;
        BWidgetShell shell = this.getShell();
        if (shell instanceof BWbShell && (wbShell = (BWbShell)shell).getActiveView() == this) {
            ((BNiagaraWbShell)wbShell).updateCommandStates(this);
        }
    }

    Binder getBinder() {
        if (this.binder != null) {
            return this.binder;
        }
        return WbUtil.getBinder(this.getParent());
    }

    void route(BComponentEvent event) {
    }

    void routeToSubViews(BComponentEvent event) {
        if (this.binder == null) {
            return;
        }
        BBinding[] bindings = this.binder.getAllBindings();
        for (int i = 0; i < bindings.length; ++i) {
            if (!(bindings[i] instanceof BWbViewBinding)) continue;
            ((BWbView)bindings[i].getWidget()).route(event);
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("workbench:WbViewBinding");
        return agents;
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 403: {
                this.binder = new WbViewBinder(this);
                return this.binder;
            }
            case 302: {
                return this.binder;
            }
            case 305: {
                return this;
            }
            case 401: {
                return null;
            }
            case 402: {
                if (null != this.binder) {
                    this.binder.stop();
                }
                this.binder = null;
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    class WbViewBinder
    extends Binder {
        WbViewBinder(BWbView view) {
            super((BWidget)view);
        }

        public String toString() {
            return BWbView.this.toDebugString();
        }

        public void event(BComponentEvent event) {
            super.event(event);
            BWbView.this.route(event);
            BWbView.this.routeToSubViews(event);
        }
    }
}

