/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.sidebar;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.WbCommands;
import com.tridium.workbench.util.TypeInfoSpec;
import java.util.StringTokenizer;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BToolPane;
import javax.baja.workbench.sidebar.BIWbSideBar;
import javax.baja.workbench.sidebar.IWbSideBarManager;

public final class BWbSideBarManager
extends BToolPane
implements IWbSideBarManager,
BToolPane.MenuController {
    public static final Type TYPE = Sys.loadType(BWbSideBarManager.class);
    private final Array<BIWbSideBar> bars = new Array(BIWbSideBar.class);
    private static final BModule module = Sys.loadModule((String)"workbench");

    public Type getType() {
        return TYPE;
    }

    public BWbSideBarManager() {
        this.setMenuController(this);
    }

    @Override
    public BWidget asWidget() {
        return new BBorderPane((BWidget)this, BBorder.none, BInsets.DEFAULT);
    }

    @Override
    public BIWbSideBar openSideBar(BIWbSideBar bar) {
        this.bars.add((Object)bar);
        TypeInfoSpec spec = new TypeInfoSpec(bar.asWidget().getType().getTypeInfo());
        this.addPane(spec.label, Theme.javaFx().shouldHideNonessentialIcons() ? null : spec.icon, bar.asWidget());
        return bar;
    }

    @Override
    public void closeSideBar(BIWbSideBar bar) {
        this.removePane(bar.asWidget());
        for (int i = 0; i < this.bars.size(); ++i) {
            if (this.bars.get(i) != bar) continue;
            this.bars.remove(i);
            this.commands().showSideBar.setSelected(this.hasOpenSideBars());
            return;
        }
        throw new IllegalStateException("Sidebar: " + bar.getLabel() + " not open");
    }

    private WbCommands commands() {
        return ((BNiagaraWbShell)this.getShell()).commands;
    }

    @Override
    public void closeAllSideBars() {
        this.removeAll();
        this.bars.clear();
        this.commands().showSideBar.setSelected(false);
    }

    @Override
    public boolean hasOpenSideBars() {
        return !this.bars.isEmpty();
    }

    @Override
    public String serialize() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.bars.size(); ++i) {
            BIWbSideBar bar = (BIWbSideBar)this.bars.get(i);
            s.append(bar.asWidget().getType().toString()).append(";");
        }
        s.append('|').append(this.pickle());
        return s.toString();
    }

    @Override
    public void deserialize(String serializedForm) {
        try {
            this.closeAllSideBars();
            if (serializedForm.isEmpty() || serializedForm.startsWith("|")) {
                return;
            }
            StringTokenizer top = new StringTokenizer(serializedForm, "|");
            String types = top.nextToken();
            String positions = top.nextToken();
            StringTokenizer st = new StringTokenizer(types, ";");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                TypeInfo info = Sys.getRegistry().getType(tok);
                this.openSideBar((BIWbSideBar)info.getInstance());
            }
            this.unpickle(positions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void openMode(WbCommands.Mode mode) {
        throw new UnsupportedOperationException("Sidebar modes are currently unsupported");
    }

    @Override
    public BIWbSideBar[] listSideBars() {
        return (BIWbSideBar[])this.bars.trim();
    }

    public BMenu getMenu(BToolPane toolPane, BWidget content) {
        BIWbSideBar sideBar = (BIWbSideBar)content;
        if (sideBar.hasCloseCommand()) {
            BMenu menu = new BMenu();
            menu.add(null, (Command)new CloseCommand(sideBar));
            return menu;
        }
        return null;
    }

    class CloseCommand
    extends SideBarCommand {
        CloseCommand(BIWbSideBar sideBar) {
            super(sideBar, "sideBar.close");
        }

        public CommandArtifact doInvoke() {
            BWbSideBarManager.this.closeSideBar(this.sideBar);
            return null;
        }
    }

    static class SideBarCommand
    extends Command {
        BIWbSideBar sideBar;

        SideBarCommand(BIWbSideBar sideBar, String keyBase) {
            super(sideBar.asWidget(), module, keyBase);
            this.sideBar = sideBar;
        }
    }
}

