/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.nav.tree;

import com.tridium.workbench.shell.WbMain;
import java.util.HashMap;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.NavEvent;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.tree.TreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;

public abstract class NavTreeModel
extends TreeModel {
    HashMap<BOrd, NavTreeNode> ordMap = new HashMap();

    public NavTreeNode lookup(BOrd ord) {
        return this.ordMap.get(ord);
    }

    public void add(NavTreeNode node) {
        NavTreeNode[] kids;
        if (node.navOrd != null) {
            this.ordMap.put(node.navOrd, node);
        }
        if ((kids = node.children) != null) {
            for (int i = 0; i < kids.length; ++i) {
                if (kids[i] == null) continue;
                this.add(kids[i]);
            }
        }
    }

    public void remove(NavTreeNode node) {
        NavTreeNode[] kids;
        if (this.ordMap.get(node.navOrd) == node) {
            this.ordMap.remove(node.navOrd);
        }
        if ((kids = node.children) != null) {
            for (int i = 0; i < kids.length; ++i) {
                if (kids[i] == null) continue;
                this.remove(kids[i]);
            }
        }
    }

    void remap(NavTreeNode node, BOrd oldOrd, BOrd newOrd) {
        this.ordMap.remove(oldOrd);
        this.ordMap.put(newOrd, node);
    }

    public void navEvent(NavEvent event) {
        switch (event.getId()) {
            case 1: {
                this.added(event);
                break;
            }
            case 2: {
                this.removed(event);
                break;
            }
            case 3: {
                this.renamed(event);
                break;
            }
            case 4: {
                this.reordered(event);
                break;
            }
            case 5: {
                this.replaced(event);
            }
        }
    }

    protected void added(NavEvent event) {
        NavTreeNode child;
        BINavNode childNav;
        NavTreeNode parent = this.eventToNode(event);
        if (parent != null && (childNav = parent.navNode.getNavChild(event.getNewChildName())) != null && (child = this.makeNavTreeNode(parent, childNav)) != null) {
            parent.addChild(child);
        }
    }

    protected void removed(NavEvent event) {
        NavTreeNode child;
        NavTreeNode parent = this.eventToNode(event);
        if (parent != null && (child = parent.getChild(event.getOldChildName(), false)) != null) {
            parent.removeChild(child);
        }
    }

    protected void renamed(NavEvent event) {
        NavTreeNode parent = this.eventToNode(event);
        if (parent != null) {
            parent.refresh(false);
        }
    }

    protected void reordered(NavEvent event) {
        NavTreeNode parent = this.eventToNode(event);
        if (parent != null) {
            parent.refresh(false);
        }
    }

    protected void replaced(NavEvent event) {
        NavTreeNode parent = this.eventToNode(event);
        if (parent != null && parent.children != null) {
            NavTreeNode oldChild = parent.getChild(event.getOldChildName(), false);
            BINavNode newNav = parent.navNode.getNavChild(event.getOldChildName());
            NavTreeNode newChild = null;
            if (newNav != null) {
                newChild = this.makeNavTreeNode(parent, newNav);
            }
            if (oldChild != null) {
                if (event.getFacets().getb("close", false)) {
                    oldChild.setExpanded(false);
                }
                if (newChild == null) {
                    parent.removeChild(oldChild);
                } else {
                    parent.replaceChild(oldChild, newChild);
                }
            } else if (newChild != null) {
                parent.addChild(newChild);
            }
        }
    }

    NavTreeNode eventToNode(NavEvent event) {
        NavTreeNode node = this.lookup(event.getParentOrd());
        if (node == null) {
            return null;
        }
        if (node.getNavNode() instanceof BNavFileNode) {
            return null;
        }
        return node;
    }

    public NavTreeNode makeNavTreeNode(NavTreeNode parent, BINavNode navNode) {
        BOrd ord;
        if (parent != null && parent.navNode == BLocalHost.INSTANCE && !WbMain.isKioskAccessible(ord = navNode.getNavOrd())) {
            return null;
        }
        if (navNode instanceof BComponent) {
            BComponent c = (BComponent)navNode;
            BComplex cparent = c.getParent();
            Property cprop = c.getPropertyInParent();
            if (cparent != null && cprop != null && Flags.isHidden((BComplex)cparent, (Slot)cprop)) {
                return null;
            }
        }
        return new NavTreeNode(this, parent, navNode);
    }

    void dumpOrdMap() {
        System.out.println("===== NavTreeModel.ordMap =====");
        Object[] ords = this.ordMap.keySet().toArray(new BOrd[this.ordMap.size()]);
        SortUtil.sort((Object[])ords);
        for (int i = 0; i < ords.length; ++i) {
            NavTreeNode node = this.lookup((BOrd)ords[i]);
            System.out.println(" " + ords[i] + " -> " + node.navName + " @  " + node.navOrd);
        }
        System.out.println("===============================");
    }
}

