/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.nav.tree;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.transfer.TransferUtil;
import java.util.ArrayList;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeController;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.nav.tree.NavTreeNodeRenderer;
import javax.baja.workbench.nav.tree.NavTreeSelection;

public class BNavTree
extends BTree
implements NavListener {
    public static final Type TYPE = Sys.loadType(BNavTree.class);
    NavTreeNode dragOver;
    boolean readonly = false;

    public Type getType() {
        return TYPE;
    }

    public BNavTree(NavTreeModel model) {
        super((TreeModel)model, (TreeController)new NavTreeController());
        this.setNodeRenderer(new NavTreeNodeRenderer());
        this.setSelection(new NavTreeSelection());
        this.setCutEnabled(true);
        this.setCopyEnabled(true);
        this.setPasteEnabled(true);
        this.setPasteSpecialEnabled(true);
        this.setDuplicateEnabled(true);
        this.setDeleteEnabled(true);
        this.setRenameEnabled(true);
    }

    public BNavTree(BINavNode root) {
        this(new DefaultNavTreeModel(root));
    }

    public BNavTree() {
        this((BINavNode)BNavRoot.INSTANCE);
    }

    public BObject getSelectedObject() {
        NavTreeNode node = (NavTreeNode)this.getSelection().getNode();
        if (node != null) {
            return (BObject)node.getNavNode();
        }
        return null;
    }

    public BObject[] getSelectedObjects() {
        TreeNode[] nodes = this.getSelection().getNodes();
        BObject[] objs = new BObject[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            objs[i] = (BObject)((NavTreeNode)nodes[i]).getNavNode();
        }
        return objs;
    }

    public BObject getSelectionParent() {
        TreeNode[] nodes = this.getSelection().getNodes();
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        if (nodes[0].getParent() == null) {
            return null;
        }
        BObject parent = (BObject)((NavTreeNode)nodes[0].getParent()).getNavNode();
        for (int i = 1; i < nodes.length; ++i) {
            BObject temp = (BObject)((NavTreeNode)nodes[i].getParent()).getNavNode();
            if (temp == parent) continue;
            return null;
        }
        return parent;
    }

    public void setReadonly(boolean b) {
        this.readonly = b;
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void expandToOrd(BObject base, BOrd ord) {
        try {
            BINavNode node = (BINavNode)ord.resolve(base).get();
            this.expandToNavNode(node);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)"Error", (Object)("Could not expandTo: " + ord), (Throwable)e);
        }
    }

    public void expandToNavNode(BINavNode node) throws Exception {
        NavTreeNode temp;
        NavTreeModel model = (NavTreeModel)this.getModel();
        NavTreeNode root = null;
        ArrayList<BINavNode> path = new ArrayList<BINavNode>();
        while (node != null) {
            for (int i = 0; i < model.getRootCount(); ++i) {
                BINavNode temp2 = ((NavTreeNode)model.getRoot(i)).getNavNode();
                if (!node.getNavOrd().equals((Object)temp2.getNavOrd())) continue;
                root = (NavTreeNode)model.getRoot(i);
                break;
            }
            if (root != null) break;
            path.add(0, node);
            node = node.getNavParent();
        }
        if (root == null) {
            return;
        }
        if (path.size() > 0) {
            root.setExpanded(true);
        }
        String oldname = "";
        for (int i = 0; i < path.size() - 1; ++i) {
            node = (BINavNode)path.get(i);
            if (oldname.equals(node.getNavName()) || node.getNavName() == null) continue;
            if (node instanceof BModule) {
                root = root.getChild(((BModule)node).getModuleName(), true);
                ++i;
            } else {
                root = root.getChild(node.getNavName(), true);
            }
            root.setExpanded(true);
            oldname = root.getNavNode().getNavName();
        }
        if (path.size() > 0 && (node = (BINavNode)path.get(path.size() - 1)).getNavName() != null && (temp = root.getChild(node.getNavName(), true)) != null) {
            root = temp;
        }
        this.getSelection().deselectAll();
        if (root != null) {
            this.getSelection().select((TreeNode)root);
            this.scrollNodeToVisible(root);
        }
        this.relayout();
    }

    public void setExpanded(TreeNode node, boolean exp) {
        super.setExpanded(node, exp);
        ((NavTreeNode)node).resetSession();
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    public void navEvent(NavEvent event) {
        ((NavTreeModel)this.getModel()).navEvent(event);
    }

    public TransferEnvelope getTransferData() throws Exception {
        BObject[] obj = this.getSelectedObjects();
        if (obj == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)new Mark(obj));
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        return TransferUtil.insert((BWidget)this, cx, this.getSelectedObject(), null);
    }

    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        return null;
    }

    public CommandArtifact doDuplicate() throws Exception {
        BObject[] selection = this.getSelectedObjects();
        BObject parent = this.getSelectionParent();
        if (selection.length == 0 || parent == null) {
            return null;
        }
        Mark mark = new Mark(selection);
        return TransferUtil.insert((BWidget)this, 16, mark, parent, null, null);
    }

    public CommandArtifact doDelete() throws Exception {
        BObject[] selection = this.getSelectedObjects();
        if (selection.length == 0) {
            return null;
        }
        Mark mark = new Mark(selection);
        return TransferUtil.delete((BWidget)this, mark);
    }

    public CommandArtifact doRename() throws Exception {
        BObject[] selection = this.getSelectedObjects();
        if (selection.length == 0) {
            return null;
        }
        Mark mark = new Mark(selection);
        return TransferUtil.rename((BWidget)this, mark);
    }

    public void mouseDragStarted(BMouseEvent event) {
        double y;
        if (this.readonly) {
            return;
        }
        double x = event.getX();
        NavTreeNode node = this.transferNodeAt(x, y = event.getY());
        if (node == null) {
            return;
        }
        SimpleDragRenderer dragRenderer = new SimpleDragRenderer(node.getIcon(), node.getText());
        dragRenderer.font = Theme.tree().getFont((BWidget)this);
        dragRenderer.xCursorOffset = node.getX() + Theme.tree().getExpanderWidth() + 4.0 - x;
        dragRenderer.yCursorOffset = node.getY() - y;
        boolean copyOnly = false;
        TreeNode[] nodes = this.getSelection().getNodes();
        TreeNode parent = nodes[0].getParent();
        for (int i = 1; i < nodes.length; ++i) {
            if (parent == nodes[i].getParent()) continue;
            copyOnly = true;
            break;
        }
        TransferEnvelope envelope = TransferEnvelope.make((Mark)new Mark(this.getSelectedObjects()));
        if (copyOnly) {
            this.startDrag(event, this.makeTransferContext(envelope), (DragRenderer)dragRenderer);
        } else {
            this.startDrag(event, envelope, (DragRenderer)dragRenderer);
        }
    }

    public int dragOver(TransferContext cx) {
        super.dragOver(cx);
        if (this.readonly) {
            return 0;
        }
        NavTreeNode node = this.transferNodeAt(cx.getX(), cx.getY());
        if (node != this.dragOver) {
            if (this.dragOver != null) {
                this.dragOver.isDragOver = false;
            }
            this.dragOver = node;
            if (this.dragOver != null) {
                this.dragOver.isDragOver = true;
            }
            this.repaint();
        }
        if (node == null) {
            return 0;
        }
        int mask = 48;
        return mask;
    }

    public void dragExit(TransferContext cx) {
        if (this.dragOver != null) {
            this.dragOver.isDragOver = false;
            this.dragOver = null;
            this.repaint();
        }
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        if (this.dragOver != null) {
            NavTreeNode node = this.dragOver;
            this.dragOver.isDragOver = false;
            this.dragOver = null;
            this.repaint();
            if (node != null) {
                if (node.getNavNode() instanceof BComponent && node.getNavNode() != null) {
                    ((BComponent)node.getNavNode()).lease();
                }
                TransferUtil.insert((BWidget)this, cx, (BObject)node.getNavNode(), null);
            }
        }
        return null;
    }

    NavTreeNode transferNodeAt(double x, double y) {
        BINavNode object;
        NavTreeNode node = (NavTreeNode)this.yToTreeNode(y);
        if (node != null && node.isSelection(x, y) && ((object = node.getNavNode()) instanceof BISpaceNode || object instanceof BFoxSession || object instanceof BFoxFileSpace || object instanceof BComponentSpace)) {
            return node;
        }
        return null;
    }
}

