/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import javax.baja.gx.BImage;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BTemplateTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrSupport;
import javax.baja.workbench.mgr.MgrTypeInfo;

public abstract class MgrTemplate
extends MgrSupport {
    protected static final BIcon templateIcon = BIcon.make((String)"module://icons/x16/files/ntpl.png");
    BTemplateTable table;
    MgrColumn[] cols;
    Object[] roots = new Object[0];
    boolean jobComplete;

    public MgrTemplate(BAbstractManager manager) {
        super(manager);
    }

    @Override
    public void init() {
        this.cols = this.makeColumns();
        this.updateColumns();
    }

    public abstract void updateTemplateTable(Type var1, Object[] var2);

    public final BTemplateTable getTable() {
        return this.table;
    }

    public final MgrColumn[] getColumns() {
        return this.cols;
    }

    public void updateTable() {
        if (this.hasDynamicColumns()) {
            this.updateColumns();
            this.table.updateColumns();
        }
        this.table.treeTableModel.updateTreeTable(true);
        this.table.getSelection().deselectAll();
    }

    void updateColumns() {
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i].init(this.getManager());
        }
    }

    public final int getRootCount() {
        return this.roots.length;
    }

    public final Object getRoot(int index) {
        return this.roots[index];
    }

    public final Object[] getRoots() {
        return (Object[])this.roots.clone();
    }

    public final void updateRoots(Object[] roots) {
        this.roots = (Object[])roots.clone();
        this.updateTable();
    }

    public void learnSelected() {
        MgrLearn learn = this.getManager().getLearn();
        if (learn == null) {
            return;
        }
        BLearnTable learnTable = learn.getTable();
        TableSelection learnSelection = learnTable.getSelection();
        Object[] learnSelObj = learnTable.getSelectedObjects();
        if (learnSelObj == null) {
            return;
        }
        try {
            this.updateTemplateTable(null, learnSelObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BWidget makePane() {
        String title = this.makeTableTitle();
        this.table = this.makeTable();
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)BTitlePane.makePane((String)title, (BTable)this.table));
        return pane;
    }

    public String makeTableTitle() {
        return this.manager.lexTemplateObjects;
    }

    protected BTemplateTable makeTable() {
        return new BTemplateTable(this);
    }

    protected boolean hasDynamicColumns() {
        return false;
    }

    protected abstract MgrColumn[] makeColumns();

    public boolean isDepthExpandable(int depth) {
        return true;
    }

    public boolean isGroup(Object template) {
        return false;
    }

    public boolean hasChildren(Object template) {
        if (template instanceof BComponent) {
            return ((BComponent)template).getChildComponents().length > 0;
        }
        return false;
    }

    public Object[] getChildren(Object template) {
        return ((BComponent)template).getChildComponents();
    }

    public BImage getIcon(Object template) {
        return BImage.make((BIcon)templateIcon);
    }

    public BComponent getExisting(Object template) {
        ComponentTableModel model = this.getManager().getModel().getTable().getComponentModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            BComponent comp = model.getComponentAt(i);
            if (!this.isExisting(template, comp)) continue;
            return comp;
        }
        return null;
    }

    public boolean isExisting(Object template, BComponent component) {
        return !this.isTaggable(template, component);
    }

    public boolean isTaggable(Object template, BComponent database) {
        try {
            MgrTypeInfo[] types = this.toTypes(template);
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].isMatchable(database)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    public MgrTypeInfo[] toTypes(Object template) throws Exception {
        System.out.println("MgrTemplate.toTypes invoked ?????????????");
        return MgrTypeInfo.makeArray(BComponent.TYPE);
    }

    public void toRow(Object template, MgrEditRow row) throws Exception {
    }
}

