/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.ui.theme.Theme;
import com.tridium.util.ObjectUtil;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrEditDialog;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class MgrEdit
extends TableModel {
    private static MgrTypeInfo[] noTypes = new MgrTypeInfo[0];
    public static final int DEFAULT = 0;
    public static final int ADD = 1;
    public static final int EDIT = 2;
    public static final int MATCH = 3;
    public static final int NEW = 4;
    BAbstractManager manager;
    String title;
    MgrColumn[] cols;
    ArrayList<MgrEditRow> rows;
    boolean selectAll;

    public MgrEdit(BAbstractManager manager, String title) {
        this.manager = manager;
        this.title = title;
        this.cols = this.makeColumns();
        this.rows = new ArrayList();
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public String getTitle() {
        return this.title;
    }

    public BComponent getAddContainer() {
        return this.manager.target;
    }

    public boolean isAdd() {
        return this.manager.getMgrEditState() == 1;
    }

    public boolean isEdit() {
        return this.manager.getMgrEditState() == 2;
    }

    public boolean isMatch() {
        return this.manager.getMgrEditState() == 3;
    }

    public boolean isNew() {
        return this.manager.getMgrEditState() == 4;
    }

    public final MgrColumn[] getColumns() {
        return (MgrColumn[])this.cols.clone();
    }

    protected MgrColumn[] makeColumns() {
        Object[] modelCols = this.manager.getModel().getEditableColumns();
        if (!this.manager.isTaggable()) {
            return modelCols;
        }
        Object[] tagCols = null;
        switch (this.manager.getMgrEditState()) {
            case 1: 
            case 3: 
            case 4: {
                tagCols = this.manager.getMgrTagDictionary().makeTagColumns();
                break;
            }
            case 2: {
                String namespace = this.manager.getMgrTagDictionary().getNamespace();
                tagCols = this.manager.getModel().getEditableTagColumns(namespace);
                break;
            }
        }
        if (tagCols == null) {
            return modelCols;
        }
        Array cols = new Array(modelCols);
        cols.addAll(tagCols);
        return (MgrColumn[])cols.trim();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.cols.length;
    }

    public String getColumnName(int col) {
        return this.cols[col].getDisplayName();
    }

    public Object getValueAt(int row, int col) {
        MgrEditRow r = this.getRow(row);
        MgrColumn c = this.cols[col];
        try {
            return c.toDisplayString(r.target, r.getCell(col), this.manager.getCurrentContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public Object getSubject(int row) {
        return this.getRow(row);
    }

    public BImage getRowIcon(int row) {
        return BImage.make((BIcon)this.getRow(row).getTarget().getIcon());
    }

    public MgrEditRow[] getRows() {
        return this.rows.toArray(new MgrEditRow[this.rows.size()]);
    }

    public MgrEditRow getRow(int index) {
        return this.rows.get(index);
    }

    public int indexOf(MgrEditRow row) {
        for (int i = 0; i < this.rows.size(); ++i) {
            if (this.rows.get(i) != row) continue;
            return i;
        }
        return -1;
    }

    public MgrEditRow addRow(int index, MgrEditRow row) throws Exception {
        if (row.edit != null) {
            throw new IllegalArgumentException("Row is already in another table");
        }
        this.rows.add(index, row);
        row.edit = this;
        row.loadCells();
        return row;
    }

    public MgrEditRow addRow(MgrEditRow row) throws Exception {
        return this.addRow(this.getRowCount(), row);
    }

    public MgrEditRow addRow(BComponent target) throws Exception {
        return this.addRow(this.makeRow(target, null, null));
    }

    public MgrEditRow addRow(Object discovery, MgrTypeInfo[] types) throws Exception {
        return this.addRow(this.makeRow(this.getManager().getModel().newInstance(types[0]), discovery, types));
    }

    protected MgrEditRow makeRow(BComponent target, Object discovery, MgrTypeInfo[] types) throws Exception {
        return new MgrEditRow(target, discovery, types);
    }

    public void remove(MgrEditRow row) throws Exception {
        int index = this.indexOf(row);
        if (index < 0) {
            throw new IllegalArgumentException("Row not in this table");
        }
        this.rows.remove(index);
        row.edit = null;
    }

    public void checkTargetNames() {
        MgrEditRow[] rows = this.getRows();
        if (rows.length == 0 || rows[0].getNameColumnIndex() < 0) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            MgrEditRow row = rows[i];
            String name = row.getName();
            if (name != null) continue;
            row.setName(this.getUniqueName(row));
        }
    }

    public String getUniqueName(MgrEditRow row) {
        String name = this.manager.getModel().toType(row.getTarget()).toSlotName();
        return this.getUniqueName(row, name);
    }

    public String getUniqueName(MgrEditRow row, String defaultName) {
        return ObjectUtil.generateUniqueSlotName((String)defaultName, (ObjectUtil.NameContainer)new NameContainerImpl(row));
    }

    public boolean isNameUnique(MgrEditRow row, String name) {
        BComponent parent = row.getTargetParent();
        BValue dup = parent.get(name);
        if (dup != null && dup != row.getTarget()) {
            return false;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            MgrEditRow r = this.getRow(i);
            if (parent != r.getTargetParent()) continue;
            String rn = r.getName();
            if (r == row || rn == null || !rn.equals(name)) continue;
            return false;
        }
        return true;
    }

    public static MgrTypeInfo[] getTypeIntersection(MgrEditRow[] rows) {
        if (rows == null || rows.length == 0) {
            return noTypes;
        }
        MgrTypeInfo[] intersection = rows[0].getAvailableTypes();
        if (intersection == null) {
            intersection = noTypes;
        }
        for (int i = 1; i < rows.length; ++i) {
            intersection = MgrEdit.intersect(intersection, rows[i].getAvailableTypes());
        }
        return intersection;
    }

    private static MgrTypeInfo[] intersect(MgrTypeInfo[] a1, MgrTypeInfo[] a2) {
        if (a1 == null || a1.length == 0 || a2 == null || a2.length == 0) {
            return noTypes;
        }
        ArrayList<MgrTypeInfo> list = new ArrayList<MgrTypeInfo>();
        int len1 = a1.length;
        int len2 = a2.length;
        block0: for (int i1 = 0; i1 < len1; ++i1) {
            MgrTypeInfo t1 = a1[i1];
            for (int i2 = 0; i2 < len2; ++i2) {
                if (!t1.equals(a2[i2])) continue;
                list.add(t1);
                continue block0;
            }
        }
        if (list.size() == 0) {
            return noTypes;
        }
        return list.toArray(new MgrTypeInfo[list.size()]);
    }

    public boolean getSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public CommandArtifact invoke(Context cx) throws Exception {
        if (this.rows.size() == 0) {
            return null;
        }
        this.checkTargetNames();
        if (cx != MgrController.quickContext && !this.prompt()) {
            return null;
        }
        return this.commit();
    }

    public boolean prompt() throws Exception {
        BMgrEditDialog dialog = new BMgrEditDialog(this, this.getSelectAll(), new TagTableCellRenderer());
        dialog.setScreenSizeToPreferredSize();
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        return dialog.getResult() == 1;
    }

    public void validate(MgrEditRow[] selection) throws Exception {
        for (int i = 0; i < selection.length; ++i) {
            try {
                this.validate(selection[i]);
                continue;
            }
            catch (Exception e) {
                throw new LocalizableException("workbench", selection[i].getName() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void validate(MgrEditRow row) throws Exception {
    }

    public CommandArtifact commit() throws Exception {
        boolean needAdd;
        MgrEditRow[] rows = this.getRows();
        if (rows.length == 0) {
            return null;
        }
        BComponent container = this.getAddContainer();
        Context tx = Transaction.start((BComponent)container, null);
        for (int i = 0; i < rows.length; ++i) {
            rows[i].commit(tx);
        }
        Transaction.end((BComponent)container, (Context)tx);
        boolean bl = needAdd = !rows[0].target.isMounted();
        if (needAdd) {
            return this.manager.getModel().addInstances(rows, null);
        }
        return null;
    }

    public boolean isReadonly(MgrEditRow[] selectedRows, MgrColumn col) {
        return col.isReadonly();
    }

    public class TagTableCellRenderer
    extends TableCellRenderer {
        public BBrush getBackground(TableCellRenderer.Cell cell) {
            MgrColumn col = MgrEdit.this.cols[cell.column];
            MgrEditRow row = MgrEdit.this.getRow(cell.row);
            if (!col.isCellValid(row)) {
                return BBrush.makeSolid((BColor)BColor.lightGrey);
            }
            return null;
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            MgrColumn col = MgrEdit.this.cols[cell.column];
            MgrEditRow row = MgrEdit.this.getRow(cell.row);
            if (!col.isCellValid(row)) {
                return BBrush.makeInverse((BColor)BColor.lightGray);
            }
            return Theme.table().getSelectionBackground((IStylable)this.getTable());
        }
    }

    private class NameContainerImpl
    implements ObjectUtil.NameContainer {
        MgrEditRow row;

        NameContainerImpl(MgrEditRow row) {
            this.row = row;
        }

        public boolean contains(String name) {
            return !MgrEdit.this.isNameUnique(this.row, name);
        }
    }
}

