/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.component.table;

import com.tridium.workbench.commands.PasteSpecialCommand;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.commands.RenameCommand;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.commands.ComponentReorderCommand;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class ComponentTableController
extends TableController {
    private boolean hyperlinkOnDoubleClick = true;

    public boolean isHyperlinkOnDoubleClick() {
        return this.hyperlinkOnDoubleClick;
    }

    public void setHyperlinkOnDoubleClick(boolean hyperlinkOnDoubleClick) {
        this.hyperlinkOnDoubleClick = hyperlinkOnDoubleClick;
    }

    protected void handleEnter(BKeyEvent event) {
        super.handleEnter(event);
        if (this.hyperlinkOnDoubleClick) {
            ComponentTableModel model = ((BComponentTable)this.getTable()).getComponentModel();
            int row = this.getSelection().getRow();
            BComponent component = model.getComponentAt(row);
            BOrd ord = component.getNavOrd();
            BWidgetShell shell = this.getTable().getShell();
            if (ord != null && shell instanceof BWbShell) {
                ((BWbShell)shell).hyperlink(ord);
            }
        }
    }

    protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
        super.cellDoubleClicked(event, row, column);
        if (this.hyperlinkOnDoubleClick) {
            ComponentTableModel model = ((BComponentTable)this.getTable()).getComponentModel();
            BComponent component = model.getComponentAt(row);
            BOrd ord = component.getNavOrd();
            BWidgetShell shell = this.getTable().getShell();
            if (ord != null && shell instanceof BWbShell) {
                ((BWbShell)shell).hyperlink(new HyperlinkInfo(ord, (BInputEvent)event));
            }
        }
    }

    public final BMenu makePopup(TableSubject subject) {
        return this.makePopup((ComponentTableSubject)subject);
    }

    public BMenu makePopup(ComponentTableSubject subject) {
        BComponentTable table = (BComponentTable)this.getTable();
        BComponent container = table.getContainer();
        if (subject.size() > 1) {
            return NavMenuUtil.makeMenu((BWidget)table, (Subject)subject);
        }
        BComponent active = (BComponent)subject.getActive();
        if (active != null) {
            return NavMenuUtil.makeMenu((BWidget)table, (BObject)active);
        }
        BMenu menu = new BMenu();
        menu.add("copy", (Command)new CopyCommand((BTransferWidget)table));
        menu.add("cut", (Command)new CutCommand((BTransferWidget)table));
        menu.add("paste", (Command)new PasteCommand((BTransferWidget)table));
        menu.add("pasteSpecial", (Command)new PasteSpecialCommand((BTransferWidget)table, container));
        menu.add("duplicate", (Command)new DuplicateCommand((BTransferWidget)table));
        menu.add("sep1", (BValue)new BSeparator());
        menu.add("delete", (Command)new DeleteCommand((BTransferWidget)table));
        menu.add("sep2", (BValue)new BSeparator());
        menu.add("rename", (Command)new RenameCommand((BTransferWidget)table));
        menu.add("reorder", (Command)new ComponentReorderCommand((BWidget)table, container));
        return menu;
    }
}

