/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.commands;

import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.workbench.util.BLinkPad;
import javax.baja.nre.util.Array;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;

public class LinkCommand
extends Command {
    BComponent[] sources;
    BComponent[] targets;
    String sourceSlotName;
    String targetSlotName;

    public LinkCommand(BWidgetShell shell, BComponent source, Slot sourceSlot, BComponent target, Slot targetSlot) {
        super((BWidget)shell, "link");
        this.sources = new BComponent[]{source};
        this.sourceSlotName = sourceSlot == null ? null : sourceSlot.getName();
        this.targets = new BComponent[]{target};
        this.targetSlotName = targetSlot == null ? null : targetSlot.getName();
    }

    public LinkCommand(BWidgetShell shell, BComponent[] sources, String sourceSlotName, BComponent[] targets, String targetSlotName) {
        super((BWidget)shell, "link");
        this.sources = sources;
        this.sourceSlotName = sourceSlotName;
        this.targets = targets;
        this.targetSlotName = targetSlotName;
    }

    public CommandArtifact doInvoke() throws Exception {
        if (!(this.sourceSlotName != null && this.targetSlotName != null || this.queryUser())) {
            return null;
        }
        Array linkArray = new Array(LinkInfo.class, this.sources.length * this.targets.length);
        for (int i = 0; i < this.targets.length; ++i) {
            for (int j = 0; j < this.sources.length; ++j) {
                linkArray.add((Object)new LinkInfo(this.targets[i], this.targets[i].makeLink(this.sources[j], this.sources[j].getSlot(this.sourceSlotName), this.targets[i].getSlot(this.targetSlotName), null)));
            }
        }
        Artifact art = new Artifact((LinkInfo[])linkArray.trim());
        art.redo();
        return art;
    }

    private boolean queryUser() {
        BLinkPad pad = new BLinkPad(this.sources, this.targets);
        if (pad.openInDialog(this.getOwner(), this.sourceSlotName, this.targetSlotName)) {
            this.sources = pad.getSourceArray();
            this.targets = pad.getTargetArray();
            this.sourceSlotName = pad.getSourceSlotName();
            this.targetSlotName = pad.getTargetSlotName();
            return true;
        }
        return false;
    }

    private static class LinkInfo {
        BComponent target;
        BLink link;
        String slotName = "";

        LinkInfo(BComponent target, BLink link) {
            this.target = target;
            this.link = link;
        }

        void add() {
            this.slotName = ((ComponentSlotMap)this.target.fw(1)).generateUniqueSlotName("Link");
            this.target.add(this.slotName, (BValue)this.link);
        }

        void remove(Context cx) {
            this.target.remove(this.slotName, cx);
        }
    }

    static class Artifact
    implements CommandArtifact {
        LinkInfo[] links;

        Artifact(LinkInfo[] links) {
            this.links = links;
        }

        public void redo() throws Exception {
            for (int i = 0; i < this.links.length; ++i) {
                this.links[i].add();
            }
        }

        public void undo() throws Exception {
            if (this.links.length == 0) {
                return;
            }
            Context tx = Transaction.start((BComponent)this.links[0].target, null);
            for (int i = 0; i < this.links.length; ++i) {
                this.links[i].remove(tx);
            }
            Transaction.end((BComponent)this.links[0].target, (Context)tx);
        }
    }
}

